/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.fixeddeposits;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.EnumOptionDataIdSerializer;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.savings.data.ClosingOfSavingsAccounts;
import org.apache.fineract.portfolio.savings.data.FixedDepositAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.data.SavingsActivation;
import org.apache.fineract.portfolio.savings.data.SavingsApproval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FixedDepositImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FixedDepositImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public FixedDepositImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList savings = new ArrayList();
        ArrayList approvalDates = new ArrayList();
        ArrayList activationDates = new ArrayList();
        ArrayList closedOnDates = new ArrayList();
        ArrayList statuses = new ArrayList();
        this.readExcelFile(workbook, savings, approvalDates, activationDates, closedOnDates, statuses, locale, dateFormat);
        return this.importEntity(workbook, savings, approvalDates, activationDates, closedOnDates, statuses, dateFormat);
    }

    private void readExcelFile(Workbook workbook, List<FixedDepositAccountData> savings, List<SavingsApproval> approvalDates, List<SavingsActivation> activationDates, List<ClosingOfSavingsAccounts> closedOnDate, List<String> statuses, String locale, String dateFormat) {
        Sheet savingsSheet = workbook.getSheet("FixedDeposit");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)savingsSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = savingsSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)27)) continue;
            savings.add(this.readSavings(workbook, statuses, row, locale, dateFormat));
            approvalDates.add(this.readSavingsApproval(row, locale, dateFormat));
            activationDates.add(this.readSavingsActivation(row, locale, dateFormat));
            closedOnDate.add(this.readSavingsClosed(row, locale, dateFormat));
        }
    }

    private ClosingOfSavingsAccounts readSavingsClosed(Row row, String locale, String dateFormat) {
        LocalDate closedOnDate = ImportHandlerUtils.readAsDate((int)24, (Row)row);
        Long onAccountClosureId = ImportHandlerUtils.readAsLong((int)25, (Row)row);
        Long toSavingsAccountId = ImportHandlerUtils.readAsLong((int)26, (Row)row);
        if (closedOnDate != null) {
            return ClosingOfSavingsAccounts.importInstance(null, (LocalDate)closedOnDate, (Long)onAccountClosureId, (Long)toSavingsAccountId, null, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private SavingsActivation readSavingsActivation(Row row, String locale, String dateFormat) {
        LocalDate activationDate = ImportHandlerUtils.readAsDate((int)6, (Row)row);
        if (activationDate != null) {
            return SavingsActivation.importInstance((LocalDate)activationDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private SavingsApproval readSavingsApproval(Row row, String locale, String dateFormat) {
        LocalDate approvalDate = ImportHandlerUtils.readAsDate((int)5, (Row)row);
        if (approvalDate != null) {
            return SavingsApproval.importInstance((LocalDate)approvalDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private FixedDepositAccountData readSavings(Workbook workbook, List<String> statuses, Row row, String locale, String dateFormat) {
        String productName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        Long productId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Products"), (String)productName);
        String fieldOfficerName = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Long fieldOfficerId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)fieldOfficerName);
        LocalDate submittedOnDate = ImportHandlerUtils.readAsDate((int)4, (Row)row);
        String interestCompoundingPeriodType = ImportHandlerUtils.readAsString((int)7, (Row)row);
        Long interestCompoundingPeriodTypeId = null;
        EnumOptionData interestCompoundingPeriodTypeEnum = null;
        if (interestCompoundingPeriodType != null) {
            if (interestCompoundingPeriodType.equalsIgnoreCase("Daily")) {
                interestCompoundingPeriodTypeId = 1L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Monthly")) {
                interestCompoundingPeriodTypeId = 4L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Quarterly")) {
                interestCompoundingPeriodTypeId = 5L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Semi-Annual")) {
                interestCompoundingPeriodTypeId = 6L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Annually")) {
                interestCompoundingPeriodTypeId = 7L;
            }
            interestCompoundingPeriodTypeEnum = new EnumOptionData(interestCompoundingPeriodTypeId, null, null);
        }
        String interestPostingPeriodType = ImportHandlerUtils.readAsString((int)8, (Row)row);
        Long interestPostingPeriodTypeId = null;
        EnumOptionData interestPostingPeriodTypeEnum = null;
        if (interestPostingPeriodType != null) {
            if (interestPostingPeriodType.equalsIgnoreCase("Monthly")) {
                interestPostingPeriodTypeId = 4L;
            } else if (interestPostingPeriodType.equalsIgnoreCase("Quarterly")) {
                interestPostingPeriodTypeId = 5L;
            } else if (interestPostingPeriodType.equalsIgnoreCase("Annually")) {
                interestPostingPeriodTypeId = 7L;
            } else if (interestPostingPeriodType.equalsIgnoreCase("BiAnnual")) {
                interestPostingPeriodTypeId = 6L;
            }
            interestPostingPeriodTypeEnum = new EnumOptionData(interestPostingPeriodTypeId, null, null);
        }
        String interestCalculationType = ImportHandlerUtils.readAsString((int)9, (Row)row);
        EnumOptionData interestCalculationTypeEnum = null;
        if (interestCalculationType != null) {
            Long interestCalculationTypeId = null;
            if (interestCalculationType.equalsIgnoreCase("Daily Balance")) {
                interestCalculationTypeId = 1L;
            } else if (interestCalculationType.equalsIgnoreCase("Average Daily Balance")) {
                interestCalculationTypeId = 2L;
            }
            interestCalculationTypeEnum = new EnumOptionData(interestCalculationTypeId, null, null);
        }
        String interestCalculationDaysInYearType = ImportHandlerUtils.readAsString((int)10, (Row)row);
        Long interestCalculationDaysInYearTypeId = null;
        EnumOptionData interestCalculationDaysInYearTypeEnum = null;
        if (interestCalculationDaysInYearType != null) {
            if (interestCalculationDaysInYearType.equalsIgnoreCase("360 Days")) {
                interestCalculationDaysInYearTypeId = 360L;
            } else if (interestCalculationDaysInYearType.equalsIgnoreCase("365 Days")) {
                interestCalculationDaysInYearTypeId = 365L;
            }
            interestCalculationDaysInYearTypeEnum = new EnumOptionData(interestCalculationDaysInYearTypeId, null, null);
        }
        Integer lockinPeriodFrequency = ImportHandlerUtils.readAsInt((int)11, (Row)row);
        String lockinPeriodFrequencyType = ImportHandlerUtils.readAsString((int)12, (Row)row);
        Long lockinPeriodFrequencyTypeId = null;
        EnumOptionData lockinPeriodFrequencyTypeEnum = null;
        if (lockinPeriodFrequencyType != null) {
            if (lockinPeriodFrequencyType.equalsIgnoreCase("Days")) {
                lockinPeriodFrequencyTypeId = 0L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase("Weeks")) {
                lockinPeriodFrequencyTypeId = 1L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase("Months")) {
                lockinPeriodFrequencyTypeId = 2L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase("Years")) {
                lockinPeriodFrequencyTypeId = 3L;
            }
            lockinPeriodFrequencyTypeEnum = new EnumOptionData(lockinPeriodFrequencyTypeId, null, null);
        }
        BigDecimal depositAmount = null;
        if (ImportHandlerUtils.readAsDouble((int)13, (Row)row) != null) {
            depositAmount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)13, (Row)row));
        }
        Integer depositPeriod = ImportHandlerUtils.readAsInt((int)14, (Row)row);
        String depositPeriodFrequency = ImportHandlerUtils.readAsString((int)15, (Row)row);
        Long depositPeriodFrequencyId = null;
        if (depositPeriodFrequency != null) {
            if (depositPeriodFrequency.equalsIgnoreCase("Days")) {
                depositPeriodFrequencyId = 0L;
            } else if (depositPeriodFrequency.equalsIgnoreCase("Weeks")) {
                depositPeriodFrequencyId = 1L;
            } else if (depositPeriodFrequency.equalsIgnoreCase("Months")) {
                depositPeriodFrequencyId = 2L;
            } else if (depositPeriodFrequency.equalsIgnoreCase("Years")) {
                depositPeriodFrequencyId = 3L;
            }
        }
        String externalId = ImportHandlerUtils.readAsString((int)16, (Row)row);
        String clientName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        ArrayList<SavingsAccountChargeData> charges = new ArrayList<SavingsAccountChargeData>();
        String charge1 = ImportHandlerUtils.readAsString((int)18, (Row)row);
        String charge2 = ImportHandlerUtils.readAsString((int)21, (Row)row);
        if (charge1 != null) {
            if (ImportHandlerUtils.readAsDouble((int)19, (Row)row) != null) {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)18, (Row)row), BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)19, (Row)row)), ImportHandlerUtils.readAsDate((int)20, (Row)row)));
            }
        } else {
            charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)18, (Row)row), null, ImportHandlerUtils.readAsDate((int)20, (Row)row)));
        }
        if (charge2 != null) {
            if (ImportHandlerUtils.readAsDouble((int)22, (Row)row) != null) {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)21, (Row)row), BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)22, (Row)row)), ImportHandlerUtils.readAsDate((int)23, (Row)row)));
            } else {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)21, (Row)row), null, ImportHandlerUtils.readAsDate((int)23, (Row)row)));
            }
        }
        String status = ImportHandlerUtils.readAsString((int)27, (Row)row);
        statuses.add(status);
        Long clientId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientName);
        return FixedDepositAccountData.importInstance((Long)clientId, (Long)productId, (Long)fieldOfficerId, (LocalDate)submittedOnDate, (EnumOptionData)interestCompoundingPeriodTypeEnum, (EnumOptionData)interestPostingPeriodTypeEnum, (EnumOptionData)interestCalculationTypeEnum, (EnumOptionData)interestCalculationDaysInYearTypeEnum, (Integer)lockinPeriodFrequency, (EnumOptionData)lockinPeriodFrequencyTypeEnum, (BigDecimal)depositAmount, (Integer)depositPeriod, (Long)depositPeriodFrequencyId, (String)externalId, charges, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<FixedDepositAccountData> savings, List<SavingsApproval> approvalDates, List<SavingsActivation> activationDates, List<ClosingOfSavingsAccounts> closedOnDates, List<String> statuses, String dateFormat) {
        Sheet savingsSheet = workbook.getSheet("FixedDeposit");
        int successCount = 0;
        int errorCount = 0;
        String errorMessage = "";
        int progressLevel = 0;
        Long savingsId = null;
        for (int i = 0; i < savings.size(); ++i) {
            Row row = savingsSheet.getRow(savings.get(i).getRowIndex().intValue());
            Cell statusCell = row.createCell(27);
            Cell errorReportCell = row.createCell(29);
            try {
                String status = statuses.get(i);
                progressLevel = this.getProgressLevel(status);
                if (progressLevel == 0) {
                    CommandProcessingResult result = this.importSavings(savings, i, dateFormat);
                    savingsId = result.getSavingsId();
                    progressLevel = 1;
                } else {
                    savingsId = ImportHandlerUtils.readAsLong((int)28, (Row)savingsSheet.getRow(savings.get(i).getRowIndex().intValue()));
                }
                if (progressLevel <= 1) {
                    progressLevel = this.importSavingsApproval(approvalDates, savingsId, i, dateFormat);
                }
                if (progressLevel <= 2) {
                    progressLevel = this.importSavingsActivation(activationDates, savingsId, i, dateFormat);
                }
                if (progressLevel <= 3) {
                    progressLevel = this.importSavingsClosing(closedOnDates, savingsId, i, dateFormat);
                }
                ++successCount;
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                continue;
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                this.writeFixedDepositErrorMessage(workbook, savingsId, errorMessage, progressLevel, statusCell, errorReportCell, row);
            }
        }
        this.setReportHeaders(savingsSheet);
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    private void writeFixedDepositErrorMessage(Workbook workbook, Long savingsId, String errorMessage, int progressLevel, Cell statusCell, Cell errorReportCell, Row row) {
        String status = "";
        if (progressLevel == 0) {
            status = "Creation failed";
        } else if (progressLevel == 1) {
            status = "Approval failed";
        } else if (progressLevel == 2) {
            status = "Activation failed";
        }
        statusCell.setCellValue(status);
        statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.RED));
        if (progressLevel > 0) {
            row.createCell(28).setCellValue((double)savingsId.longValue());
        }
        errorReportCell.setCellValue(errorMessage);
    }

    private int importSavingsClosing(List<ClosingOfSavingsAccounts> closedOnDates, Long savingsId, int i, String dateFormat) {
        if (closedOnDates.get(i) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, closedOnDates.get(i).getLocale()));
            String payload = gsonBuilder.create().toJson((Object)closedOnDates.get(i));
            CommandWrapper commandRequest = new CommandWrapperBuilder().closeFixedDepositAccount(savingsId).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 4;
    }

    private CommandProcessingResult importSavings(List<FixedDepositAccountData> savings, int i, String dateFormat) {
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, savings.get(i).getLocale()));
        gsonBuilder.registerTypeAdapter(EnumOptionData.class, (Object)new EnumOptionDataIdSerializer());
        JsonObject savingsJsonob = gsonBuilder.create().toJsonTree((Object)savings.get(i)).getAsJsonObject();
        savingsJsonob.remove("withdrawalFeeForTransfers");
        JsonArray chargesJsonAr = savingsJsonob.getAsJsonArray("charges");
        for (int j = 0; j < chargesJsonAr.size(); ++j) {
            JsonElement chargesJsonElement = chargesJsonAr.get(j);
            JsonObject chargeJsonOb = chargesJsonElement.getAsJsonObject();
            chargeJsonOb.remove("penalty");
        }
        if (chargesJsonAr.get(0).getAsJsonObject().toString().equals("{}")) {
            savingsJsonob.remove("charges");
        }
        String payload = savingsJsonob.toString();
        CommandWrapper commandRequest = new CommandWrapperBuilder().createFixedDepositAccount().withJson(payload).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private int importSavingsApproval(List<SavingsApproval> approvalDates, Long savingsId, int i, String dateFormat) {
        if (approvalDates.get(i) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, approvalDates.get(i).getLocale()));
            String payload = gsonBuilder.create().toJson((Object)approvalDates.get(i));
            CommandWrapper commandRequest = new CommandWrapperBuilder().approveFixedDepositAccountApplication(savingsId).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 2;
    }

    private int importSavingsActivation(List<SavingsActivation> activationDates, Long savingsId, int i, String dateFormat) {
        if (activationDates.get(i) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, activationDates.get(i).getLocale()));
            String payload = gsonBuilder.create().toJson((Object)activationDates.get(i));
            CommandWrapper commandRequest = new CommandWrapperBuilder().fixedDepositAccountActivation(savingsId).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 3;
    }

    private int getProgressLevel(String status) {
        if (status == null || status.equals("Creation failed")) {
            return 0;
        }
        if (status.equals("Approval failed")) {
            return 1;
        }
        if (status.equals("Activation failed")) {
            return 2;
        }
        return 0;
    }

    private void setReportHeaders(Sheet savingsSheet) {
        savingsSheet.setColumnWidth(27, 4000);
        Row rowHeader = savingsSheet.getRow(0);
        ImportHandlerUtils.writeString((int)27, (Row)rowHeader, (String)"Status");
        ImportHandlerUtils.writeString((int)28, (Row)rowHeader, (String)"Savings ID");
        ImportHandlerUtils.writeString((int)29, (Row)rowHeader, (String)"Failure Report");
    }
}

