/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DateSerializer
implements JsonSerializer<LocalDate> {
    private final String dateFormat;
    private String localeCode;

    public DateSerializer(String dateFormat, String localeCode) {
        this.dateFormat = dateFormat;
        this.localeCode = localeCode;
    }

    public DateSerializer(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public JsonElement serialize(LocalDate src, Type typeOfSrc, JsonSerializationContext context) {
        DateTimeFormatter formatter = StringUtils.isNotEmpty((CharSequence)this.localeCode) ? DateTimeFormatter.ofPattern(this.dateFormat, Locale.of(this.localeCode)) : DateTimeFormatter.ofPattern(this.dateFormat);
        return new JsonPrimitive(src.format(formatter));
    }
}

