/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.sharedaccount;

import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountChargeData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharedAccountImportHandler
implements ImportHandler {
    public static final String ZERO = "0";
    public static final String SHARE = "share";
    public static final String EMPTY_STR = "";
    private static final Logger LOG = LoggerFactory.getLogger(SharedAccountImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public SharedAccountImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList shareAccountDataList = new ArrayList();
        ArrayList statuses = new ArrayList();
        this.readExcelFile(workbook, shareAccountDataList, statuses, locale, dateFormat);
        return this.importEntity(workbook, shareAccountDataList, dateFormat);
    }

    private void readExcelFile(Workbook workbook, List<ShareAccountData> shareAccountDataList, List<String> statuses, String locale, String dateFormat) {
        Sheet sharedAccountsSheet = workbook.getSheet("SharedAccounts");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)sharedAccountsSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = sharedAccountsSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)25)) continue;
            shareAccountDataList.add(this.readSharedAccount(workbook, row, statuses, locale, dateFormat));
        }
    }

    private ShareAccountData readSharedAccount(Workbook workbook, Row row, List<String> statuses, String locale, String dateFormat) {
        String chargeName;
        String clientName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        Long clientId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientName);
        String productName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        Long productId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("SharedProducts"), (String)productName);
        LocalDate submittedOnDate = ImportHandlerUtils.readAsDate((int)2, (Row)row);
        String externalId = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Integer totNoOfShares = ImportHandlerUtils.readAsInt((int)6, (Row)row);
        Long defaultSavingsAccountId = ImportHandlerUtils.readAsLong((int)9, (Row)row);
        Integer minimumActivePeriodDays = ImportHandlerUtils.readAsInt((int)10, (Row)row);
        Integer minimumActivePeriodFrequencyType = 0;
        Integer lockInPeriod = ImportHandlerUtils.readAsInt((int)11, (Row)row);
        Integer lockPeriodFrequencyType = null;
        if (ImportHandlerUtils.readAsString((int)12, (Row)row) != null) {
            if (ImportHandlerUtils.readAsString((int)12, (Row)row).equals("Days")) {
                lockPeriodFrequencyType = 0;
            } else if (ImportHandlerUtils.readAsString((int)12, (Row)row).equals("Weeks")) {
                lockPeriodFrequencyType = 1;
            } else if (ImportHandlerUtils.readAsString((int)12, (Row)row).equals("Months")) {
                lockPeriodFrequencyType = 2;
            } else if (ImportHandlerUtils.readAsString((int)12, (Row)row).equals("Years")) {
                lockPeriodFrequencyType = 3;
            }
        }
        LocalDate applicationDate = ImportHandlerUtils.readAsDate((int)13, (Row)row);
        Boolean allowDividendCalc = ImportHandlerUtils.readAsBoolean((int)14, (Row)row);
        ArrayList<ShareAccountChargeData> charges = new ArrayList<ShareAccountChargeData>();
        for (int cellNo = 15; cellNo < 19 && (chargeName = ImportHandlerUtils.readAsString((int)cellNo, (Row)row)) != null && !chargeName.equals(ZERO); cellNo += 2) {
            Long chargeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("SharedProducts"), (String)chargeName);
            BigDecimal amount = null;
            if (ImportHandlerUtils.readAsDouble((int)(cellNo + 1), (Row)row) != null) {
                amount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)(cellNo + 1), (Row)row));
            }
            ShareAccountChargeData shareAccountChargeData = new ShareAccountChargeData(chargeId, amount);
            charges.add(shareAccountChargeData);
        }
        String status = ImportHandlerUtils.readAsString((int)25, (Row)row);
        statuses.add(status);
        return ShareAccountData.importInstance((Long)clientId, (Long)productId, (Integer)totNoOfShares, (String)externalId, (LocalDate)submittedOnDate, (Integer)minimumActivePeriodDays, (Integer)minimumActivePeriodFrequencyType, (Integer)lockInPeriod, (Integer)lockPeriodFrequencyType, (LocalDate)applicationDate, (Boolean)allowDividendCalc, charges, (Long)defaultSavingsAccountId, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<ShareAccountData> shareAccountDataList, String dateFormat) {
        Sheet sharedAccountsSheet = workbook.getSheet("SharedAccounts");
        int successCount = 0;
        int errorCount = 0;
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        for (ShareAccountData shareAccountData : shareAccountDataList) {
            try {
                String payload = gsonBuilder.create().toJson((Object)shareAccountData);
                CommandWrapper commandRequest = new CommandWrapperBuilder().createAccount(SHARE).withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = sharedAccountsSheet.getRow(shareAccountData.getRowIndex().intValue()).createCell(25);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)sharedAccountsSheet, (Integer)shareAccountData.getRowIndex(), (String)errorMessage, (int)25);
            }
        }
        sharedAccountsSheet.setColumnWidth(25, 4000);
        ImportHandlerUtils.writeString((int)25, (Row)sharedAccountsSheet.getRow(500), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

