/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class LoanProductSheetPopulator
extends AbstractWorkbookPopulator {
    private List<LoanProductData> products;
    private static final int ID_COL = 0;
    private static final int NAME_COL = 1;
    private static final int FUND_NAME_COL = 2;
    private static final int PRINCIPAL_COL = 3;
    private static final int MIN_PRINCIPAL_COL = 4;
    private static final int MAX_PRINCIPAL_COL = 5;
    private static final int NO_OF_REPAYMENTS_COL = 6;
    private static final int MIN_REPAYMENTS_COL = 7;
    private static final int MAX_REPAYMENTS_COL = 8;
    private static final int REPAYMENT_EVERY_COL = 9;
    private static final int REPAYMENT_FREQUENCY_COL = 10;
    private static final int INTEREST_RATE_COL = 11;
    private static final int MIN_INTEREST_RATE_COL = 12;
    private static final int MAX_INTEREST_RATE_COL = 13;
    private static final int INTEREST_RATE_FREQUENCY_COL = 14;
    private static final int AMORTIZATION_TYPE_COL = 15;
    private static final int INTEREST_TYPE_COL = 16;
    private static final int INTEREST_CALCULATION_PERIOD_TYPE_COL = 17;
    private static final int IN_ARREARS_TOLERANCE_COL = 18;
    private static final int TRANSACTION_PROCESSING_STRATEGY_NAME_COL = 19;
    private static final int GRACE_ON_PRINCIPAL_PAYMENT_COL = 20;
    private static final int GRACE_ON_INTEREST_PAYMENT_COL = 21;
    private static final int GRACE_ON_INTEREST_CHARGED_COL = 22;
    private static final int START_DATE_COL = 23;
    private static final int CLOSE_DATE_COL = 24;

    public LoanProductSheetPopulator(List<LoanProductData> products) {
        this.products = products;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int rowIndex = 1;
        Sheet productSheet = workbook.createSheet("Products");
        this.setLayout(productSheet);
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        for (LoanProductData product : this.products) {
            Row row = productSheet.createRow(rowIndex++);
            this.writeLong(0, row, product.getId().longValue());
            this.writeString(1, row, product.getName().trim().replaceAll("[ )(]", "_"));
            if (product.getFundName() != null) {
                this.writeString(2, row, product.getFundName());
            }
            this.writeBigDecimal(3, row, product.getPrincipal());
            if (product.getMinPrincipal() != null) {
                this.writeBigDecimal(4, row, product.getMinPrincipal());
            } else {
                this.writeInt(4, row, 1);
            }
            if (product.getMaxPrincipal() != null) {
                this.writeBigDecimal(5, row, product.getMaxPrincipal());
            } else {
                this.writeInt(5, row, 999999999);
            }
            int numberOfRepayments = product.getNumberOfRepayments();
            if (product.getRepaymentFrequencyType().getValue().equalsIgnoreCase("Semi Month")) {
                numberOfRepayments *= product.getRepaymentEvery().intValue();
            }
            this.writeInt(6, row, numberOfRepayments);
            if (product.getMinNumberOfRepayments() != null) {
                this.writeInt(7, row, product.getMinNumberOfRepayments().intValue());
            } else {
                this.writeInt(7, row, 1);
            }
            if (product.getMaxNumberOfRepayments() != null) {
                this.writeInt(8, row, product.getMaxNumberOfRepayments().intValue());
            } else {
                this.writeInt(8, row, 999999999);
            }
            this.writeInt(9, row, product.getRepaymentEvery().intValue());
            this.writeString(10, row, product.getRepaymentFrequencyType().getValue());
            this.writeBigDecimal(11, row, product.getInterestRatePerPeriod());
            if (product.getMinInterestRatePerPeriod() != null) {
                this.writeBigDecimal(12, row, product.getMinInterestRatePerPeriod());
            } else {
                this.writeInt(12, row, 1);
            }
            if (product.getMaxInterestRatePerPeriod() != null) {
                this.writeBigDecimal(13, row, product.getMaxInterestRatePerPeriod());
            } else {
                this.writeInt(13, row, 999999999);
            }
            this.writeString(14, row, product.getInterestRateFrequencyType().getValue());
            this.writeString(15, row, product.getAmortizationType().getValue());
            this.writeString(16, row, product.getInterestType().getValue());
            this.writeString(17, row, product.getInterestCalculationPeriodType().getValue());
            if (product.getInArrearsTolerance() != null) {
                this.writeBigDecimal(18, row, product.getInArrearsTolerance());
            }
            this.writeString(19, row, product.getTransactionProcessingStrategyName());
            if (product.getGraceOnPrincipalPayment() != null) {
                this.writeInt(20, row, product.getGraceOnPrincipalPayment().intValue());
            }
            if (product.getGraceOnInterestPayment() != null) {
                this.writeInt(21, row, product.getGraceOnInterestPayment().intValue());
            }
            if (product.getGraceOnInterestCharged() != null) {
                this.writeInt(22, row, product.getGraceOnInterestCharged().intValue());
            }
            if (product.getStartDate() != null) {
                this.writeDate(23, row, product.getStartDate().toString(), dateCellStyle, dateFormat);
            } else {
                this.writeDate(23, row, "1/1/1970", dateCellStyle, dateFormat);
            }
            if (product.getCloseDate() != null) {
                this.writeDate(24, row, product.getCloseDate().toString(), dateCellStyle, dateFormat);
            } else {
                this.writeDate(24, row, "1/1/2040", dateCellStyle, dateFormat);
            }
            productSheet.protectSheet("");
        }
    }

    private void setLayout(Sheet worksheet) {
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 4000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 6000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(17, 4000);
        worksheet.setColumnWidth(18, 4000);
        worksheet.setColumnWidth(19, 4000);
        worksheet.setColumnWidth(20, 4000);
        worksheet.setColumnWidth(21, 6000);
        worksheet.setColumnWidth(22, 6000);
        worksheet.setColumnWidth(23, 4000);
        worksheet.setColumnWidth(24, 4000);
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        this.writeString(0, rowHeader, "ID");
        this.writeString(1, rowHeader, "Name");
        this.writeString(2, rowHeader, "Fund");
        this.writeString(3, rowHeader, "Principal");
        this.writeString(4, rowHeader, "Min Principal");
        this.writeString(5, rowHeader, "Max Principal");
        this.writeString(6, rowHeader, "# of Repayments");
        this.writeString(7, rowHeader, "Min Repayments");
        this.writeString(8, rowHeader, "Max Repayments");
        this.writeString(9, rowHeader, "Repayment Every");
        this.writeString(10, rowHeader, "Frequency");
        this.writeString(11, rowHeader, "Interest");
        this.writeString(12, rowHeader, "Min Interest");
        this.writeString(13, rowHeader, "Max Interest");
        this.writeString(14, rowHeader, "Frequency");
        this.writeString(15, rowHeader, "Amortization Type");
        this.writeString(16, rowHeader, "Interest Type");
        this.writeString(17, rowHeader, "Interest Calculation Period");
        this.writeString(18, rowHeader, "In Arrears Tolerance");
        this.writeString(19, rowHeader, "Transaction Processing Strategy");
        this.writeString(20, rowHeader, "Grace On Principal Payment");
        this.writeString(21, rowHeader, "Grace on Interest Payment");
        this.writeString(22, rowHeader, "Grace on Interest Charged");
        this.writeString(23, rowHeader, "Start Date");
        this.writeString(24, rowHeader, "End Date");
    }

    public List<LoanProductData> getProducts() {
        return this.products;
    }

    public Integer getProductsSize() {
        return this.products.size();
    }
}

