/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class EmailConfigurationValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final String EMAIL_REGEX = "^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$");
    public static final Set<String> supportedParams = new HashSet<String>(Arrays.asList("SMTP_PORT", "SMTP_PASSWORD", "SMTP_USERNAME", "SMTP_SERVER"));

    @Autowired
    public EmailConfigurationValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateUpdateConfiguration(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParams);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("email");
        String smtpUsername = this.fromApiJsonHelper.extractStringNamed("SMTP_USERNAME", element);
        baseDataValidator.reset().parameter("SMTP_USERNAME").value((Object)smtpUsername).notBlank().notExceedingLengthOf(Integer.valueOf(150));
        String smtpPassword = this.fromApiJsonHelper.extractStringNamed("SMTP_PASSWORD", element);
        baseDataValidator.reset().parameter("SMTP_PASSWORD").value((Object)smtpPassword).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        String smtpServer = this.fromApiJsonHelper.extractStringNamed("SMTP_SERVER", element);
        baseDataValidator.reset().parameter("SMTP_SERVER").value((Object)smtpServer).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        Long smtpPort = this.fromApiJsonHelper.extractLongNamed("SMTP_PORT", element);
        baseDataValidator.reset().parameter("SMTP_PORT").value((Object)smtpPort).notNull().integerGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public boolean isValidEmail(String email) {
        if (email == null || email.endsWith(".")) {
            return false;
        }
        Matcher emailMatcher = EMAIL_PATTERN.matcher(email);
        return emailMatcher.matches();
    }
}

