/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.mapper;

import jakarta.annotation.PostConstruct;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.sms.data.SmsBusinessRulesData;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Component;

@Component
public class BusinessRuleMapper
implements ResultSetExtractor<List<SmsBusinessRulesData>> {
    private String schema;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    @PostConstruct
    public void init() {
        StringBuilder sql = new StringBuilder(300);
        sql.append("sr.id as id, ");
        sql.append("sr.report_name as reportName, ");
        sql.append("sr.report_type as reportType, ");
        sql.append("sr.report_subtype as reportSubType, ");
        sql.append("sr.description as description, ");
        sql.append("sp.parameter_variable as params, ");
        sql.append("sp." + this.sqlGenerator.escape("parameter_FormatType") + " as paramType, ");
        sql.append("sp.parameter_label as paramLabel, ");
        sql.append("sp.parameter_name as paramName ");
        sql.append("from stretchy_report sr ");
        sql.append("left join stretchy_report_parameter as srp on srp.report_id = sr.id ");
        sql.append("left join stretchy_parameter as sp on sp.id = srp.parameter_id ");
        this.schema = sql.toString();
    }

    public String schema() {
        return this.schema;
    }

    public List<SmsBusinessRulesData> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<SmsBusinessRulesData> smsBusinessRulesDataList = new ArrayList<SmsBusinessRulesData>();
        SmsBusinessRulesData smsBusinessRulesData = null;
        HashMap<Long, SmsBusinessRulesData> mapOfSameObjects = new HashMap<Long, SmsBusinessRulesData>();
        while (rs.next()) {
            Long id = rs.getLong("id");
            smsBusinessRulesData = (SmsBusinessRulesData)mapOfSameObjects.get(id);
            if (smsBusinessRulesData == null) {
                String reportName = rs.getString("reportName");
                String reportType = rs.getString("reportType");
                String reportSubType = rs.getString("reportSubType");
                String paramName = rs.getString("paramName");
                String paramLabel = rs.getString("paramLabel");
                String description = rs.getString("description");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(paramLabel, paramName);
                smsBusinessRulesData = SmsBusinessRulesData.instance((Long)id, (String)reportName, (String)reportType, (String)reportSubType, hashMap, (String)description);
                mapOfSameObjects.put(id, smsBusinessRulesData);
                smsBusinessRulesDataList.add(smsBusinessRulesData);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String paramName = rs.getString("paramName");
            String paramLabel = rs.getString("paramLabel");
            hashMap.put(paramLabel, paramName);
            smsBusinessRulesData.reportParamName().putAll(hashMap);
        }
        return smsBusinessRulesDataList;
    }

    @Generated
    public BusinessRuleMapper(DatabaseSpecificSQLGenerator sqlGenerator) {
        this.sqlGenerator = sqlGenerator;
    }
}

