/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.config;

import java.util.HashMap;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.event.external.config.ExternalEventsKafkaTopicAutoCreateCondition;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.TopicBuilder;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@Conditional(value={ExternalEventsKafkaTopicAutoCreateCondition.class})
public class KafkaExternalEventTopicConfig {
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    public KafkaAdmin admin() {
        HashMap<String, String> props = new HashMap<String, String>(this.fineractProperties.getEvents().getExternal().getProducer().getKafka().getAdmin().getExtraPropertiesMap());
        props.put("bootstrap.servers", this.fineractProperties.getEvents().getExternal().getProducer().getKafka().getBootstrapServers());
        return new KafkaAdmin(props);
    }

    @Bean
    public NewTopic externalEventsTopic() {
        FineractProperties.KafkaTopicProperties topicProperties = this.fineractProperties.getEvents().getExternal().getProducer().getKafka().getTopic();
        return TopicBuilder.name((String)topicProperties.getName()).partitions(topicProperties.getPartitions()).replicas(topicProperties.getReplicas()).build();
    }
}

