/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.gcm.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.gcm.domain.Message;
import org.apache.fineract.infrastructure.gcm.domain.Notification;

public final class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String collapseKey;
    private Boolean delayWhileIdle;
    private Integer timeToLive;
    private Map<String, String> data;
    private Boolean dryRun;
    private String restrictedPackageName;
    private String priority;
    private Boolean contentAvailable;
    private Notification notification;

    private Message(Builder builder) {
        this.collapseKey = builder.collapseKey;
        this.delayWhileIdle = builder.delayWhileIdle;
        this.data = Collections.unmodifiableMap(builder.data);
        this.timeToLive = builder.timeToLive;
        this.dryRun = builder.dryRun;
        this.restrictedPackageName = builder.restrictedPackageName;
        this.priority = builder.priority;
        this.contentAvailable = builder.contentAvailable;
        this.notification = builder.notification;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Message(");
        if (this.priority != null) {
            builder.append("priority=").append(this.priority).append(", ");
        }
        if (this.contentAvailable != null) {
            builder.append("contentAvailable=").append(this.contentAvailable).append(", ");
        }
        if (this.collapseKey != null) {
            builder.append("collapseKey=").append(this.collapseKey).append(", ");
        }
        if (this.timeToLive != null) {
            builder.append("timeToLive=").append(this.timeToLive).append(", ");
        }
        if (this.delayWhileIdle != null) {
            builder.append("delayWhileIdle=").append(this.delayWhileIdle).append(", ");
        }
        if (this.dryRun != null) {
            builder.append("dryRun=").append(this.dryRun).append(", ");
        }
        if (this.restrictedPackageName != null) {
            builder.append("restrictedPackageName=").append(this.restrictedPackageName).append(", ");
        }
        if (this.notification != null) {
            builder.append("notification: ").append(this.notification).append(", ");
        }
        if (!this.data.isEmpty()) {
            builder.append("data: {");
            for (Map.Entry entry : this.data.entrySet()) {
                builder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(",");
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append("}");
        }
        if (builder.charAt(builder.length() - 1) == ' ') {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(")");
        return builder.toString();
    }

    @Generated
    public String getCollapseKey() {
        return this.collapseKey;
    }

    @Generated
    public Boolean getDelayWhileIdle() {
        return this.delayWhileIdle;
    }

    @Generated
    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    @Generated
    public Map<String, String> getData() {
        return this.data;
    }

    @Generated
    public Boolean getDryRun() {
        return this.dryRun;
    }

    @Generated
    public String getRestrictedPackageName() {
        return this.restrictedPackageName;
    }

    @Generated
    public String getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getContentAvailable() {
        return this.contentAvailable;
    }

    @Generated
    public Notification getNotification() {
        return this.notification;
    }

    @Generated
    public Message setCollapseKey(String collapseKey) {
        this.collapseKey = collapseKey;
        return this;
    }

    @Generated
    public Message setDelayWhileIdle(Boolean delayWhileIdle) {
        this.delayWhileIdle = delayWhileIdle;
        return this;
    }

    @Generated
    public Message setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    @Generated
    public Message setData(Map<String, String> data) {
        this.data = data;
        return this;
    }

    @Generated
    public Message setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Generated
    public Message setRestrictedPackageName(String restrictedPackageName) {
        this.restrictedPackageName = restrictedPackageName;
        return this;
    }

    @Generated
    public Message setPriority(String priority) {
        this.priority = priority;
        return this;
    }

    @Generated
    public Message setContentAvailable(Boolean contentAvailable) {
        this.contentAvailable = contentAvailable;
        return this;
    }

    @Generated
    public Message setNotification(Notification notification) {
        this.notification = notification;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        Boolean this$delayWhileIdle = this.getDelayWhileIdle();
        Boolean other$delayWhileIdle = other.getDelayWhileIdle();
        if (this$delayWhileIdle == null ? other$delayWhileIdle != null : !((Object)this$delayWhileIdle).equals(other$delayWhileIdle)) {
            return false;
        }
        Integer this$timeToLive = this.getTimeToLive();
        Integer other$timeToLive = other.getTimeToLive();
        if (this$timeToLive == null ? other$timeToLive != null : !((Object)this$timeToLive).equals(other$timeToLive)) {
            return false;
        }
        Boolean this$dryRun = this.getDryRun();
        Boolean other$dryRun = other.getDryRun();
        if (this$dryRun == null ? other$dryRun != null : !((Object)this$dryRun).equals(other$dryRun)) {
            return false;
        }
        Boolean this$contentAvailable = this.getContentAvailable();
        Boolean other$contentAvailable = other.getContentAvailable();
        if (this$contentAvailable == null ? other$contentAvailable != null : !((Object)this$contentAvailable).equals(other$contentAvailable)) {
            return false;
        }
        String this$collapseKey = this.getCollapseKey();
        String other$collapseKey = other.getCollapseKey();
        if (this$collapseKey == null ? other$collapseKey != null : !this$collapseKey.equals(other$collapseKey)) {
            return false;
        }
        Map this$data = this.getData();
        Map other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$restrictedPackageName = this.getRestrictedPackageName();
        String other$restrictedPackageName = other.getRestrictedPackageName();
        if (this$restrictedPackageName == null ? other$restrictedPackageName != null : !this$restrictedPackageName.equals(other$restrictedPackageName)) {
            return false;
        }
        String this$priority = this.getPriority();
        String other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        Notification this$notification = this.getNotification();
        Notification other$notification = other.getNotification();
        return !(this$notification == null ? other$notification != null : !this$notification.equals(other$notification));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $delayWhileIdle = this.getDelayWhileIdle();
        result = result * 59 + ($delayWhileIdle == null ? 43 : ((Object)$delayWhileIdle).hashCode());
        Integer $timeToLive = this.getTimeToLive();
        result = result * 59 + ($timeToLive == null ? 43 : ((Object)$timeToLive).hashCode());
        Boolean $dryRun = this.getDryRun();
        result = result * 59 + ($dryRun == null ? 43 : ((Object)$dryRun).hashCode());
        Boolean $contentAvailable = this.getContentAvailable();
        result = result * 59 + ($contentAvailable == null ? 43 : ((Object)$contentAvailable).hashCode());
        String $collapseKey = this.getCollapseKey();
        result = result * 59 + ($collapseKey == null ? 43 : $collapseKey.hashCode());
        Map $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $restrictedPackageName = this.getRestrictedPackageName();
        result = result * 59 + ($restrictedPackageName == null ? 43 : $restrictedPackageName.hashCode());
        String $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        Notification $notification = this.getNotification();
        result = result * 59 + ($notification == null ? 43 : $notification.hashCode());
        return result;
    }

    @Generated
    public Message() {
    }
}

