/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.gcm.domain;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.gcm.domain.Message;
import org.apache.fineract.infrastructure.gcm.domain.MulticastResult;
import org.apache.fineract.infrastructure.gcm.domain.Notification;
import org.apache.fineract.infrastructure.gcm.domain.Result;
import org.apache.fineract.infrastructure.gcm.domain.Sender;
import org.apache.fineract.infrastructure.gcm.exception.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Sender {
    protected static final int BACKOFF_INITIAL_DELAY = 1000;
    protected static final int MAX_BACKOFF_DELAY = 1024000;
    private static final SecureRandom random = new SecureRandom();
    protected static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private final String key;
    private String endpoint;
    private int connectTimeout;
    private int readTimeout;

    public Sender(String key, String endpoint) {
        this.key = (String)Sender.nonNull((Object)key);
        this.endpoint = (String)Sender.nonNull((Object)endpoint);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public final void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.connectTimeout = connectTimeout;
    }

    public final void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.readTimeout = readTimeout;
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="False positive for random object created and used only once")
    public Result send(Message message, String to, int retries) throws IOException {
        Result result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempt #{} to send message {} to regIds {}", new Object[]{attempt, message, to});
            }
            boolean bl = tryAgain = (result = this.sendNoRetry(message, to)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + random.nextInt(backoff);
            this.sleep((long)sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not send message after " + attempt + " attempts");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result sendNoRetry(Message message, String to) throws IOException {
        Sender.nonNull((Object)to);
        HashMap<String, String> jsonRequest = new HashMap<String, String>();
        this.messageToMap(message, jsonRequest);
        jsonRequest.put("to", to);
        Map responseMap = this.makeGcmHttpRequest(jsonRequest);
        String responseBody = null;
        if (responseMap.get("responseBody") != null) {
            responseBody = (String)responseMap.get("responseBody");
        }
        int status = (Integer)responseMap.get("status");
        if (responseBody == null) {
            return null;
        }
        try {
            JsonObject jsonResponse = JsonParser.parseString((String)responseBody).getAsJsonObject();
            Result.Builder resultBuilder = new Result.Builder();
            if (jsonResponse.has("results")) {
                JsonArray jsonResults = (JsonArray)jsonResponse.get("results");
                if (jsonResults.size() != 1) {
                    LOG.warn("Found null or {} results, expected one", (Object)jsonResults.size());
                    return null;
                }
                JsonObject jsonResult = (JsonObject)jsonResults.get(0);
                String messageId = null;
                String canonicalRegId = null;
                String error = null;
                if (jsonResult.has("message_id")) {
                    messageId = jsonResult.get("message_id").getAsString();
                }
                if (jsonResult.has("registration_id")) {
                    canonicalRegId = jsonResult.get("registration_id").getAsString();
                }
                if (jsonResult.has("error")) {
                    error = jsonResult.get("error").getAsString();
                }
                int success = 0;
                int failure = 0;
                if (jsonResponse.get("success") != null) {
                    success = Integer.parseInt(jsonResponse.get("success").toString());
                }
                if (jsonResponse.get("failure") != null) {
                    failure = Integer.parseInt(jsonResponse.get("failure").toString());
                }
                resultBuilder.messageId(messageId).canonicalRegistrationId(canonicalRegId).success(Integer.valueOf(success)).failure(Integer.valueOf(failure)).status(status).errorCode(error);
                return resultBuilder.build();
            }
            if (to.startsWith("/topics/")) {
                if (jsonResponse.has("message_id")) {
                    Long messageId = jsonResponse.get("message_id").getAsLong();
                    resultBuilder.messageId(messageId.toString());
                    return resultBuilder.build();
                }
                if (jsonResponse.has("error")) {
                    String error = jsonResponse.get("error").getAsString();
                    resultBuilder.errorCode(error);
                    return resultBuilder.build();
                }
                LOG.warn("Expected {} or {} found: {}", new Object[]{"message_id", "error", responseBody});
                return null;
            }
            if (jsonResponse.has("success") && jsonResponse.has("failure")) {
                int success = this.getNumber(responseMap, "success").intValue();
                int failure = this.getNumber(responseMap, "failure").intValue();
                ArrayList<String> failedIds = null;
                if (jsonResponse.has("failed_registration_ids")) {
                    JsonArray jFailedIds = jsonResponse.get("failed_registration_ids").getAsJsonArray();
                    failedIds = new ArrayList<String>();
                    for (int i = 0; i < jFailedIds.size(); ++i) {
                        failedIds.add(jFailedIds.get(i).getAsString());
                    }
                }
                resultBuilder.success(Integer.valueOf(success)).failure(Integer.valueOf(failure)).failedRegistrationIds(failedIds);
                return resultBuilder.build();
            }
            LOG.warn("Unrecognized response: {}", (Object)responseBody);
            throw this.newIoException(responseBody, new Exception("Unrecognized response."));
        }
        catch (CustomParserException e) {
            throw this.newIoException(responseBody, (Exception)((Object)e));
        }
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="False positive for random object created and used only once")
    public MulticastResult send(Message message, List<String> regIds, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        HashMap results = new HashMap();
        List<String> unsentRegIds = new ArrayList<String>(regIds);
        ArrayList<Long> multicastIds = new ArrayList<Long>();
        do {
            MulticastResult multicastResult = null;
            ++attempt;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempt #{} to send message {} to regIds {}", new Object[]{attempt, message, unsentRegIds});
            }
            try {
                multicastResult = this.sendNoRetry(message, unsentRegIds);
            }
            catch (IOException e) {
                LOG.debug("IOException on attempt {}", (Object)attempt, (Object)e);
            }
            if (multicastResult != null) {
                long multicastId = multicastResult.getMulticastId();
                LOG.debug("multicast_id on attempt # {}: {}", (Object)attempt, (Object)multicastId);
                multicastIds.add(multicastId);
                unsentRegIds = this.updateStatus(unsentRegIds, results, multicastResult);
                tryAgain = !unsentRegIds.isEmpty() && attempt <= retries;
            } else {
                boolean bl = tryAgain = attempt <= retries;
            }
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + random.nextInt(backoff);
            this.sleep((long)sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (multicastIds.isEmpty()) {
            throw new IOException("Could not post JSON requests to GCM after " + attempt + " attempts");
        }
        int success = 0;
        int failure = 0;
        int canonicalIds = 0;
        for (Result result : results.values()) {
            if (result.getMessageId() != null) {
                ++success;
                if (result.getCanonicalRegistrationId() == null) continue;
                ++canonicalIds;
                continue;
            }
            ++failure;
        }
        long multicastId = (Long)multicastIds.remove(0);
        MulticastResult.Builder builder = new MulticastResult.Builder(success, failure, canonicalIds, multicastId).retryMulticastIds(multicastIds);
        for (String regId : regIds) {
            Result result = (Result)results.get(regId);
            builder.addResult(result);
        }
        return builder.build();
    }

    private List<String> updateStatus(List<String> unsentRegIds, Map<String, Result> allResults, MulticastResult multicastResult) {
        List results = multicastResult.getResults();
        if (results.size() != unsentRegIds.size()) {
            throw new RuntimeException("Internal error: sizes do not match. currentResults: " + String.valueOf(results) + "; unsentRegIds: " + String.valueOf(unsentRegIds));
        }
        ArrayList<String> newUnsentRegIds = new ArrayList<String>();
        for (int i = 0; i < unsentRegIds.size(); ++i) {
            String regId = unsentRegIds.get(i);
            Result result = (Result)results.get(i);
            allResults.put(regId, result);
            String error = result.getErrorCode();
            if (error == null || !error.equals("Unavailable") && !error.equals("InternalServerError")) continue;
            newUnsentRegIds.add(regId);
        }
        return newUnsentRegIds;
    }

    public MulticastResult sendNoRetry(Message message, List<String> registrationIds) throws IOException {
        if (((List)Sender.nonNull(registrationIds)).isEmpty()) {
            throw new IllegalArgumentException("registrationIds cannot be empty");
        }
        HashMap<String, List<String>> jsonRequest = new HashMap<String, List<String>>();
        this.messageToMap(message, jsonRequest);
        jsonRequest.put("registration_ids", registrationIds);
        Map responseMap = this.makeGcmHttpRequest(jsonRequest);
        String responseBody = null;
        if (responseMap.get("responseBody") != null) {
            responseBody = (String)responseMap.get("responseBody");
        }
        if (responseBody == null) {
            return null;
        }
        try {
            JsonObject jsonResponse = JsonParser.parseString((String)responseBody).getAsJsonObject();
            int success = this.getNumber(responseMap, "success").intValue();
            int failure = this.getNumber(responseMap, "failure").intValue();
            int canonicalIds = this.getNumber(responseMap, "canonical_ids").intValue();
            long multicastId = this.getNumber(responseMap, "multicast_id").longValue();
            MulticastResult.Builder builder = new MulticastResult.Builder(success, failure, canonicalIds, multicastId);
            List results = (List)jsonResponse.get("results");
            if (results != null) {
                for (Map jsonResult : results) {
                    String messageId = (String)jsonResult.get("message_id");
                    String canonicalRegId = (String)jsonResult.get("registration_id");
                    String error = (String)jsonResult.get("error");
                    Result result = new Result.Builder().messageId(messageId).canonicalRegistrationId(canonicalRegId).errorCode(error).build();
                    builder.addResult(result);
                }
            }
            return builder.build();
        }
        catch (CustomParserException e) {
            throw this.newIoException(responseBody, (Exception)((Object)e));
        }
    }

    private Map<String, Object> makeGcmHttpRequest(Map<Object, Object> jsonRequest) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        String requestBody = new Gson().toJson(jsonRequest);
        LOG.debug("JSON request: " + requestBody);
        try {
            conn = this.post(this.getEndpoint(), "application/json", requestBody);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            LOG.debug("IOException posting to GCM", (Throwable)e);
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Sender.getAndClose((InputStream)conn.getErrorStream());
                LOG.debug("JSON error response: {}", (Object)responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                LOG.debug("Exception reading response: ", (Throwable)e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Sender.getAndClose((InputStream)conn.getInputStream());
        }
        catch (IOException e) {
            LOG.warn("IOException reading response", (Throwable)e);
            return null;
        }
        LOG.debug("JSON response: {}", (Object)responseBody);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseBody", responseBody);
        map.put("status", status);
        return map;
    }

    private void messageToMap(Message message, Map<Object, Object> mapRequest) {
        if (message == null || mapRequest == null) {
            return;
        }
        this.setJsonField(mapRequest, "priority", (Object)message.getPriority());
        this.setJsonField(mapRequest, "content_available", (Object)message.getContentAvailable());
        this.setJsonField(mapRequest, "time_to_live", (Object)message.getTimeToLive());
        this.setJsonField(mapRequest, "collapse_key", (Object)message.getCollapseKey());
        this.setJsonField(mapRequest, "restricted_package_name", (Object)message.getRestrictedPackageName());
        this.setJsonField(mapRequest, "delay_while_idle", (Object)message.getDelayWhileIdle());
        this.setJsonField(mapRequest, "dry_run", (Object)message.getDryRun());
        Map payload = message.getData();
        if (!payload.isEmpty()) {
            mapRequest.put("data", payload);
        }
        if (message.getNotification() != null) {
            Notification notification = message.getNotification();
            HashMap nMap = new HashMap();
            if (notification.getBadge() != null) {
                this.setJsonField(nMap, "badge", (Object)notification.getBadge().toString());
            }
            this.setJsonField(nMap, "body", (Object)notification.getBody());
            this.setJsonField(nMap, "body_loc_args", (Object)notification.getBodyLocArgs());
            this.setJsonField(nMap, "body_loc_key", (Object)notification.getBodyLocKey());
            this.setJsonField(nMap, "click_action", (Object)notification.getClickAction());
            this.setJsonField(nMap, "color", (Object)notification.getColor());
            this.setJsonField(nMap, "icon", (Object)notification.getIcon());
            this.setJsonField(nMap, "sound", (Object)notification.getSound());
            this.setJsonField(nMap, "tag", (Object)notification.getTag());
            this.setJsonField(nMap, "title", (Object)notification.getTitle());
            this.setJsonField(nMap, "title_loc_args", (Object)notification.getTitleLocArgs());
            this.setJsonField(nMap, "title_loc_key", (Object)notification.getTitleLocKey());
            mapRequest.put("notification", nMap);
        }
    }

    private IOException newIoException(String responseBody, Exception e) {
        String msg = "Error parsing JSON response (" + responseBody + ")";
        LOG.warn(msg, (Throwable)e);
        return new IOException(msg + ":" + String.valueOf(e));
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.debug("IOException closing stream", (Throwable)e);
            }
        }
    }

    private void setJsonField(Map<Object, Object> json, String field, Object value) {
        if (value != null) {
            json.put(field, value);
        }
    }

    private Number getNumber(Map<?, ?> json, String field) {
        Object value = json.get(field);
        if (value == null) {
            throw new CustomParserException("Missing field: " + field);
        }
        if (!(value instanceof Number)) {
            throw new CustomParserException("Field " + field + " does not contain a number: " + String.valueOf(value));
        }
        return (Number)value;
    }

    protected HttpURLConnection post(String url, String body) throws IOException {
        return this.post(url, "application/x-www-form-urlencoded;charset=UTF-8", body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection post(String url, String contentType, String body) throws IOException {
        if (url == null || contentType == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (!url.startsWith("https://")) {
            LOG.warn("URL does not use https: {}", (Object)url);
        }
        LOG.debug("Sending POST to {}", (Object)url);
        LOG.debug("POST body: {}", (Object)body);
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode((long)bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Authorization", "key=" + this.key);
        OutputStream out = conn.getOutputStream();
        try {
            out.write(bytes);
        }
        finally {
            Sender.close((Closeable)out);
        }
        return conn;
    }

    protected static final Map<String, String> newKeyValues(String key, String value) {
        HashMap<String, String> keyValues = new HashMap<String, String>(1);
        keyValues.put((String)Sender.nonNull((Object)key), (String)Sender.nonNull((Object)value));
        return keyValues;
    }

    protected static StringBuilder newBody(String name, String value) {
        return new StringBuilder((String)Sender.nonNull((Object)name)).append('=').append((String)Sender.nonNull((Object)value));
    }

    protected static void addParameter(StringBuilder body, String name, String value) {
        ((StringBuilder)Sender.nonNull((Object)body)).append('&').append((String)Sender.nonNull((Object)name)).append('=').append((String)Sender.nonNull((Object)value));
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        return conn;
    }

    protected static String getString(InputStream stream) throws IOException {
        String newLine;
        if (stream == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        StringBuilder content = new StringBuilder();
        do {
            if ((newLine = reader.readLine()) == null) continue;
            content.append(newLine).append('\n');
        } while (newLine != null);
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    private static String getAndClose(InputStream stream) throws IOException {
        try {
            String string = Sender.getString((InputStream)stream);
            return string;
        }
        finally {
            if (stream != null) {
                Sender.close((Closeable)stream);
            }
        }
    }

    static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

