/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.config;

import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgresSequenceMaxValueIncrementer;

public class FineractDataFieldMaxValueIncrementerFactory
implements DataFieldMaxValueIncrementerFactory {
    private static final List<DatabaseType> SUPPORTED_DATABASE_TYPES = List.of(DatabaseType.MARIADB, DatabaseType.MYSQL, DatabaseType.POSTGRES);
    private final DataSource dataSource;
    private String incrementerColumnName = "ID";

    public void setIncrementerColumnName(String incrementerColumnName) {
        this.incrementerColumnName = incrementerColumnName;
    }

    public DataFieldMaxValueIncrementer getIncrementer(String incrementerType, String incrementerName) {
        DatabaseType databaseType = this.getDatabaseType(incrementerType);
        if (databaseType == DatabaseType.MYSQL || databaseType == DatabaseType.MARIADB) {
            MySQLMaxValueIncrementer mySQLMaxValueIncrementer = new MySQLMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
            mySQLMaxValueIncrementer.setUseNewConnection(true);
            return mySQLMaxValueIncrementer;
        }
        if (databaseType == DatabaseType.POSTGRES) {
            return new PostgresSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        throw new IllegalArgumentException("databaseType argument was not on the approved list");
    }

    public boolean isSupportedIncrementerType(String incrementerType) {
        DatabaseType databaseType = this.getDatabaseType(incrementerType);
        return SUPPORTED_DATABASE_TYPES.contains(databaseType);
    }

    public String[] getSupportedIncrementerTypes() {
        return (String[])SUPPORTED_DATABASE_TYPES.stream().map(Enum::name).toArray(String[]::new);
    }

    private DatabaseType getDatabaseType(String incrementerType) {
        return DatabaseType.valueOf((String)incrementerType.toUpperCase());
    }

    @Generated
    public FineractDataFieldMaxValueIncrementerFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

