/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.conditions.LoanCOBEnabledCondition;
import org.apache.fineract.infrastructure.core.http.BodyCachingHttpServletRequestWrapper;
import org.apache.fineract.infrastructure.jobs.exception.LoanIdsHardLockedException;
import org.apache.fineract.infrastructure.jobs.filter.LoanCOBApiFilter;
import org.apache.fineract.infrastructure.jobs.filter.LoanCOBFilterHelper;
import org.apache.fineract.useradministration.exception.UnAuthenticatedUserException;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * Exception performing whole class analysis ignored.
 */
@Conditional(value={LoanCOBEnabledCondition.class})
public class LoanCOBApiFilter
extends OncePerRequestFilter {
    private final LoanCOBFilterHelper helper;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.helper.isOnApiList((BodyCachingHttpServletRequestWrapper)(request = new BodyCachingHttpServletRequestWrapper(request)))) {
            this.proceed(filterChain, request, response);
        } else {
            try {
                boolean bypassUser = this.helper.isBypassUser();
                if (bypassUser) {
                    this.proceed(filterChain, request, response);
                } else {
                    try {
                        List loanIds = this.helper.calculateRelevantLoanIds((BodyCachingHttpServletRequestWrapper)request);
                        if (!loanIds.isEmpty() && this.helper.isLoanBehind(loanIds)) {
                            this.helper.executeInlineCob(loanIds);
                        }
                        this.proceed(filterChain, request, response);
                    }
                    catch (LoanIdsHardLockedException e) {
                        Reject.reject((Long)e.getLoanIdFromRequest(), (int)409).toServletResponse(response);
                    }
                }
            }
            catch (UnAuthenticatedUserException e) {
                throw new AuthenticationCredentialsNotFoundException("Not Authenticated", (Throwable)e);
            }
        }
    }

    private void proceed(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public LoanCOBApiFilter(LoanCOBFilterHelper helper) {
        this.helper = helper;
    }
}

