/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.aggregationjob;

import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class JournalEntryAggregationJobExecutionDecider
implements JobExecutionDecider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalEntryAggregationJobExecutionDecider.class);

    @NonNull
    public FlowExecutionStatus decide(@NonNull JobExecution jobExecution, StepExecution stepExecution) {
        LocalDate aggregatedOnDate = (LocalDate)jobExecution.getExecutionContext().get("aggregatedOnDate");
        LocalDate lastAggregatedOnDate = (LocalDate)jobExecution.getExecutionContext().get("lastAggregatedOnDate");
        if (this.aggregationAlreadyExist(lastAggregatedOnDate, aggregatedOnDate)) {
            log.info("Journal entry aggregation for given aggregatedOnDate already exist hence skipping jobName={} execution for aggregatedOnDate={}", (Object)"JOURNAL_ENTRY_AGGREGATION", (Object)aggregatedOnDate);
            jobExecution.setExitStatus(ExitStatus.NOOP);
            return new FlowExecutionStatus("NO_OP_EXECUTION");
        }
        log.info("Continue executing journal entry aggregation job jobName={} execution for aggregatedOnDate={}", (Object)"JOURNAL_ENTRY_AGGREGATION", (Object)aggregatedOnDate);
        return new FlowExecutionStatus("CONTINUE_JOB_EXECUTION");
    }

    private boolean aggregationAlreadyExist(LocalDate lastAggregatedOnDate, LocalDate aggregatedOnDate) {
        if (Objects.isNull(lastAggregatedOnDate)) {
            log.info("Journal Entry aggregation job being executed for the first time");
            return false;
        }
        return aggregatedOnDate.isBefore(lastAggregatedOnDate) || aggregatedOnDate.isEqual(lastAggregatedOnDate);
    }
}

