/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobRunHistoryData;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobRunHistoryReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.springframework.stereotype.Component;

@Path(value="/v1/reportmailingjobrunhistory")
@Component
@Tag(name="List Report Mailing Job History", description="")
public class ReportMailingJobRunHistoryApiResource {
    private final PlatformSecurityContext platformSecurityContext;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<ReportMailingJobRunHistoryData> reportMailingToApiJsonSerializer;
    private final ReportMailingJobRunHistoryReadPlatformService reportMailingJobRunHistoryReadPlatformService;
    private final SqlValidator sqlValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Report Mailing Job History", description="The list capability of report mailing job history can support pagination and sorting.\n\nExample Requests:\n\nreportmailingjobrunhistory/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportMailingJobRunHistoryData.class))})})
    public String retrieveAllByReportMailingJobId(@Context UriInfo uriInfo, @QueryParam(value="reportMailingJobId") @Parameter(description="reportMailingJobId") Long reportMailingJobId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission("REPORTMAILINGJOB");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page reportMailingJobRunHistoryData = this.reportMailingJobRunHistoryReadPlatformService.retrieveRunHistoryByJobId(reportMailingJobId, searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.reportMailingToApiJsonSerializer.serialize(settings, reportMailingJobRunHistoryData);
    }

    @Generated
    public ReportMailingJobRunHistoryApiResource(PlatformSecurityContext platformSecurityContext, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<ReportMailingJobRunHistoryData> reportMailingToApiJsonSerializer, ReportMailingJobRunHistoryReadPlatformService reportMailingJobRunHistoryReadPlatformService, SqlValidator sqlValidator) {
        this.platformSecurityContext = platformSecurityContext;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.reportMailingToApiJsonSerializer = reportMailingToApiJsonSerializer;
        this.reportMailingJobRunHistoryReadPlatformService = reportMailingJobRunHistoryReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

