/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;

public class GeoCodeData {
    public static final List<String> PARAMS = List.copyOf(Arrays.asList("latitude", "latitude"));
    @NotNull
    private final String latitude;
    @NotNull
    private final String longitude;

    public GeoCodeData(String latitude, String longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public static GeoCodeData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, (Collection)PARAMS);
        String latitude = jsonHelper.extractStringNamed("latitude", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("latitude").value((Object)latitude).notBlank();
        String longitude = jsonHelper.extractStringNamed("latitude", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("latitude").value((Object)longitude).notBlank();
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new GeoCodeData(latitude, longitude);
    }
}

