/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.mix.service;

import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.mix.data.ContextData;
import org.apache.fineract.mix.data.MixTaxonomyData;
import org.apache.fineract.mix.data.NamespaceData;
import org.apache.fineract.mix.data.XBRLData;
import org.apache.fineract.mix.exception.XBRLMappingInvalidException;
import org.apache.fineract.mix.service.NamespaceReadPlatformService;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XBRLBuilder {
    private static final String SCHEME_URL = "http://www.themix.org";
    private static final String IDENTIFIER = "000000";
    private static final String UNITID_PURE = "Unit1";
    private static final String UNITID_CUR = "Unit2";
    @Autowired
    private NamespaceReadPlatformService readNamespaceService;

    public String build(XBRLData xbrlData) {
        return this.build((Map)xbrlData.getResultMap(), xbrlData.getStartDate(), xbrlData.getEndDate(), xbrlData.getCurrency());
    }

    public String build(Map<MixTaxonomyData, BigDecimal> map, Date startDate, Date endDate, String currency) {
        Integer instantScenarioCounter = 0;
        Integer durationScenarioCounter = 0;
        HashMap contextMap = new HashMap();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("xbrl");
        root.addElement("schemaRef").addNamespace("link", "http://www.themix.org/sites/default/files/Taxonomy2010/dct/dc-all_2010-08-31.xsd");
        for (Map.Entry<MixTaxonomyData, BigDecimal> entry : map.entrySet()) {
            MixTaxonomyData taxonomy = entry.getKey();
            BigDecimal value = entry.getValue();
            this.addTaxonomy(root, taxonomy, value, startDate, endDate, instantScenarioCounter, durationScenarioCounter, contextMap);
        }
        this.addContexts(root, startDate, endDate, contextMap);
        this.addCurrencyUnit(root, currency);
        this.addNumberUnit(root);
        doc.setXMLEncoding("UTF-8");
        return doc.asXML();
    }

    private Element addTaxonomy(Element rootElement, MixTaxonomyData taxonomy, BigDecimal value, Date startDate, Date endDate, Integer instantScenarioCounter, Integer durationScenarioCounter, Map<ContextData, String> contextMap) {
        List dims;
        if (startDate == null || endDate == null) {
            throw new XBRLMappingInvalidException("start date and end date should not be null");
        }
        String prefix = taxonomy.getNamespace();
        Object qname = taxonomy.getName();
        if (prefix != null && !prefix.isEmpty()) {
            NamespaceData ns = this.readNamespaceService.retrieveNamespaceByPrefix(prefix);
            if (ns != null) {
                rootElement.addNamespace(prefix, ns.getUrl());
            }
            qname = prefix + ":" + taxonomy.getName();
        }
        Element xmlElement = rootElement.addElement((String)qname);
        String dimension = taxonomy.getDimension();
        SimpleDateFormat timeFormat = new SimpleDateFormat("MM_dd_yyyy");
        ContextData context = null;
        if (dimension != null && (dims = Splitter.on((char)':').splitToList((CharSequence)dimension)).size() == 2) {
            context = new ContextData().setDimensionType((String)dims.get(0)).setDimension((String)dims.get(1)).setPeriodType(Integer.valueOf(taxonomy.getType().equals(MixTaxonomyData.BALANCESHEET) || taxonomy.getType().equals(MixTaxonomyData.PORTFOLIO) ? 0 : 1));
        }
        if (context == null) {
            context = new ContextData().setPeriodType(Integer.valueOf(taxonomy.getType().equals(MixTaxonomyData.BALANCESHEET) || taxonomy.getType().equals(MixTaxonomyData.PORTFOLIO) ? 0 : 1));
        }
        if (!contextMap.containsKey(context)) {
            String startDateStr = timeFormat.format(startDate);
            String endDateStr = timeFormat.format(endDate);
            instantScenarioCounter = instantScenarioCounter + 1;
            durationScenarioCounter = durationScenarioCounter + 1;
            String contextRefID = context.getPeriodType() == 0 ? "As_Of_" + endDateStr + instantScenarioCounter : "Duration_" + startDateStr + "_To_" + endDateStr + durationScenarioCounter;
            contextMap.put(context, contextRefID);
        }
        xmlElement.addAttribute("contextRef", contextMap.get(context));
        xmlElement.addAttribute("unitRef", this.getUnitRef(taxonomy));
        xmlElement.addAttribute("decimals", this.getNumberOfDecimalPlaces(value).toString());
        xmlElement.addText(value.toPlainString());
        return xmlElement;
    }

    private String getUnitRef(MixTaxonomyData tx) {
        return tx.isPortfolio() ? UNITID_PURE : UNITID_CUR;
    }

    private void addNumberUnit(Element root) {
        Element numerUnit = root.addElement("unit");
        numerUnit.addAttribute("id", UNITID_PURE);
        Element measure = numerUnit.addElement("measure");
        measure.addText("xbrli:pure");
    }

    private void addCurrencyUnit(Element root, String currencyCode) {
        Element currencyUnitElement = root.addElement("unit");
        currencyUnitElement.addAttribute("id", UNITID_CUR);
        Element measure = currencyUnitElement.addElement("measure");
        measure.addText("iso4217:" + currencyCode);
    }

    private void addContexts(Element root, Date startDate, Date endDate, Map<ContextData, String> contextMap) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (Map.Entry<ContextData, String> entry : contextMap.entrySet()) {
            ContextData context = entry.getKey();
            Element contextElement = root.addElement("context");
            contextElement.addAttribute("id", entry.getValue());
            contextElement.addElement("entity").addElement("identifier").addAttribute("scheme", SCHEME_URL).addText(IDENTIFIER);
            Element periodElement = contextElement.addElement("period");
            if (context.getPeriodType() == 0) {
                periodElement.addElement("instant").addText(format.format(endDate));
            } else {
                periodElement.addElement("startDate").addText(format.format(startDate));
                periodElement.addElement("endDate").addText(format.format(endDate));
            }
            String dimension = context.getDimension();
            String dimType = context.getDimensionType();
            if (dimType == null || dimension == null) continue;
            contextElement.addElement("scenario").addElement("explicitMember").addAttribute("dimension", dimType).addText(dimension);
        }
    }

    private Integer getNumberOfDecimalPlaces(BigDecimal bigDecimal) {
        String string = bigDecimal.stripTrailingZeros().toPlainString();
        int index = string.indexOf(".");
        return index < 0 ? 0 : string.length() - index - 1;
    }
}

