/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.eventandlistener;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.condition.EnableFineractEventListenerCondition;
import org.apache.fineract.notification.data.NotificationData;
import org.apache.fineract.notification.eventandlistener.NotificationEventListener;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"activeMqEnabled"})
@Conditional(value={EnableFineractEventListenerCondition.class})
public class ActiveMQNotificationEventListener
implements SessionAwareMessageListener {
    private final NotificationEventListener notificationEventListener;

    public void onMessage(Message message, Session session) throws JMSException {
        if (message instanceof ObjectMessage) {
            NotificationData notificationData = (NotificationData)((ObjectMessage)message).getObject();
            this.notificationEventListener.receive(notificationData);
        }
    }

    @Generated
    public ActiveMQNotificationEventListener(NotificationEventListener notificationEventListener) {
        this.notificationEventListener = notificationEventListener;
    }
}

