/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class OfficeCommandFromApiJsonDeserializer {
    public static final String PARENT_ID = "parentId";
    public static final String NAME = "name";
    public static final String OPENING_DATE = "openingDate";
    public static final String EXTERNAL_ID = "externalId";
    public static final String LOCALE = "locale";
    public static final String DATE_FORMAT = "dateFormat";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("name", "parentId", "openingDate", "externalId", "locale", "dateFormat"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public OfficeCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("office");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed(NAME, element);
        baseDataValidator.reset().parameter(NAME).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        LocalDate openingDate = this.fromApiJsonHelper.extractLocalDateNamed(OPENING_DATE, element);
        baseDataValidator.reset().parameter(OPENING_DATE).value((Object)openingDate).notNull();
        if (this.fromApiJsonHelper.parameterExists(EXTERNAL_ID, element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed(EXTERNAL_ID, element);
            baseDataValidator.reset().parameter(EXTERNAL_ID).value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(PARENT_ID, element)) {
            Long parentId = this.fromApiJsonHelper.extractLongNamed(PARENT_ID, element);
            baseDataValidator.reset().parameter(PARENT_ID).value((Object)parentId).notNull().integerGreaterThanZero();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("office");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(NAME, element)) {
            String name = this.fromApiJsonHelper.extractStringNamed(NAME, element);
            baseDataValidator.reset().parameter(NAME).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(OPENING_DATE, element)) {
            LocalDate openingDate = this.fromApiJsonHelper.extractLocalDateNamed(OPENING_DATE, element);
            baseDataValidator.reset().parameter(OPENING_DATE).value((Object)openingDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(EXTERNAL_ID, element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed(EXTERNAL_ID, element);
            baseDataValidator.reset().parameter(EXTERNAL_ID).value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(PARENT_ID, element)) {
            Long parentId = this.fromApiJsonHelper.extractLongNamed(PARENT_ID, element);
            baseDataValidator.reset().parameter(PARENT_ID).value((Object)parentId).notNull().integerGreaterThanZero();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }
}

