/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.accounting.glaccount.service.GLAccountReadPlatformService;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCategoryData;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCriteriaData;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCriteriaDefinitionData;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCriteriaNotFoundException;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCategoryReadPlatformService;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCriteriaReadPlatformService;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCriteriaReadPlatformServiceImpl;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ProvisioningCriteriaReadPlatformServiceImpl
implements ProvisioningCriteriaReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ProvisioningCategoryReadPlatformService provisioningCategoryReadPlatformService;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final GLAccountReadPlatformService glAccountReadPlatformService;
    private final LoanProductReadPlatformService loanProductReaPlatformService;

    public ProvisioningCriteriaData retrievePrivisiongCriteriaTemplate() {
        boolean onlyActive = true;
        List categories = this.provisioningCategoryReadPlatformService.retrieveAllProvisionCategories();
        Collection allLoanProducts = this.loanProductReadPlatformService.retrieveAllLoanProductsForLookup(onlyActive);
        List glAccounts = this.glAccountReadPlatformService.retrieveAllEnabledDetailGLAccounts();
        return ProvisioningCriteriaData.toTemplate((Collection)this.constructCriteriaTemplate((Collection)categories), (Collection)allLoanProducts, (Collection)glAccounts);
    }

    public ProvisioningCriteriaData retrievePrivisiongCriteriaTemplate(ProvisioningCriteriaData data) {
        boolean onlyActive = true;
        List categories = this.provisioningCategoryReadPlatformService.retrieveAllProvisionCategories();
        Collection allLoanProducts = this.loanProductReadPlatformService.retrieveAllLoanProductsForLookup(onlyActive);
        List glAccounts = this.glAccountReadPlatformService.retrieveAllEnabledDetailGLAccounts();
        return ProvisioningCriteriaData.toTemplate((ProvisioningCriteriaData)data, (Collection)this.constructCriteriaTemplate((Collection)categories), (Collection)allLoanProducts, (Collection)glAccounts);
    }

    private Collection<ProvisioningCriteriaDefinitionData> constructCriteriaTemplate(Collection<ProvisioningCategoryData> categories) {
        ArrayList<ProvisioningCriteriaDefinitionData> definitions = new ArrayList<ProvisioningCriteriaDefinitionData>();
        for (ProvisioningCategoryData data : categories) {
            definitions.add(ProvisioningCriteriaDefinitionData.template((Long)data.getId(), (String)data.getCategoryName()));
        }
        return definitions;
    }

    public List<ProvisioningCriteriaData> retrieveAllProvisioningCriterias() {
        ProvisioningCriteriaRowMapper mapper = new ProvisioningCriteriaRowMapper();
        String sql = "select " + mapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)mapper);
    }

    public ProvisioningCriteriaData retrieveProvisioningCriteria(Long criteriaId) {
        try {
            String criteriaName = this.retrieveCriteriaName(criteriaId);
            Collection loanProducts = this.loanProductReaPlatformService.retrieveAllLoanProductsForLookup("select product_id from m_loanproduct_provisioning_mapping where m_loanproduct_provisioning_mapping.criteria_id=" + criteriaId);
            List definitions = this.retrieveProvisioningDefinitions(criteriaId);
            return ProvisioningCriteriaData.toLookup((Long)criteriaId, (String)criteriaName, (Collection)loanProducts, (List)definitions);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ProvisioningCriteriaNotFoundException(criteriaId, e);
        }
    }

    private List<ProvisioningCriteriaDefinitionData> retrieveProvisioningDefinitions(Long criteriaId) {
        ProvisioningCriteriaDefinitionRowMapper rowMapper = new ProvisioningCriteriaDefinitionRowMapper();
        String sql = "select " + rowMapper.schema() + " where pc.criteria_id = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)rowMapper, new Object[]{criteriaId});
    }

    private String retrieveCriteriaName(Long criteriaId) {
        ProvisioningCriteriaNameRowMapper rowMapper = new ProvisioningCriteriaNameRowMapper();
        String sql = "select " + rowMapper.schema() + " from m_provisioning_criteria pc where pc.id = ?";
        return (String)this.jdbcTemplate.queryForObject(sql, (RowMapper)rowMapper, new Object[]{criteriaId});
    }

    @Generated
    public ProvisioningCriteriaReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ProvisioningCategoryReadPlatformService provisioningCategoryReadPlatformService, LoanProductReadPlatformService loanProductReadPlatformService, GLAccountReadPlatformService glAccountReadPlatformService, LoanProductReadPlatformService loanProductReaPlatformService) {
        this.jdbcTemplate = jdbcTemplate;
        this.provisioningCategoryReadPlatformService = provisioningCategoryReadPlatformService;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.glAccountReadPlatformService = glAccountReadPlatformService;
        this.loanProductReaPlatformService = loanProductReaPlatformService;
    }
}

