/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.domain;

import java.util.Collection;
import java.util.List;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@CacheConfig(cacheNames={"calendarInstances"})
public interface CalendarInstanceRepository
extends JpaRepository<CalendarInstance, Long>,
JpaSpecificationExecutor<CalendarInstance> {
    @Cacheable(key="'calId_' + #calendarId + '_entityId_' + #entityId + '_entityTypeId_' + #entityTypeId")
    public CalendarInstance findByCalendarIdAndEntityIdAndEntityTypeId(Long var1, Long var2, Integer var3);

    @Cacheable(key="'entityId_' + #entityId + '_entityTypeId_' + #entityTypeId")
    public Collection<CalendarInstance> findByEntityIdAndEntityTypeId(Long var1, Integer var2);

    @Cacheable(key="'entityId_' + #entityId + '_entityTypeId_' + #entityTypeId + '_calendarTypeId_' + #calendarTypeId")
    public CalendarInstance findByEntityIdAndEntityTypeIdAndCalendarTypeId(Long var1, Integer var2, Integer var3);

    @Cacheable(key="'findCalendarInstanceByEntityId_entityId_' + #entityId + '_entityTypeId_' + #entityTypeId")
    @Query(value="select ci from CalendarInstance ci where ci.entityId = :entityId and ci.entityTypeId = :entityTypeId")
    public CalendarInstance findCalendarInstanceByEntityId(@Param(value="entityId") Long var1, @Param(value="entityTypeId") Integer var2);

    @Cacheable(key="'calendarId_' + #calendarId + '_entityTypeId_' + #entityTypeId")
    public Collection<CalendarInstance> findByCalendarIdAndEntityTypeId(Long var1, Integer var2);

    @Cacheable(key="'groupId_' + #groupId + '_clientId_' + #clientId + '_statuses_' + T(org.springframework.util.StringUtils).collectionToCommaDelimitedString(#loanStatuses)")
    @Query(value="select ci from CalendarInstance ci where ci.entityId in (select loan.id from Loan loan where loan.client.id = :clientId and loan.group.id = :groupId and loan.loanStatus in :loanStatuses) and ci.entityTypeId = 3")
    public List<CalendarInstance> findCalendarInstancesForLoansByGroupIdAndClientIdAndStatuses(@Param(value="groupId") Long var1, @Param(value="clientId") Long var2, @Param(value="loanStatuses") Collection<LoanStatus> var3);

    @Cacheable(key="'countLoans_calendarId_' + #calendarId + '_statuses_' + T(org.springframework.util.StringUtils).collectionToCommaDelimitedString(#loanStatuses)")
    @Query(value="SELECT COUNT(ci.id) FROM CalendarInstance ci, Loan loan WHERE loan.id = ci.entityId AND ci.entityTypeId = 3 AND ci.calendar.id = :calendarId AND loan.loanStatus IN :loanStatuses ")
    public Integer countOfLoansSyncedWithCalendar(@Param(value="calendarId") Long var1, @Param(value="loanStatuses") Collection<LoanStatus> var2);

    @CacheEvict(allEntries=true)
    public <S extends CalendarInstance> S save(S var1);

    @CacheEvict(allEntries=true)
    public <S extends CalendarInstance> List<S> saveAll(Iterable<S> var1);

    @CacheEvict(allEntries=true)
    public void delete(CalendarInstance var1);

    @CacheEvict(allEntries=true)
    public void deleteById(Long var1);

    @CacheEvict(allEntries=true)
    public void deleteAll();

    @CacheEvict(allEntries=true)
    public void deleteAll(Iterable<? extends CalendarInstance> var1);

    @CacheEvict(allEntries=true)
    public void deleteAllById(Iterable<? extends Long> var1);

    @CacheEvict(allEntries=true)
    public <S extends CalendarInstance> S saveAndFlush(S var1);
}

