/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.api.ClientApiConstants;
import org.apache.fineract.portfolio.client.api.ClientTransactionsApiResourceSwagger;
import org.apache.fineract.portfolio.client.data.ClientTransactionData;
import org.apache.fineract.portfolio.client.domain.ClientTransaction;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.client.exception.ClientTransactionNotFoundException;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientTransactionReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/clients")
@Component
@Tag(name="Client Transaction", description="Client Transactions refer to transactions made directly against a Client's internal account. Currently, these transactions are only created as a result of charge payments/waivers. You are allowed to undo a transaction, however you cannot explicitly create one. ")
public class ClientTransactionsApiResource {
    private final PlatformSecurityContext context;
    private final ClientTransactionReadPlatformService clientTransactionReadPlatformService;
    private final DefaultToApiJsonSerializer<ClientTransactionData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ClientReadPlatformService clientReadPlatformService;

    @GET
    @Path(value="{clientId}/transactions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Client Transactions", description="The list capability of client transaction can support pagination.\n\nExample Requests:\n\nclients/189/transactions\n\nclients/189/transactions?offset=10&limit=50")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.GetClientsClientIdTransactionsResponse.class))})})
    public String retrieveAllClientTransactions(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        return this.getAllClientTransactions(clientId, uriInfo, offset, limit);
    }

    @GET
    @Path(value="{clientId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Transaction", description="Example Requests:\nclients/1/transactions/1\n\n\nclients/1/transactions/1?fields=id,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.GetClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String retrieveClientTransaction(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        return this.getClientTransaction(clientId, transactionId, uriInfo);
    }

    @POST
    @Path(value="{clientId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Client Transaction", description="Undoes a Client Transaction")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.PostClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String undoClientTransaction(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.undoTransaction(clientId, transactionId, commandParam, apiRequestBodyAsJson);
    }

    @GET
    @Path(value="external-id/{clientExternalId}/transactions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Client Transactions", description="The list capability of client transaction can support pagination.\n\nExample Requests:\n\nclients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions\n\nclients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?offset=10&limit=50")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.GetClientsClientIdTransactionsResponse.class))})})
    public String retrieveAllClientTransactions(@PathParam(value="clientExternalId") @Parameter(description="clientExternalId") String clientExternalId, @Context UriInfo uriInfo, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        ExternalId clientExtId = ExternalIdFactory.produce((String)clientExternalId);
        Long clientId = this.resolveClientId(clientExtId);
        if (Objects.isNull(clientId)) {
            throw new ClientNotFoundException(clientExtId);
        }
        return this.getAllClientTransactions(clientId, uriInfo, offset, limit);
    }

    @GET
    @Path(value="external-id/{clientExternalId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Transaction", description="Example Requests:\nclients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/1\n\n\nclients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/1?fields=id,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.GetClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String retrieveClientTransaction(@PathParam(value="clientExternalId") @Parameter(description="clientExternalId") String clientExternalId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        ExternalId clientExtId = ExternalIdFactory.produce((String)clientExternalId);
        Long clientId = this.resolveClientId(clientExtId);
        if (Objects.isNull(clientId)) {
            throw new ClientNotFoundException(clientExtId);
        }
        return this.getClientTransaction(clientId, transactionId, uriInfo);
    }

    @POST
    @Path(value="external-id/{clientExternalId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Client Transaction", description="Undoes a Client Transaction")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.PostClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String undoClientTransaction(@PathParam(value="clientExternalId") @Parameter(description="clientExternalId") String clientExternalId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        ExternalId clientExtId = ExternalIdFactory.produce((String)clientExternalId);
        Long clientId = this.resolveClientId(clientExtId);
        if (Objects.isNull(clientId)) {
            throw new ClientNotFoundException(clientExtId);
        }
        return this.undoTransaction(clientId, transactionId, commandParam, apiRequestBodyAsJson);
    }

    @GET
    @Path(value="{clientId}/transactions/external-id/{transactionExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Transaction", description="Example Requests:\nclients/1/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854\n\n\nclients/1/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields=id,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.GetClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String retrieveClientTransaction(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="transactionExternalId") @Parameter(description="transactionExternalId") String transactionExternalId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        ExternalId transactionExtId = ExternalIdFactory.produce((String)transactionExternalId);
        Long transactionId = this.resolveTransactionId(transactionExtId);
        if (Objects.isNull(transactionId)) {
            throw new ClientTransactionNotFoundException(clientId, transactionExtId);
        }
        return this.getClientTransaction(clientId, transactionId, uriInfo);
    }

    @GET
    @Path(value="external-id/{clientExternalId}/transactions/external-id/{transactionExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Transaction", description="Example Requests:\nclients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854\n\n\nclients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields=id,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.GetClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String retrieveClientTransaction(@PathParam(value="clientExternalId") @Parameter(description="clientExternalId") String clientExternalId, @PathParam(value="transactionExternalId") @Parameter(description="transactionExternalId") String transactionExternalId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        ExternalId clientExtId = ExternalIdFactory.produce((String)clientExternalId);
        Long clientId = this.resolveClientId(clientExtId);
        if (Objects.isNull(clientId)) {
            throw new ClientNotFoundException(clientExtId);
        }
        ExternalId transactionExtId = ExternalIdFactory.produce((String)transactionExternalId);
        Long transactionId = this.resolveTransactionId(transactionExtId);
        if (Objects.isNull(transactionId)) {
            throw new ClientTransactionNotFoundException(clientId, transactionExtId);
        }
        return this.getClientTransaction(clientId, transactionId, uriInfo);
    }

    @POST
    @Path(value="{clientId}/transactions/external-id/{transactionExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Client Transaction", description="Undoes a Client Transaction")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.PostClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String undoClientTransaction(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="transactionExternalId") @Parameter(description="transactionExternalId") String transactionExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        ExternalId transactionExtId = ExternalIdFactory.produce((String)transactionExternalId);
        Long transactionId = this.resolveTransactionId(transactionExtId);
        if (Objects.isNull(transactionId)) {
            throw new ClientTransactionNotFoundException(clientId, transactionExtId);
        }
        return this.undoTransaction(clientId, transactionId, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="external-id/{clientExternalId}/transactions/external-id/{transactionExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Client Transaction", description="Undoes a Client Transaction")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientTransactionsApiResourceSwagger.PostClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String undoClientTransaction(@PathParam(value="clientExternalId") @Parameter(description="clientExternalId") String clientExternalId, @PathParam(value="transactionExternalId") @Parameter(description="transactionExternalId") String transactionExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        ExternalId clientExtId = ExternalIdFactory.produce((String)clientExternalId);
        Long clientId = this.resolveClientId(clientExtId);
        if (Objects.isNull(clientId)) {
            throw new ClientNotFoundException(clientExtId);
        }
        ExternalId transactionExtId = ExternalIdFactory.produce((String)transactionExternalId);
        Long transactionId = this.resolveTransactionId(transactionExtId);
        if (Objects.isNull(transactionId)) {
            throw new ClientTransactionNotFoundException(clientId, transactionExtId);
        }
        return this.undoTransaction(clientId, transactionId, commandParam, apiRequestBodyAsJson);
    }

    private String getClientTransaction(Long clientId, Long transactionId, UriInfo uriInfo) {
        ClientTransactionData clientTransaction = this.clientTransactionReadPlatformService.retrieveTransaction(clientId, transactionId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)clientTransaction, ClientApiConstants.CLIENT_TRANSACTION_RESPONSE_DATA_PARAMETERS);
    }

    private String getAllClientTransactions(Long clientId, UriInfo uriInfo, Integer offset, Integer limit) {
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).build();
        Page clientTransactions = this.clientTransactionReadPlatformService.retrieveAllTransactions(clientId, searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, clientTransactions, ClientApiConstants.CLIENT_TRANSACTION_RESPONSE_DATA_PARAMETERS);
    }

    private String undoTransaction(Long clientId, Long transactionId, String commandParam, String apiRequestBodyAsJson) {
        if (this.is(commandParam, "undo")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().undoClientTransaction(clientId, transactionId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"undo"});
    }

    private Long resolveClientId(ExternalId clientExternalId) {
        return this.clientReadPlatformService.retrieveClientIdByExternalId(clientExternalId);
    }

    private Long resolveTransactionId(ExternalId transactionExternalId) {
        ClientTransaction clientTransaction = this.clientTransactionReadPlatformService.retrieveTransactionByExternalId(transactionExternalId);
        return !Objects.isNull(clientTransaction) ? (Long)clientTransaction.getId() : null;
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @Generated
    public ClientTransactionsApiResource(PlatformSecurityContext context, ClientTransactionReadPlatformService clientTransactionReadPlatformService, DefaultToApiJsonSerializer<ClientTransactionData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ClientReadPlatformService clientReadPlatformService) {
        this.context = context;
        this.clientTransactionReadPlatformService = clientTransactionReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.clientReadPlatformService = clientReadPlatformService;
    }
}

