/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateral.api.CollateralsApiResourceSwagger;
import org.apache.fineract.portfolio.collateral.data.CollateralData;
import org.apache.fineract.portfolio.collateral.data.LoansLoanIdCollateralsRequest;
import org.apache.fineract.portfolio.collateral.data.LoansLoandIdCollateralsCollateralIdRequest;
import org.apache.fineract.portfolio.collateral.service.CollateralReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans/{loanId}/collaterals")
@Component
@Tag(name="Loan Collateral", description="In lending agreements, collateral is a borrower's pledge of specific property to a lender, to secure repayment of a loan. The collateral serves as protection for a lender against a borrower's default - that is, any borrower failing to pay the principal and interest under the terms of a loan obligation. If a borrower does default on a loan (due to insolvency or other event), that borrower forfeits (gives up) the property pledged as collateral - and the lender then becomes the owner of the collateral")
public class CollateralsApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "type", "value", "description", "allowedCollateralTypes", "currency"));
    private static final String RESOURCE_NAME_FOR_PERMISSION = "COLLATERAL";
    private final CollateralReadPlatformService collateralReadPlatformService;
    private final DefaultToApiJsonSerializer<CollateralData> apiJsonSerializerService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final CodeValueReadPlatformService codeValueReadPlatformService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Collateral Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\nExample Request:\n\nloans/1/collaterals/template")
    public CollateralData newCollateralTemplate(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        List codeValues = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanCollateral");
        return CollateralData.template((Collection)codeValues);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Loan Collaterals", description="Example Requests:\n\nloans/1/collaterals\n\n\nloans/1/collaterals?fields=value,description")
    public List<CollateralData> retrieveCollateralDetails(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        return this.collateralReadPlatformService.retrieveCollateralsForValidLoan(loanId);
    }

    @GET
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Collateral", description="Example Requests:\n\n/loans/1/collaterals/1\n\n\n/loans/1/collaterals/1?fields=description,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.GetLoansLoanIdCollateralsResponse.class))})})
    public String retrieveCollateralDetails(@Context UriInfo uriInfo, @PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long CollateralId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        CollateralData collateralData = this.collateralReadPlatformService.retrieveCollateral(loanId, CollateralId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            List codeValues = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanCollateral");
            collateralData = collateralData.template(collateralData, (Collection)codeValues);
        }
        return this.apiJsonSerializerService.serialize(settings, (Object)collateralData, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Collateral", description="Note: Currently, Collaterals may be added only before a Loan is approved")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansLoanIdCollateralsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.PostLoansLoanIdCollateralsResponse.class))})})
    public CommandProcessingResult createCollateral(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Parameter(hidden=true) LoansLoanIdCollateralsRequest loansLoanIdCollateralsRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCollateral(loanId).withJson(this.apiJsonSerializerService.serialize((Object)loansLoanIdCollateralsRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @PUT
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Collateral")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansLoandIdCollateralsCollateralIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.PutLoansLoanIdCollateralsCollateralIdResponse.class))})})
    public CommandProcessingResult updateCollateral(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId, @Parameter(hidden=true) LoansLoandIdCollateralsCollateralIdRequest loansLoandIdCollateralsCollateralIdRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCollateral(loanId, collateralId).withJson(this.apiJsonSerializerService.serialize((Object)loansLoandIdCollateralsCollateralIdRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @DELETE
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Remove a Collateral", description="Note: A collateral can only be removed from Loans that are not yet approved.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.DeleteLoansLoanIdCollateralsCollateralIdResponse.class))})})
    public CommandProcessingResult deleteCollateral(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCollateral(loanId, collateralId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public CollateralsApiResource(CollateralReadPlatformService collateralReadPlatformService, DefaultToApiJsonSerializer<CollateralData> apiJsonSerializerService, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, CodeValueReadPlatformService codeValueReadPlatformService) {
        this.collateralReadPlatformService = collateralReadPlatformService;
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
    }
}

