/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.service;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateral.data.CollateralData;
import org.apache.fineract.portfolio.collateral.exception.CollateralNotFoundException;
import org.apache.fineract.portfolio.collateral.service.CollateralReadPlatformService;
import org.apache.fineract.portfolio.collateral.service.CollateralReadPlatformServiceImpl;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class CollateralReadPlatformServiceImpl
implements CollateralReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final LoanRepositoryWrapper loanRepositoryWrapper;

    public List<CollateralData> retrieveCollaterals(Long loanId) {
        this.context.authenticatedUser();
        CollateralMapper rm = new CollateralMapper();
        String sql = "select " + rm.schema() + " where lc.loan_id=? order by id ASC";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanId});
    }

    public CollateralData retrieveCollateral(Long loanId, Long collateralId) {
        try {
            CollateralMapper rm = new CollateralMapper();
            String sql = "select " + rm.schema();
            sql = sql + " where lc.loan_id=? and lc.id = ?";
            return (CollateralData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanId, collateralId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new CollateralNotFoundException(loanId, collateralId, e);
        }
    }

    public List<CollateralData> retrieveCollateralsForValidLoan(Long loanId) {
        this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
        return this.retrieveCollaterals(loanId);
    }

    @Generated
    public CollateralReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, LoanRepositoryWrapper loanRepositoryWrapper) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
    }
}

