/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarRepositoryWrapper;
import org.apache.fineract.portfolio.calendar.exception.NotValidRecurringDateException;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.collectionsheet.data.IndividualClientData;
import org.apache.fineract.portfolio.collectionsheet.data.IndividualCollectionSheetData;
import org.apache.fineract.portfolio.collectionsheet.data.IndividualCollectionSheetLoanFlatData;
import org.apache.fineract.portfolio.collectionsheet.data.JLGClientData;
import org.apache.fineract.portfolio.collectionsheet.data.JLGCollectionSheetData;
import org.apache.fineract.portfolio.collectionsheet.data.JLGCollectionSheetFlatData;
import org.apache.fineract.portfolio.collectionsheet.data.JLGGroupData;
import org.apache.fineract.portfolio.collectionsheet.data.LoanDueData;
import org.apache.fineract.portfolio.collectionsheet.data.SavingsDueData;
import org.apache.fineract.portfolio.collectionsheet.serialization.CollectionSheetGenerateCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.collectionsheet.service.CollectionSheetReadPlatformService;
import org.apache.fineract.portfolio.collectionsheet.service.CollectionSheetReadPlatformServiceImpl;
import org.apache.fineract.portfolio.group.data.CenterData;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.service.CenterReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.meeting.attendance.service.AttendanceDropdownReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.data.SavingsProductData;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CollectionSheetReadPlatformServiceImpl
implements CollectionSheetReadPlatformService {
    private final PlatformSecurityContext context;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final CenterReadPlatformService centerReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final CollectionSheetGenerateCommandFromApiJsonDeserializer collectionSheetGenerateCommandFromApiJsonDeserializer;
    private final CalendarRepositoryWrapper calendarRepositoryWrapper;
    private final AttendanceDropdownReadPlatformService attendanceDropdownReadPlatformService;
    private final MandatorySavingsCollectionsheetExtractor mandatorySavingsExtractor;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final ConfigurationDomainService configurationDomainService;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public CollectionSheetReadPlatformServiceImpl(PlatformSecurityContext context, NamedParameterJdbcTemplate namedParameterJdbcTemplate, CenterReadPlatformService centerReadPlatformService, GroupReadPlatformService groupReadPlatformService, CollectionSheetGenerateCommandFromApiJsonDeserializer collectionSheetGenerateCommandFromApiJsonDeserializer, CalendarRepositoryWrapper calendarRepositoryWrapper, AttendanceDropdownReadPlatformService attendanceDropdownReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, CalendarReadPlatformService calendarReadPlatformService, ConfigurationDomainService configurationDomainService, CalendarInstanceRepository calendarInstanceRepository, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.context = context;
        this.centerReadPlatformService = centerReadPlatformService;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.collectionSheetGenerateCommandFromApiJsonDeserializer = collectionSheetGenerateCommandFromApiJsonDeserializer;
        this.groupReadPlatformService = groupReadPlatformService;
        this.calendarRepositoryWrapper = calendarRepositoryWrapper;
        this.attendanceDropdownReadPlatformService = attendanceDropdownReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.configurationDomainService = configurationDomainService;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.sqlGenerator = sqlGenerator;
        this.mandatorySavingsExtractor = new MandatorySavingsCollectionsheetExtractor(sqlGenerator);
    }

    private JLGCollectionSheetData buildJLGCollectionSheet(LocalDate dueDate, Collection<JLGCollectionSheetFlatData> jlgCollectionSheetFlatData) {
        boolean firstTime = true;
        Long prevGroupId = null;
        Long prevClientId = null;
        List paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        ArrayList<JLGGroupData> jlgGroupsData = new ArrayList<JLGGroupData>();
        ArrayList<JLGClientData> clientsData = new ArrayList<JLGClientData>();
        ArrayList<LoanDueData> loansDueData = new ArrayList<LoanDueData>();
        JLGCollectionSheetData jlgCollectionSheetData = null;
        JLGCollectionSheetFlatData prevCollectioSheetFlatData = null;
        JLGCollectionSheetFlatData corrCollectioSheetFlatData = null;
        HashSet<LoanProductData> loanProducts = new HashSet<LoanProductData>();
        if (jlgCollectionSheetFlatData != null) {
            for (JLGCollectionSheetFlatData collectionSheetFlatData : jlgCollectionSheetFlatData) {
                if (collectionSheetFlatData.getProductId() != null) {
                    loanProducts.add(LoanProductData.lookupWithCurrency((Long)collectionSheetFlatData.getProductId(), (String)collectionSheetFlatData.getProductShortName(), (CurrencyData)collectionSheetFlatData.getCurrency()));
                }
                corrCollectioSheetFlatData = collectionSheetFlatData;
                if (firstTime || collectionSheetFlatData.getGroupId().equals(prevGroupId)) {
                    if (firstTime || collectionSheetFlatData.getClientId().equals(prevClientId)) {
                        if (collectionSheetFlatData.getLoanId() != null) {
                            loansDueData.add(collectionSheetFlatData.getLoanDueData());
                        }
                    } else {
                        clientData = prevCollectioSheetFlatData.getClientData();
                        clientData.setLoans(loansDueData);
                        clientsData.add(clientData);
                        loansDueData = new ArrayList();
                        if (collectionSheetFlatData.getLoanId() != null) {
                            loansDueData.add(collectionSheetFlatData.getLoanDueData());
                        }
                    }
                } else {
                    clientData = prevCollectioSheetFlatData.getClientData();
                    clientData.setLoans(loansDueData);
                    clientsData.add(clientData);
                    JLGGroupData jlgGroupData = prevCollectioSheetFlatData.getJLGGroupData();
                    jlgGroupData.setClients(clientsData);
                    jlgGroupsData.add(jlgGroupData);
                    loansDueData = new ArrayList();
                    clientsData = new ArrayList();
                    if (collectionSheetFlatData.getLoanId() != null) {
                        loansDueData.add(collectionSheetFlatData.getLoanDueData());
                    }
                }
                prevClientId = collectionSheetFlatData.getClientId();
                prevGroupId = collectionSheetFlatData.getGroupId();
                prevCollectioSheetFlatData = collectionSheetFlatData;
                firstTime = false;
            }
            if (corrCollectioSheetFlatData != null) {
                JLGClientData lastClientData = corrCollectioSheetFlatData.getClientData();
                lastClientData.setLoans(loansDueData);
                clientsData.add(lastClientData);
                JLGGroupData jlgGroupData = corrCollectioSheetFlatData.getJLGGroupData();
                jlgGroupData.setClients(clientsData);
                jlgGroupsData.add(jlgGroupData);
            }
            jlgCollectionSheetData = JLGCollectionSheetData.instance((LocalDate)dueDate, loanProducts, jlgGroupsData, (List)this.attendanceDropdownReadPlatformService.retrieveAttendanceTypeOptions(), (Collection)paymentOptions);
        }
        return jlgCollectionSheetData;
    }

    public JLGCollectionSheetData generateGroupCollectionSheet(Long groupId, JsonQuery query) {
        this.collectionSheetGenerateCommandFromApiJsonDeserializer.validateForGenerateCollectionSheet(query.json());
        Long calendarId = query.longValueOfParameterNamed("calendarId");
        LocalDate transactionDate = query.localDateValueOfParameterNamed("transactionDate");
        String transactionDateStr = DateUtils.DEFAULT_DATE_FORMATTER.format(transactionDate);
        Calendar calendar = this.calendarRepositoryWrapper.findOneWithNotFoundDetection(calendarId);
        GroupGeneralData group = this.groupReadPlatformService.retrieveOne(groupId);
        CalendarEntityType entityType = group.isChildGroup() ? CalendarEntityType.CENTERS : CalendarEntityType.GROUPS;
        Long entityId = null;
        entityId = group.isChildGroup() ? group.getParentId() : group.getId();
        Boolean isSkipMeetingOnFirstDay = false;
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled) {
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
            isSkipMeetingOnFirstDay = this.calendarReadPlatformService.isCalendarAssociatedWithEntity(entityId, (Long)calendar.getId(), Long.valueOf(entityType.getValue().longValue()));
        }
        if (!calendar.isValidRecurringDate(transactionDate, isSkipMeetingOnFirstDay, numberOfDays)) {
            throw new NotValidRecurringDateException("collectionsheet", "The date '" + String.valueOf(transactionDate) + "' is not a valid meeting date.", new Object[]{transactionDate});
        }
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String officeHierarchy = hierarchy + "%";
        JLGCollectionSheetFaltDataMapper mapper = new JLGCollectionSheetFaltDataMapper(this.sqlGenerator);
        MapSqlParameterSource namedParameters = new MapSqlParameterSource().addValue("dueDate", (Object)transactionDateStr).addValue("groupId", (Object)group.getId()).addValue("officeHierarchy", (Object)officeHierarchy).addValue("entityTypeId", (Object)entityType.getValue());
        List collectionSheetFlatDatas = this.namedParameterJdbcTemplate.query(mapper.collectionSheetSchema(false), (SqlParameterSource)namedParameters, (RowMapper)mapper);
        JLGCollectionSheetData collectionSheetData = this.buildJLGCollectionSheet(transactionDate, (Collection)collectionSheetFlatDatas);
        Collection groupsWithSavingsData = (Collection)this.namedParameterJdbcTemplate.query(this.mandatorySavingsExtractor.collectionSheetSchema(false), (SqlParameterSource)namedParameters, (ResultSetExtractor)this.mandatorySavingsExtractor);
        this.mergeSavingsGroupDataIntoCollectionsheetData(groupsWithSavingsData, collectionSheetData);
        collectionSheetData = JLGCollectionSheetData.withSavingsProducts((JLGCollectionSheetData)collectionSheetData, (Collection)this.retrieveSavingsProducts(groupsWithSavingsData));
        return collectionSheetData;
    }

    private void mergeSavingsGroupDataIntoCollectionsheetData(Collection<JLGGroupData> groupsWithSavingsData, JLGCollectionSheetData collectionSheetData) {
        List groupsWithLoanData = (List)collectionSheetData.getGroups();
        for (JLGGroupData groupSavingsData : groupsWithSavingsData) {
            if (groupsWithLoanData.contains(groupSavingsData)) {
                this.mergeGroup(groupSavingsData, groupsWithLoanData);
                continue;
            }
            groupsWithLoanData.add(groupSavingsData);
        }
    }

    private void mergeGroup(JLGGroupData groupSavingsData, List<JLGGroupData> groupsWithLoanData) {
        int index = groupsWithLoanData.indexOf(groupSavingsData);
        if (index < 0) {
            return;
        }
        JLGGroupData groupLoanData = groupsWithLoanData.get(index);
        List clientsLoanData = (List)groupLoanData.getClients();
        List clientsSavingsData = (List)groupSavingsData.getClients();
        for (JLGClientData clientSavingsData : clientsSavingsData) {
            if (clientsLoanData.contains(clientSavingsData)) {
                this.mergeClient(clientSavingsData, clientsLoanData);
                continue;
            }
            clientsLoanData.add(clientSavingsData);
        }
    }

    private void mergeClient(JLGClientData clientSavingsData, List<JLGClientData> clientsLoanData) {
        int index = clientsLoanData.indexOf(clientSavingsData);
        if (index < 0) {
            return;
        }
        JLGClientData clientLoanData = clientsLoanData.get(index);
        clientLoanData.setSavings(clientSavingsData.getSavings());
    }

    private Collection<SavingsProductData> retrieveSavingsProducts(Collection<JLGGroupData> groupsWithSavingsData) {
        ArrayList<SavingsProductData> savingsProducts = new ArrayList<SavingsProductData>();
        for (JLGGroupData groupSavingsData : groupsWithSavingsData) {
            Collection clientsSavingsData = groupSavingsData.getClients();
            for (JLGClientData clientSavingsData : clientsSavingsData) {
                Collection savingsDatas = clientSavingsData.getSavings();
                for (SavingsDueData savingsDueData : savingsDatas) {
                    SavingsProductData savingsProduct = SavingsProductData.lookup((Long)savingsDueData.productId(), (String)savingsDueData.productName());
                    savingsProduct.setDepositAccountType(savingsDueData.getDepositAccountType());
                    if (savingsProducts.contains(savingsProduct)) continue;
                    savingsProducts.add(savingsProduct);
                }
            }
        }
        return savingsProducts;
    }

    public JLGCollectionSheetData generateCenterCollectionSheet(Long centerId, JsonQuery query) {
        this.collectionSheetGenerateCommandFromApiJsonDeserializer.validateForGenerateCollectionSheet(query.json());
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String officeHierarchy = hierarchy + "%";
        CenterData center = this.centerReadPlatformService.retrieveOne(centerId);
        LocalDate transactionDate = query.localDateValueOfParameterNamed("transactionDate");
        String dueDateStr = DateUtils.DEFAULT_DATE_FORMATTER.format(transactionDate);
        JLGCollectionSheetFaltDataMapper mapper = new JLGCollectionSheetFaltDataMapper(this.sqlGenerator);
        StringBuilder sql = new StringBuilder(mapper.collectionSheetSchema(true));
        MapSqlParameterSource namedParameters = new MapSqlParameterSource().addValue("dueDate", (Object)dueDateStr).addValue("centerId", (Object)center.getId()).addValue("officeHierarchy", (Object)officeHierarchy).addValue("entityTypeId", (Object)CalendarEntityType.CENTERS.getValue());
        List collectionSheetFlatDatas = this.namedParameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)namedParameters, (RowMapper)mapper);
        JLGCollectionSheetData collectionSheetData = this.buildJLGCollectionSheet(transactionDate, (Collection)collectionSheetFlatDatas);
        Collection groupsWithSavingsData = (Collection)this.namedParameterJdbcTemplate.query(this.mandatorySavingsExtractor.collectionSheetSchema(true), (SqlParameterSource)namedParameters, (ResultSetExtractor)this.mandatorySavingsExtractor);
        this.mergeSavingsGroupDataIntoCollectionsheetData(groupsWithSavingsData, collectionSheetData);
        collectionSheetData = JLGCollectionSheetData.withSavingsProducts((JLGCollectionSheetData)collectionSheetData, (Collection)this.retrieveSavingsProducts(groupsWithSavingsData));
        return collectionSheetData;
    }

    public IndividualCollectionSheetData generateIndividualCollectionSheet(JsonQuery query) {
        this.collectionSheetGenerateCommandFromApiJsonDeserializer.validateForGenerateCollectionSheetOfIndividuals(query.json());
        LocalDate transactionDate = query.localDateValueOfParameterNamed("transactionDate");
        String transactionDateStr = DateUtils.DEFAULT_DATE_FORMATTER.format(transactionDate);
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String officeHierarchy = hierarchy + "%";
        Long officeId = query.longValueOfParameterNamed("officeId");
        Long staffId = query.longValueOfParameterNamed("staffId");
        boolean checkForOfficeId = officeId != null;
        boolean checkForStaffId = staffId != null;
        IndividualCollectionSheetFaltDataMapper mapper = new IndividualCollectionSheetFaltDataMapper(checkForOfficeId, checkForStaffId, this.sqlGenerator);
        MapSqlParameterSource namedParameters = new MapSqlParameterSource().addValue("dueDate", (Object)transactionDateStr).addValue("officeHierarchy", (Object)officeHierarchy);
        if (checkForOfficeId) {
            namedParameters.addValue("officeId", (Object)officeId);
        }
        if (checkForStaffId) {
            namedParameters.addValue("staffId", (Object)staffId);
        }
        List collectionSheetFlatDatas = this.namedParameterJdbcTemplate.query(mapper.sqlSchema(), (SqlParameterSource)namedParameters, (RowMapper)mapper);
        IndividualMandatorySavingsCollectionsheetExtractor mandatorySavingsExtractor = new IndividualMandatorySavingsCollectionsheetExtractor(checkForOfficeId, checkForStaffId, this.sqlGenerator);
        Collection clientData = (Collection)this.namedParameterJdbcTemplate.query(mandatorySavingsExtractor.collectionSheetSchema(), (SqlParameterSource)namedParameters, (ResultSetExtractor)mandatorySavingsExtractor);
        this.mergeLoanData((Collection)collectionSheetFlatDatas, (List)clientData);
        List paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        return new IndividualCollectionSheetData(transactionDate, clientData, (Collection)paymentOptions);
    }

    private void mergeLoanData(Collection<IndividualCollectionSheetLoanFlatData> loanFlatDatas, List<IndividualClientData> clientDatas) {
        IndividualClientData clientSavingsData = null;
        for (IndividualCollectionSheetLoanFlatData loanFlatData : loanFlatDatas) {
            IndividualClientData clientData = loanFlatData.getClientData();
            if (clientSavingsData == null || !clientSavingsData.equals((Object)clientData)) {
                if (clientDatas.contains(clientData)) {
                    int index = clientDatas.indexOf(clientData);
                    if (index < 0) {
                        return;
                    }
                    clientSavingsData = clientDatas.get(index);
                    clientSavingsData.setLoans(new ArrayList());
                } else {
                    clientSavingsData = clientData;
                    clientSavingsData.setLoans(new ArrayList());
                    clientDatas.add(clientSavingsData);
                }
            }
            clientSavingsData.addLoans(loanFlatData.getLoanDueData());
        }
    }
}

