/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.fund.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.fund.api.FundsApiResourceSwagger;
import org.apache.fineract.portfolio.fund.data.FundData;
import org.apache.fineract.portfolio.fund.data.FundRequest;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/funds")
@Component
@Tag(name="Funds", description="")
public class FundsApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "externalId"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "FUND";
    private final PlatformSecurityContext context;
    private final FundReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<FundData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Funds", description="Returns the list of funds.\n\nExample Requests:\n\nfunds")
    public List<FundData> retrieveFunds() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveAllFunds();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Fund", description="Creates a Fund")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=FundRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FundsApiResourceSwagger.PostFundsResponse.class))})})
    public CommandProcessingResult createFund(@Parameter(hidden=true) FundRequest fundRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createFund().withJson(this.toApiJsonSerializer.serialize((Object)fundRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="{fundId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Fund", description="Returns the details of a Fund.\n\nExample Requests:\n\nfunds/1")
    public FundData retrieveFund(@PathParam(value="fundId") @Parameter(description="fundId") Long fundId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveFund(fundId);
    }

    @PUT
    @Path(value="{fundId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Fund", description="Updates the details of a fund.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=FundRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FundsApiResourceSwagger.PutFundsFundIdResponse.class))})})
    public String updateFund(@PathParam(value="fundId") @Parameter(description="fundId") Long fundId, @Parameter(hidden=true) FundRequest fundRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateFund(fundId).withJson(this.toApiJsonSerializer.serialize((Object)fundRequest)).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public FundsApiResource(PlatformSecurityContext context, FundReadPlatformService readPlatformService, DefaultToApiJsonSerializer<FundData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

