/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.service;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartData;
import org.apache.fineract.portfolio.interestratechart.exception.InterestRateChartNotFoundException;
import org.apache.fineract.portfolio.interestratechart.service.InterestIncentiveDropdownReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartDropdownReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartReadPlatformServiceImpl;
import org.apache.fineract.portfolio.savings.data.DepositProductData;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public class InterestRateChartReadPlatformServiceImpl
implements InterestRateChartReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private static final InterestRateChartMapper CHART_ROW_MAPPER = new InterestRateChartMapper();
    private final InterestRateChartExtractor chartExtractor;
    private final InterestRateChartDropdownReadPlatformService chartDropdownReadPlatformService;
    private final InterestIncentiveDropdownReadPlatformService interestIncentiveDropdownReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;

    public InterestRateChartReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, InterestRateChartDropdownReadPlatformService chartDropdownReadPlatformService, InterestIncentiveDropdownReadPlatformService interestIncentiveDropdownReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.chartDropdownReadPlatformService = chartDropdownReadPlatformService;
        this.interestIncentiveDropdownReadPlatformService = interestIncentiveDropdownReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.chartExtractor = new InterestRateChartExtractor(sqlGenerator);
    }

    public InterestRateChartData retrieveOne(Long chartId) {
        try {
            this.context.authenticatedUser();
            String sql = "select " + CHART_ROW_MAPPER.schema() + " where irc.id = ?";
            return (InterestRateChartData)this.jdbcTemplate.queryForObject(sql, (RowMapper)CHART_ROW_MAPPER, new Object[]{chartId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new InterestRateChartNotFoundException(chartId, e);
        }
    }

    public Collection<InterestRateChartData> retrieveAllWithSlabs(Long productId) {
        this.context.authenticatedUser();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(this.chartExtractor.schema());
        sql.append(" where sp.id = ? order by irc.id, ");
        sql.append("CASE ");
        sql.append("WHEN irc.is_primary_grouping_by_amount then ircd.amount_range_from ");
        sql.append("WHEN irc.is_primary_grouping_by_amount then ircd.amount_range_to ");
        sql.append("END,");
        sql.append("ircd.from_period, ircd.to_period,");
        sql.append("CASE ");
        sql.append("WHEN NOT irc.is_primary_grouping_by_amount then ircd.amount_range_from ");
        sql.append("WHEN NOT irc.is_primary_grouping_by_amount then ircd.amount_range_to ");
        sql.append("END");
        return (Collection)this.jdbcTemplate.query(con -> con.prepareStatement(sql.toString(), 1005, 1008), ps -> ps.setLong(1, productId), (ResultSetExtractor)this.chartExtractor);
    }

    public Collection<InterestRateChartData> retrieveAllWithSlabsWithTemplate(Long productId) {
        ArrayList<InterestRateChartData> chartDatas = new ArrayList<InterestRateChartData>();
        for (InterestRateChartData chartData : this.retrieveAllWithSlabs(productId)) {
            chartDatas.add(this.retrieveWithTemplate(chartData));
        }
        return chartDatas;
    }

    public InterestRateChartData retrieveActiveChartWithTemplate(Long productId) {
        Collection chartDatas = this.retrieveAllWithSlabsWithTemplate(productId);
        return DepositProductData.activeChart((Collection)chartDatas);
    }

    public InterestRateChartData retrieveOneWithSlabs(Long chartId) {
        this.context.authenticatedUser();
        String sql = "select " + this.chartExtractor.schema() + " where irc.id = ? order by ircd.id asc";
        Collection chartDatas = (Collection)this.jdbcTemplate.query(sql, (ResultSetExtractor)this.chartExtractor, new Object[]{chartId});
        if (chartDatas == null || chartDatas.isEmpty()) {
            throw new InterestRateChartNotFoundException(chartId);
        }
        return (InterestRateChartData)chartDatas.iterator().next();
    }

    public InterestRateChartData retrieveWithTemplate(InterestRateChartData chartData) {
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        return InterestRateChartData.withTemplate((InterestRateChartData)chartData, (Collection)this.chartDropdownReadPlatformService.retrievePeriodTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveEntityTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveAttributeNameOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveConditionTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveIncentiveTypeOptions(), genderOptions, clientTypeOptions, clientClassificationOptions);
    }

    public InterestRateChartData retrieveOneWithSlabsOnProductId(Long productId) {
        return null;
    }

    public InterestRateChartData template() {
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        return InterestRateChartData.template((Collection)this.chartDropdownReadPlatformService.retrievePeriodTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveEntityTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveAttributeNameOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveConditionTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveIncentiveTypeOptions(), genderOptions, clientTypeOptions, clientClassificationOptions);
    }
}

