/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.recalculateinterestforloan;

import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.jobs.recalculateinterestforloan.RecalculateInterestForLoanTasklet;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.RecalculateInterestPoster;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class RecalculateInterestForLoanConfig {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private LoanReadPlatformService loanReadPlatformService;
    @Autowired
    private LoanWritePlatformService loanWritePlatformService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private OfficeReadPlatformService officeReadPlatformService;
    @Autowired
    @Qualifier(value="fineractDefaultThreadPoolTaskExecutor")
    private ThreadPoolTaskExecutor taskExecutor;

    @Bean
    protected Step recalculateInterestForLoanStep() {
        return new StepBuilder(JobName.RECALCULATE_INTEREST_FOR_LOAN.name(), this.jobRepository).tasklet((Tasklet)this.recalculateInterestForLoanTasklet(), this.transactionManager).build();
    }

    @Bean
    public Job recalculateInterestForLoanJob() {
        return ((SimpleJobBuilder)new JobBuilder(JobName.RECALCULATE_INTEREST_FOR_LOAN.name(), this.jobRepository).start(this.recalculateInterestForLoanStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean(value={RecalculateInterestPoster.class})
    public RecalculateInterestPoster recalculateInterestPoster() {
        return new RecalculateInterestPoster(this.loanWritePlatformService);
    }

    @Bean
    public RecalculateInterestForLoanTasklet recalculateInterestForLoanTasklet() {
        return new RecalculateInterestForLoanTasklet(this.loanReadPlatformService, this.loanWritePlatformService, this.applicationContext, this.officeReadPlatformService, this.taskExecutor);
    }
}

