/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.loanschedule.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanScheduleVariationsAddedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanScheduleVariationsDeletedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.loanaccount.data.LoanTermVariationsData;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariations;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleAssembler;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoanScheduleWritePlatformServiceImpl
implements LoanScheduleWritePlatformService {
    private final LoanAssembler loanAssembler;
    private final LoanScheduleAssembler loanScheduleAssembler;
    private final LoanUtilService loanUtilService;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanScheduleService loanScheduleService;
    private final LoanAccountService loanAccountService;

    public CommandProcessingResult addLoanScheduleVariations(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        HashMap<Long, LoanTermVariations> loanTermVariations = new HashMap<Long, LoanTermVariations>();
        for (LoanTermVariations termVariations : loan.getLoanTermVariations()) {
            loanTermVariations.put((Long)termVariations.getId(), termVariations);
        }
        this.loanScheduleAssembler.assempleVariableScheduleFrom(loan, command.json());
        this.loanAccountService.saveLoanWithDataIntegrityViolationChecks(loan);
        HashMap<String, Collection<Object>> changes = new HashMap<String, Collection<Object>>();
        ArrayList<LoanTermVariationsData> newVariationsData = new ArrayList<LoanTermVariationsData>();
        List modifiedVariations = loan.getLoanTermVariations();
        for (LoanTermVariations termVariations : modifiedVariations) {
            if (loanTermVariations.containsKey(termVariations.getId())) {
                loanTermVariations.remove(termVariations.getId());
                continue;
            }
            newVariationsData.add(termVariations.toData());
        }
        if (!loanTermVariations.isEmpty()) {
            changes.put("removedVariations", loanTermVariations.keySet());
        }
        changes.put("loanTermVariations", newVariationsData);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanScheduleVariationsAddedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId(loanId).with(changes).build();
    }

    public CommandProcessingResult deleteLoanScheduleVariations(Long loanId) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        List variations = loan.getLoanTermVariations();
        ArrayList<Long> deletedVariations = new ArrayList<Long>(variations.size());
        for (LoanTermVariations loanTermVariations : variations) {
            deletedVariations.add((Long)loanTermVariations.getId());
        }
        HashMap<String, ArrayList<Long>> changes = new HashMap<String, ArrayList<Long>>();
        changes.put("removedEntityIds", deletedVariations);
        loan.getLoanTermVariations().clear();
        LocalDate recalculateFrom = null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, false);
        this.loanAccountService.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanScheduleVariationsDeletedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withLoanId(loanId).with(changes).build();
    }

    @Generated
    public LoanScheduleWritePlatformServiceImpl(LoanAssembler loanAssembler, LoanScheduleAssembler loanScheduleAssembler, LoanUtilService loanUtilService, BusinessEventNotifierService businessEventNotifierService, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanScheduleService loanScheduleService, LoanAccountService loanAccountService) {
        this.loanAssembler = loanAssembler;
        this.loanScheduleAssembler = loanScheduleAssembler;
        this.loanUtilService = loanUtilService;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanScheduleService = loanScheduleService;
        this.loanAccountService = loanAccountService;
    }
}

