/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.savings.data.SavingsAccountConstant;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountSubStatusEnum;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.exception.TransactionBeforePivotDateNotAllowed;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.stereotype.Component;

@Component
public class SavingsAccountTransactionDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> SAVINGS_ACCOUNT_HOLD_AMOUNT_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("transactionDate", "dateFormat", "locale", "transactionAmount", "lienAllowed", "reasonForBlock"));
    private final ConfigurationDomainService configurationDomainService;

    public void validateTransactionWithPivotDate(LocalDate transactionDate, SavingsAccount savingsAccount) {
        boolean backdatedTxnsAllowedTill = this.configurationDomainService.retrievePivotDateConfig();
        boolean isRelaxingDaysConfigOn = this.configurationDomainService.isRelaxingDaysConfigForPivotDateEnabled();
        LocalDate lastInterestPostingDate = savingsAccount.getSummary().getInterestPostedTillDate();
        if (backdatedTxnsAllowedTill && lastInterestPostingDate != null) {
            LocalDate pivotDate = lastInterestPostingDate;
            if (isRelaxingDaysConfigOn) {
                pivotDate = pivotDate.minusDays(this.configurationDomainService.retrieveRelaxingDaysConfigForPivotDate());
            }
            if (DateUtils.isAfter((LocalDate)pivotDate, (LocalDate)transactionDate)) {
                throw new TransactionBeforePivotDateNotAllowed(transactionDate, pivotDate);
            }
        }
    }

    public void validate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SavingsAccountConstant.SAVINGS_ACCOUNT_TRANSACTION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount.transaction");
        JsonElement element = command.parsedJson();
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
        baseDataValidator.reset().parameter("transactionAmount").value((Object)transactionAmount).notNull().positiveAmount();
        Integer paymentType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("paymentTypeId", element);
        baseDataValidator.reset().parameter("paymentTypeId").value((Object)paymentType).notNull();
        this.validatePaymentTypeDetails(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateActivation(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SavingsAccountConstant.SAVINGS_ACCOUNT_ACTIVATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        JsonElement element = command.parsedJson();
        LocalDate activationDate = this.fromApiJsonHelper.extractLocalDateNamed("activatedOnDate", element);
        baseDataValidator.reset().parameter("activatedOnDate").value((Object)activationDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateClosing(JsonCommand command, SavingsAccount account) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SavingsAccountConstant.SAVINGS_ACCOUNT_CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        JsonElement element = command.parsedJson();
        LocalDate closedonDate = this.fromApiJsonHelper.extractLocalDateNamed("closedOnDate", element);
        baseDataValidator.reset().parameter("closedOnDate").value((Object)closedonDate).notNull();
        if (this.fromApiJsonHelper.parameterExists("withdrawBalance", element)) {
            Boolean withdrawBalance = this.fromApiJsonHelper.extractBooleanNamed("withdrawBalance", element);
            baseDataValidator.reset().parameter("withdrawBalance").value((Object)withdrawBalance).isOneOfTheseValues(new Object[]{true, false});
        }
        if (account.getSavingsHoldAmount().compareTo(BigDecimal.ZERO) > 0) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("amount.is.on.hold.release.the.amount.to.continue", new Object[]{account.getId()});
        }
        if (account.getSubStatus().equals(SavingsAccountSubStatusEnum.BLOCK.getValue()) || account.getSubStatus().equals(SavingsAccountSubStatusEnum.BLOCK_CREDIT.getValue()) || account.getSubStatus().equals(SavingsAccountSubStatusEnum.BLOCK_DEBIT.getValue())) {
            baseDataValidator.reset().parameter("subStatus").failWithCodeNoParameterAddedToErrorCode("account.is.in.blocked.state", new Object[0]);
        }
        this.validatePaymentTypeDetails(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validatePaymentTypeDetails(DataValidatorBuilder baseDataValidator, JsonElement element) {
        boolean checkPaymentTypeDetails = false;
        Integer paymentTypeId = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("paymentTypeId", element);
        baseDataValidator.reset().parameter("paymentTypeId").value((Object)paymentTypeId).ignoreIfNull().integerGreaterThanZero();
        HashSet<String> paymentDetailParameters = new HashSet<String>(Arrays.asList("accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber"));
        for (String paymentDetailParameterName : paymentDetailParameters) {
            String paymentDetailParameterValue = this.fromApiJsonHelper.extractStringNamed(paymentDetailParameterName, element);
            baseDataValidator.reset().parameter(paymentDetailParameterName).value((Object)paymentDetailParameterValue).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
            if (paymentDetailParameterValue == null || paymentDetailParameterValue.equals("")) continue;
            checkPaymentTypeDetails = true;
        }
        if (checkPaymentTypeDetails) {
            baseDataValidator.reset().parameter("paymentTypeId").value((Object)paymentTypeId).notBlank().integerGreaterThanZero();
        }
    }

    public void validateHoldAndAssembleForm(String json, SavingsAccount account, AppUser createdUser, boolean backdatedTxnsAllowedTill) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SAVINGS_ACCOUNT_HOLD_AMOUNT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
        baseDataValidator.reset().parameter("transactionAmount").value((Object)amount).notNull().positiveAmount();
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        String reasonForBlock = this.fromApiJsonHelper.extractStringNamed("reasonForBlock", element);
        baseDataValidator.reset().parameter("reasonForBlock").value((Object)reasonForBlock).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        boolean isActive = account.isActive();
        if (!isActive) {
            baseDataValidator.reset().parameter("status").failWithCodeNoParameterAddedToErrorCode("not.in.active.state", new Object[0]);
        }
        Boolean isEnforceMinRequiredBalanceEnabled = account.getEnforceMinRequiredBalance();
        Boolean isAccountLienEnabled = account.isLienAllowed();
        Boolean isOverdraftEnabled = account.isAllowOverdraft();
        Boolean lienAllowed = false;
        if (BooleanUtils.isTrue((Boolean)this.fromApiJsonHelper.extractBooleanNamed("lienAllowed", element))) {
            lienAllowed = this.fromApiJsonHelper.extractBooleanNamed("lienAllowed", element);
            if (isAccountLienEnabled.booleanValue()) {
                if (isOverdraftEnabled.booleanValue() && account.getOverdraftLimit().compareTo(account.getMaxAllowedLienLimit()) > 0) {
                    baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("Overdraft.limit.can.not.be.greater.than.lien.limit", new Object[]{account.getId()});
                }
                if (amount.compareTo(account.getMaxAllowedLienLimit()) > 0) {
                    baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("lien.limit.exceeded", new Object[]{account.getId()});
                }
            } else {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("lien.is.not.allowed.in.product.level", new Object[]{account.getId()});
            }
        } else {
            if (isOverdraftEnabled.booleanValue() && amount.compareTo(account.getWithdrawableBalance()) > 0 && amount.compareTo(account.getOverdraftLimit()) > 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("insufficient.balance", new Object[]{account.getId()});
            }
            if (isEnforceMinRequiredBalanceEnabled.booleanValue() && amount.compareTo(account.getWithdrawableBalance()) > 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("insufficient.balance", new Object[]{account.getId()});
            }
            if (!isOverdraftEnabled.booleanValue() && !isEnforceMinRequiredBalanceEnabled.booleanValue() && amount.compareTo(account.getWithdrawableBalance()) > 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("insufficient.balance", new Object[]{account.getId()});
            }
        }
        LocalDate lastTransactionDate = null;
        lastTransactionDate = !backdatedTxnsAllowedTill ? account.retrieveLastTransactionDate() : account.retrieveLastTransactionDateWithPivotConfig();
        if (DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)lastTransactionDate)) {
            baseDataValidator.parameter("date").value((Object)lastTransactionDate).failWithCode("validation.msg.date.can.not.be.before.last.transaction.date", new Object[]{"Amount can be put on hold only after last transaction"});
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public SavingsAccountTransaction validateReleaseAmountAndAssembleForm(SavingsAccountTransaction holdTransaction) {
        boolean isActive;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        if (holdTransaction == null) {
            baseDataValidator.failWithCode("validation.msg.validation.errors.exist", new Object[]{"Transaction not found"});
        } else if (holdTransaction.getReleaseIdOfHoldAmountTransaction() != null) {
            baseDataValidator.parameter("amount").value((Object)holdTransaction.getAmount()).failWithCode("validation.msg.amount.is.not.on.hold", new Object[]{"Transaction amount is not on hold"});
        }
        if (holdTransaction != null && !(isActive = holdTransaction.getSavingsAccount().isActive())) {
            baseDataValidator.reset().parameter("status").failWithCodeNoParameterAddedToErrorCode("not.in.active.state", new Object[0]);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        SavingsAccountTransaction transaction = SavingsAccountTransaction.releaseAmount((SavingsAccountTransaction)holdTransaction, (LocalDate)transactionDate);
        return transaction;
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    @Generated
    public SavingsAccountTransactionDataValidator(FromJsonHelper fromApiJsonHelper, ConfigurationDomainService configurationDomainService) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.configurationDomainService = configurationDomainService;
    }
}

