/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.portfolio.savings.data.DepositAccountOnHoldTransactionData;
import org.apache.fineract.portfolio.savings.service.DepositAccountOnHoldTransactionReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountOnHoldTransactionReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DepositAccountOnHoldTransactionReadPlatformServiceImpl
implements DepositAccountOnHoldTransactionReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ColumnValidator columnValidator;
    private final PaginationHelper paginationHelper;
    private final DepositAccountOnHoldTransactionsMapper mapper = new DepositAccountOnHoldTransactionsMapper();

    public Page<DepositAccountOnHoldTransactionData> retriveAll(Long savingsId, Long guarantorFundingId, SearchParameters searchParameters) {
        StringBuilder sqlBuilder = new StringBuilder(200);
        ArrayList<Long> paramObj = new ArrayList<Long>(2);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.mapper.schema());
        sqlBuilder.append(" where tr.savings_account_id = ? ");
        paramObj.add(savingsId);
        if (guarantorFundingId != null) {
            sqlBuilder.append(" and gt.guarantor_fund_detail_id = ? ");
            paramObj.add(guarantorFundingId);
        }
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        Object[] finalObjectArray = paramObj.toArray();
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)this.mapper);
    }

    @Generated
    public DepositAccountOnHoldTransactionReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, ColumnValidator columnValidator, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
    }
}

