/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.tax.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.tax.api.TaxGroupApiResourceSwagger;
import org.apache.fineract.portfolio.tax.data.TaxGroupData;
import org.apache.fineract.portfolio.tax.request.TaxGroupRequest;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/taxes/group")
@Component
@Tag(name="Tax Group", description="This defines the Tax Group")
public class TaxGroupApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "TAXGROUP";
    private final PlatformSecurityContext context;
    private final TaxReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<String> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Tax Group", description="List Tax Group")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TaxGroupApiResourceSwagger.GetTaxesGroupResponse.class)))})})
    public List<TaxGroupData> retrieveAllTaxGroups() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveAllTaxGroups();
    }

    @GET
    @Path(value="{taxGroupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Tax Group", description="Retrieve Tax Group")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TaxGroupApiResourceSwagger.GetTaxesGroupResponse.class))})})
    public TaxGroupData retrieveTaxGroup(@PathParam(value="taxGroupId") @Parameter(description="taxGroupId") Long taxGroupId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return settings.isTemplate() ? this.readPlatformService.retrieveTaxGroupWithTemplate(taxGroupId) : this.readPlatformService.retrieveTaxGroupData(taxGroupId);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TaxGroupData retrieveTemplate() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveTaxGroupTemplate();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new Tax Group", description="Create a new Tax Group\nMandatory Fields: name and taxComponents\nMandatory Fields in taxComponents: taxComponentId\nOptional Fields in taxComponents: id, startDate and endDate")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=TaxGroupApiResourceSwagger.PostTaxesGroupRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TaxGroupApiResourceSwagger.PostTaxesGroupResponse.class))})})
    public CommandProcessingResult createTaxGroup(@Parameter(hidden=true) TaxGroupRequest taxGroupRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createTaxGroup().withJson(this.toApiJsonSerializer.serialize((Object)taxGroupRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @PUT
    @Path(value="{taxGroupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Tax Group", description="Updates Tax Group. Only end date can be up-datable and can insert new tax components.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=TaxGroupApiResourceSwagger.PutTaxesGroupTaxGroupIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TaxGroupApiResourceSwagger.PutTaxesGroupTaxGroupIdResponse.class))})})
    public CommandProcessingResult updateTaxGroup(@PathParam(value="taxGroupId") @Parameter(description="taxGroupId") Long taxGroupId, @Parameter(hidden=true) TaxGroupRequest taxGroupRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateTaxGroup(taxGroupId).withJson(this.toApiJsonSerializer.serialize((Object)taxGroupRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public TaxGroupApiResource(PlatformSecurityContext context, TaxReadPlatformService readPlatformService, DefaultToApiJsonSerializer<String> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

