/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.api.PermissionsApiResourceSwagger;
import org.apache.fineract.useradministration.data.PermissionData;
import org.apache.fineract.useradministration.service.PermissionReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/permissions")
@Component
@Tag(name="Permissions", description="An API capability to support management of application permissions for user administration.\n\nThere is no Apache Fineract functionality for creating or deleting permissions. Permissions come pre-installed.\n\nPermissions are not updated, except in the case of enabling or disabling non-read transactions for Maker Checker functionality")
public class PermissionsApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("grouping", "code", "entityName", "actionName", "selected", "isMakerChecker"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "PERMISSION";
    private final PlatformSecurityContext context;
    private final PermissionReadPlatformService permissionReadPlatformService;
    private final DefaultToApiJsonSerializer<PermissionData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Application Permissions", description="ARGUMENTS\nmakerCheckerableoptional, Values are true, false. Default is false.\nIf makerCheckerable=false or not supplied then a list of application permissions is returned. The \"selected\" attribute is always true in this case.\n\nIf makerCheckerable=true then the \"selected\" attribute shows whether the permission is enabled for Maker Check functionality.\n\nNote: Each Apache Fineract transaction is associated with a permission.\n\nExample Requests:\n\npermissions\n\n\npermissions?makerCheckerable=true\n\n\npermissions?fields=grouping,code")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PermissionsApiResourceSwagger.GetPermissionsResponse.class)))})})
    public String retrieveAllPermissions(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        Collection permissions = settings.isMakerCheckerable() ? this.permissionReadPlatformService.retrieveAllMakerCheckerablePermissions() : this.permissionReadPlatformService.retrieveAllPermissions();
        return this.toApiJsonSerializer.serialize(settings, permissions, RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Enable/Disable Permissions for Maker Checker", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=PermissionsApiResourceSwagger.PutPermissionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CommandProcessingResult.class))})})
    public String updatePermissionsDetails(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updatePermissions().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public PermissionsApiResource(PlatformSecurityContext context, PermissionReadPlatformService permissionReadPlatformService, DefaultToApiJsonSerializer<PermissionData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.permissionReadPlatformService = permissionReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

