/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import jakarta.persistence.PersistenceException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.command.PermissionsCommand;
import org.apache.fineract.useradministration.domain.Permission;
import org.apache.fineract.useradministration.domain.PermissionRepository;
import org.apache.fineract.useradministration.domain.Role;
import org.apache.fineract.useradministration.domain.RoleRepository;
import org.apache.fineract.useradministration.exception.PermissionNotFoundException;
import org.apache.fineract.useradministration.exception.RoleAssociatedException;
import org.apache.fineract.useradministration.exception.RoleNotFoundException;
import org.apache.fineract.useradministration.serialization.PermissionsCommandFromApiJsonDeserializer;
import org.apache.fineract.useradministration.service.RoleDataValidator;
import org.apache.fineract.useradministration.service.RoleWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class RoleWritePlatformServiceJpaRepositoryImpl
implements RoleWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final RoleRepository roleRepository;
    private final PermissionRepository permissionRepository;
    private final RoleDataValidator roleCommandFromApiJsonDeserializer;
    private final PermissionsCommandFromApiJsonDeserializer permissionsFromApiJsonDeserializer;

    @Transactional
    public CommandProcessingResult createRole(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.roleCommandFromApiJsonDeserializer.validateForCreate(command.json());
            Role entity = Role.fromJson((JsonCommand)command);
            this.roleRepository.saveAndFlush((Object)entity);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)entity.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("unq_name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.role.duplicate.name", "Role with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.role.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Caching(evict={@CacheEvict(value={"users"}, allEntries=true), @CacheEvict(value={"usersByUsername"}, allEntries=true)})
    @Transactional
    public CommandProcessingResult updateRole(Long roleId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.roleCommandFromApiJsonDeserializer.validateForUpdate(command.json());
            Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new RoleNotFoundException(roleId));
            String previousRoleName = role.getName();
            Map changes = role.update(command);
            if (!changes.isEmpty()) {
                this.roleRepository.saveAndFlush((Object)role);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(roleId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
    }

    @Caching(evict={@CacheEvict(value={"users"}, allEntries=true), @CacheEvict(value={"usersByUsername"}, allEntries=true)})
    @Transactional
    public CommandProcessingResult updateRolePermissions(Long roleId, JsonCommand command) {
        this.context.authenticatedUser();
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new RoleNotFoundException(roleId));
        List allPermissions = this.permissionRepository.findAll();
        PermissionsCommand permissionsCommand = this.permissionsFromApiJsonDeserializer.commandFromApiJson(command.json());
        Map commandPermissions = permissionsCommand.getPermissions();
        HashMap changes = new HashMap();
        HashMap<String, Boolean> changedPermissions = new HashMap<String, Boolean>();
        for (Map.Entry entry : commandPermissions.entrySet()) {
            boolean isSelected = (Boolean)entry.getValue();
            Permission permission = this.findPermissionByCode((Collection)allPermissions, (String)entry.getKey());
            boolean changed = role.updatePermission(permission, isSelected);
            if (!changed) continue;
            changedPermissions.put((String)entry.getKey(), isSelected);
        }
        if (!changedPermissions.isEmpty()) {
            changes.put("permissions", changedPermissions);
            this.roleRepository.saveAndFlush((Object)role);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(roleId).with(changes).build();
    }

    private Permission findPermissionByCode(Collection<Permission> allPermissions, String permissionCode) {
        if (allPermissions != null) {
            for (Permission permission : allPermissions) {
                if (!permission.hasCode(permissionCode)) continue;
                return permission;
            }
        }
        throw new PermissionNotFoundException(permissionCode);
    }

    @Transactional
    public CommandProcessingResult deleteRole(Long roleId) {
        try {
            Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new RoleNotFoundException(roleId));
            Integer count = this.roleRepository.getCountOfRolesAssociatedWithUsers(roleId);
            if (count > 0) {
                throw new RoleAssociatedException("error.msg.role.associated.with.users.deleted", roleId);
            }
            this.roleRepository.delete((Object)role);
            return new CommandProcessingResultBuilder().withEntityId(roleId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + String.valueOf(e.getMostSpecificCause())));
        }
    }

    @Transactional
    public CommandProcessingResult disableRole(Long roleId) {
        try {
            Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new RoleNotFoundException(roleId));
            Integer count = this.roleRepository.getCountOfRolesAssociatedWithUsers(roleId);
            if (count > 0) {
                throw new RoleAssociatedException("error.msg.role.associated.with.users.disabled", roleId);
            }
            role.disableRole();
            this.roleRepository.saveAndFlush((Object)role);
            return new CommandProcessingResultBuilder().withEntityId(roleId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + String.valueOf(e.getMostSpecificCause())));
        }
    }

    @Transactional
    public CommandProcessingResult enableRole(Long roleId) {
        try {
            Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new RoleNotFoundException(roleId));
            role.enableRole();
            this.roleRepository.saveAndFlush((Object)role);
            return new CommandProcessingResultBuilder().withEntityId(roleId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + String.valueOf(e.getMostSpecificCause())));
        }
    }

    @Generated
    public RoleWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, RoleRepository roleRepository, PermissionRepository permissionRepository, RoleDataValidator roleCommandFromApiJsonDeserializer, PermissionsCommandFromApiJsonDeserializer permissionsFromApiJsonDeserializer) {
        this.context = context;
        this.roleRepository = roleRepository;
        this.permissionRepository = permissionRepository;
        this.roleCommandFromApiJsonDeserializer = roleCommandFromApiJsonDeserializer;
        this.permissionsFromApiJsonDeserializer = permissionsFromApiJsonDeserializer;
    }
}

