/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.client.models.ChargeFeeOnMonthDay;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GLAccountData;
import org.apache.fineract.client.models.PaymentTypeData;
import org.apache.fineract.client.models.TaxGroupData;

/**
 * ChargeData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class ChargeData {
  public static final String SERIALIZED_NAME_ACCOUNT_MAPPING_FOR_CHARGE_CONFIG = "accountMappingForChargeConfig";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_MAPPING_FOR_CHARGE_CONFIG)
  private String accountMappingForChargeConfig;

  public static final String SERIALIZED_NAME_ACTIVE = "active";
  @SerializedName(SERIALIZED_NAME_ACTIVE)
  private Boolean active;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_ASSET_ACCOUNT_OPTIONS = "assetAccountOptions";
  @SerializedName(SERIALIZED_NAME_ASSET_ACCOUNT_OPTIONS)
  private List<GLAccountData> assetAccountOptions;

  public static final String SERIALIZED_NAME_CHARGE_APPLIES_TO = "chargeAppliesTo";
  @SerializedName(SERIALIZED_NAME_CHARGE_APPLIES_TO)
  private EnumOptionData chargeAppliesTo;

  public static final String SERIALIZED_NAME_CHARGE_APPLIES_TO_OPTIONS = "chargeAppliesToOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_APPLIES_TO_OPTIONS)
  private List<EnumOptionData> chargeAppliesToOptions;

  public static final String SERIALIZED_NAME_CHARGE_CALCULATION_TYPE = "chargeCalculationType";
  @SerializedName(SERIALIZED_NAME_CHARGE_CALCULATION_TYPE)
  private EnumOptionData chargeCalculationType;

  public static final String SERIALIZED_NAME_CHARGE_CALCULATION_TYPE_OPTIONS = "chargeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_CALCULATION_TYPE_OPTIONS)
  private List<EnumOptionData> chargeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_CHARGE_PAYMENT_MODE = "chargePaymentMode";
  @SerializedName(SERIALIZED_NAME_CHARGE_PAYMENT_MODE)
  private EnumOptionData chargePaymentMode;

  public static final String SERIALIZED_NAME_CHARGE_PAYMET_MODE_OPTIONS = "chargePaymetModeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_PAYMET_MODE_OPTIONS)
  private List<EnumOptionData> chargePaymetModeOptions;

  public static final String SERIALIZED_NAME_CHARGE_TIME_TYPE = "chargeTimeType";
  @SerializedName(SERIALIZED_NAME_CHARGE_TIME_TYPE)
  private EnumOptionData chargeTimeType;

  public static final String SERIALIZED_NAME_CHARGE_TIME_TYPE_OPTIONS = "chargeTimeTypeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_TIME_TYPE_OPTIONS)
  private List<EnumOptionData> chargeTimeTypeOptions;

  public static final String SERIALIZED_NAME_CLIENT_CHARGE_CALCULATION_TYPE_OPTIONS = "clientChargeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_CHARGE_CALCULATION_TYPE_OPTIONS)
  private List<EnumOptionData> clientChargeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_CLIENT_CHARGE_TIME_TYPE_OPTIONS = "clientChargeTimeTypeOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_CHARGE_TIME_TYPE_OPTIONS)
  private List<EnumOptionData> clientChargeTimeTypeOptions;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_CURRENCY_OPTIONS = "currencyOptions";
  @SerializedName(SERIALIZED_NAME_CURRENCY_OPTIONS)
  private List<CurrencyData> currencyOptions;

  public static final String SERIALIZED_NAME_EXPENSE_ACCOUNT_OPTIONS = "expenseAccountOptions";
  @SerializedName(SERIALIZED_NAME_EXPENSE_ACCOUNT_OPTIONS)
  private List<GLAccountData> expenseAccountOptions;

  public static final String SERIALIZED_NAME_FEE_FREQUENCY = "feeFrequency";
  @SerializedName(SERIALIZED_NAME_FEE_FREQUENCY)
  private EnumOptionData feeFrequency;

  public static final String SERIALIZED_NAME_FEE_FREQUENCY_OPTIONS = "feeFrequencyOptions";
  @SerializedName(SERIALIZED_NAME_FEE_FREQUENCY_OPTIONS)
  private List<EnumOptionData> feeFrequencyOptions;

  public static final String SERIALIZED_NAME_FEE_INTERVAL = "feeInterval";
  @SerializedName(SERIALIZED_NAME_FEE_INTERVAL)
  private Integer feeInterval;

  public static final String SERIALIZED_NAME_FEE_ON_MONTH_DAY = "feeOnMonthDay";
  @SerializedName(SERIALIZED_NAME_FEE_ON_MONTH_DAY)
  private ChargeFeeOnMonthDay feeOnMonthDay;

  public static final String SERIALIZED_NAME_FREE_WITHDRAWAL = "freeWithdrawal";
  @SerializedName(SERIALIZED_NAME_FREE_WITHDRAWAL)
  private Boolean freeWithdrawal;

  public static final String SERIALIZED_NAME_FREE_WITHDRAWAL_CHARGE_FREQUENCY = "freeWithdrawalChargeFrequency";
  @SerializedName(SERIALIZED_NAME_FREE_WITHDRAWAL_CHARGE_FREQUENCY)
  private Integer freeWithdrawalChargeFrequency;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INCOME_OR_LIABILITY_ACCOUNT = "incomeOrLiabilityAccount";
  @SerializedName(SERIALIZED_NAME_INCOME_OR_LIABILITY_ACCOUNT)
  private GLAccountData incomeOrLiabilityAccount;

  public static final String SERIALIZED_NAME_INCOME_OR_LIABILITY_ACCOUNT_OPTIONS = "incomeOrLiabilityAccountOptions";
  @SerializedName(SERIALIZED_NAME_INCOME_OR_LIABILITY_ACCOUNT_OPTIONS)
  private Map<String, List<GLAccountData>> incomeOrLiabilityAccountOptions;

  public static final String SERIALIZED_NAME_IS_PAYMENT_TYPE = "isPaymentType";
  @SerializedName(SERIALIZED_NAME_IS_PAYMENT_TYPE)
  private Boolean isPaymentType;

  public static final String SERIALIZED_NAME_LOAN_CHARGE_CALCULATION_TYPE_OPTIONS = "loanChargeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOAN_CHARGE_CALCULATION_TYPE_OPTIONS)
  private List<EnumOptionData> loanChargeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_LOAN_CHARGE_TIME_TYPE_OPTIONS = "loanChargeTimeTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOAN_CHARGE_TIME_TYPE_OPTIONS)
  private List<EnumOptionData> loanChargeTimeTypeOptions;

  public static final String SERIALIZED_NAME_MAX_CAP = "maxCap";
  @SerializedName(SERIALIZED_NAME_MAX_CAP)
  private BigDecimal maxCap;

  public static final String SERIALIZED_NAME_MIN_CAP = "minCap";
  @SerializedName(SERIALIZED_NAME_MIN_CAP)
  private BigDecimal minCap;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_OVERDUE_INSTALLMENT_CHARGE = "overdueInstallmentCharge";
  @SerializedName(SERIALIZED_NAME_OVERDUE_INSTALLMENT_CHARGE)
  private Boolean overdueInstallmentCharge;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS = "paymentTypeOptions";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS)
  private PaymentTypeData paymentTypeOptions;

  public static final String SERIALIZED_NAME_PENALTY = "penalty";
  @SerializedName(SERIALIZED_NAME_PENALTY)
  private Boolean penalty;

  public static final String SERIALIZED_NAME_RESTART_FREQUENCY = "restartFrequency";
  @SerializedName(SERIALIZED_NAME_RESTART_FREQUENCY)
  private Integer restartFrequency;

  public static final String SERIALIZED_NAME_RESTART_FREQUENCY_ENUM = "restartFrequencyEnum";
  @SerializedName(SERIALIZED_NAME_RESTART_FREQUENCY_ENUM)
  private Integer restartFrequencyEnum;

  public static final String SERIALIZED_NAME_SAVINGS_CHARGE_CALCULATION_TYPE_OPTIONS = "savingsChargeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_SAVINGS_CHARGE_CALCULATION_TYPE_OPTIONS)
  private List<EnumOptionData> savingsChargeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_SAVINGS_CHARGE_TIME_TYPE_OPTIONS = "savingsChargeTimeTypeOptions";
  @SerializedName(SERIALIZED_NAME_SAVINGS_CHARGE_TIME_TYPE_OPTIONS)
  private List<EnumOptionData> savingsChargeTimeTypeOptions;

  public static final String SERIALIZED_NAME_SHARE_CHARGE_CALCULATION_TYPE_OPTIONS = "shareChargeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_SHARE_CHARGE_CALCULATION_TYPE_OPTIONS)
  private List<EnumOptionData> shareChargeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_SHARE_CHARGE_TIME_TYPE_OPTIONS = "shareChargeTimeTypeOptions";
  @SerializedName(SERIALIZED_NAME_SHARE_CHARGE_TIME_TYPE_OPTIONS)
  private List<EnumOptionData> shareChargeTimeTypeOptions;

  public static final String SERIALIZED_NAME_TAX_GROUP = "taxGroup";
  @SerializedName(SERIALIZED_NAME_TAX_GROUP)
  private TaxGroupData taxGroup;

  public static final String SERIALIZED_NAME_TAX_GROUP_OPTIONS = "taxGroupOptions";
  @SerializedName(SERIALIZED_NAME_TAX_GROUP_OPTIONS)
  private List<TaxGroupData> taxGroupOptions;

  public ChargeData() {
  }

  public ChargeData accountMappingForChargeConfig(String accountMappingForChargeConfig) {
    
    this.accountMappingForChargeConfig = accountMappingForChargeConfig;
    return this;
  }

  /**
   * Get accountMappingForChargeConfig
   * @return accountMappingForChargeConfig
   */
  @javax.annotation.Nullable

  public String getAccountMappingForChargeConfig() {
    return accountMappingForChargeConfig;
  }


  public void setAccountMappingForChargeConfig(String accountMappingForChargeConfig) {
    this.accountMappingForChargeConfig = accountMappingForChargeConfig;
  }

  public ChargeData active(Boolean active) {
    
    this.active = active;
    return this;
  }

  /**
   * Get active
   * @return active
   */
  @javax.annotation.Nullable

  public Boolean getActive() {
    return active;
  }


  public void setActive(Boolean active) {
    this.active = active;
  }

  public ChargeData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public ChargeData assetAccountOptions(List<GLAccountData> assetAccountOptions) {
    
    this.assetAccountOptions = assetAccountOptions;
    return this;
  }

  public ChargeData addAssetAccountOptionsItem(GLAccountData assetAccountOptionsItem) {
    if (this.assetAccountOptions == null) {
      this.assetAccountOptions = new ArrayList<>();
    }
    this.assetAccountOptions.add(assetAccountOptionsItem);
    return this;
  }

  /**
   * Get assetAccountOptions
   * @return assetAccountOptions
   */
  @javax.annotation.Nullable

  public List<GLAccountData> getAssetAccountOptions() {
    return assetAccountOptions;
  }


  public void setAssetAccountOptions(List<GLAccountData> assetAccountOptions) {
    this.assetAccountOptions = assetAccountOptions;
  }

  public ChargeData chargeAppliesTo(EnumOptionData chargeAppliesTo) {
    
    this.chargeAppliesTo = chargeAppliesTo;
    return this;
  }

  /**
   * Get chargeAppliesTo
   * @return chargeAppliesTo
   */
  @javax.annotation.Nullable

  public EnumOptionData getChargeAppliesTo() {
    return chargeAppliesTo;
  }


  public void setChargeAppliesTo(EnumOptionData chargeAppliesTo) {
    this.chargeAppliesTo = chargeAppliesTo;
  }

  public ChargeData chargeAppliesToOptions(List<EnumOptionData> chargeAppliesToOptions) {
    
    this.chargeAppliesToOptions = chargeAppliesToOptions;
    return this;
  }

  public ChargeData addChargeAppliesToOptionsItem(EnumOptionData chargeAppliesToOptionsItem) {
    if (this.chargeAppliesToOptions == null) {
      this.chargeAppliesToOptions = new ArrayList<>();
    }
    this.chargeAppliesToOptions.add(chargeAppliesToOptionsItem);
    return this;
  }

  /**
   * Get chargeAppliesToOptions
   * @return chargeAppliesToOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getChargeAppliesToOptions() {
    return chargeAppliesToOptions;
  }


  public void setChargeAppliesToOptions(List<EnumOptionData> chargeAppliesToOptions) {
    this.chargeAppliesToOptions = chargeAppliesToOptions;
  }

  public ChargeData chargeCalculationType(EnumOptionData chargeCalculationType) {
    
    this.chargeCalculationType = chargeCalculationType;
    return this;
  }

  /**
   * Get chargeCalculationType
   * @return chargeCalculationType
   */
  @javax.annotation.Nullable

  public EnumOptionData getChargeCalculationType() {
    return chargeCalculationType;
  }


  public void setChargeCalculationType(EnumOptionData chargeCalculationType) {
    this.chargeCalculationType = chargeCalculationType;
  }

  public ChargeData chargeCalculationTypeOptions(List<EnumOptionData> chargeCalculationTypeOptions) {
    
    this.chargeCalculationTypeOptions = chargeCalculationTypeOptions;
    return this;
  }

  public ChargeData addChargeCalculationTypeOptionsItem(EnumOptionData chargeCalculationTypeOptionsItem) {
    if (this.chargeCalculationTypeOptions == null) {
      this.chargeCalculationTypeOptions = new ArrayList<>();
    }
    this.chargeCalculationTypeOptions.add(chargeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get chargeCalculationTypeOptions
   * @return chargeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getChargeCalculationTypeOptions() {
    return chargeCalculationTypeOptions;
  }


  public void setChargeCalculationTypeOptions(List<EnumOptionData> chargeCalculationTypeOptions) {
    this.chargeCalculationTypeOptions = chargeCalculationTypeOptions;
  }

  public ChargeData chargePaymentMode(EnumOptionData chargePaymentMode) {
    
    this.chargePaymentMode = chargePaymentMode;
    return this;
  }

  /**
   * Get chargePaymentMode
   * @return chargePaymentMode
   */
  @javax.annotation.Nullable

  public EnumOptionData getChargePaymentMode() {
    return chargePaymentMode;
  }


  public void setChargePaymentMode(EnumOptionData chargePaymentMode) {
    this.chargePaymentMode = chargePaymentMode;
  }

  public ChargeData chargePaymetModeOptions(List<EnumOptionData> chargePaymetModeOptions) {
    
    this.chargePaymetModeOptions = chargePaymetModeOptions;
    return this;
  }

  public ChargeData addChargePaymetModeOptionsItem(EnumOptionData chargePaymetModeOptionsItem) {
    if (this.chargePaymetModeOptions == null) {
      this.chargePaymetModeOptions = new ArrayList<>();
    }
    this.chargePaymetModeOptions.add(chargePaymetModeOptionsItem);
    return this;
  }

  /**
   * Get chargePaymetModeOptions
   * @return chargePaymetModeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getChargePaymetModeOptions() {
    return chargePaymetModeOptions;
  }


  public void setChargePaymetModeOptions(List<EnumOptionData> chargePaymetModeOptions) {
    this.chargePaymetModeOptions = chargePaymetModeOptions;
  }

  public ChargeData chargeTimeType(EnumOptionData chargeTimeType) {
    
    this.chargeTimeType = chargeTimeType;
    return this;
  }

  /**
   * Get chargeTimeType
   * @return chargeTimeType
   */
  @javax.annotation.Nullable

  public EnumOptionData getChargeTimeType() {
    return chargeTimeType;
  }


  public void setChargeTimeType(EnumOptionData chargeTimeType) {
    this.chargeTimeType = chargeTimeType;
  }

  public ChargeData chargeTimeTypeOptions(List<EnumOptionData> chargeTimeTypeOptions) {
    
    this.chargeTimeTypeOptions = chargeTimeTypeOptions;
    return this;
  }

  public ChargeData addChargeTimeTypeOptionsItem(EnumOptionData chargeTimeTypeOptionsItem) {
    if (this.chargeTimeTypeOptions == null) {
      this.chargeTimeTypeOptions = new ArrayList<>();
    }
    this.chargeTimeTypeOptions.add(chargeTimeTypeOptionsItem);
    return this;
  }

  /**
   * Get chargeTimeTypeOptions
   * @return chargeTimeTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getChargeTimeTypeOptions() {
    return chargeTimeTypeOptions;
  }


  public void setChargeTimeTypeOptions(List<EnumOptionData> chargeTimeTypeOptions) {
    this.chargeTimeTypeOptions = chargeTimeTypeOptions;
  }

  public ChargeData clientChargeCalculationTypeOptions(List<EnumOptionData> clientChargeCalculationTypeOptions) {
    
    this.clientChargeCalculationTypeOptions = clientChargeCalculationTypeOptions;
    return this;
  }

  public ChargeData addClientChargeCalculationTypeOptionsItem(EnumOptionData clientChargeCalculationTypeOptionsItem) {
    if (this.clientChargeCalculationTypeOptions == null) {
      this.clientChargeCalculationTypeOptions = new ArrayList<>();
    }
    this.clientChargeCalculationTypeOptions.add(clientChargeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get clientChargeCalculationTypeOptions
   * @return clientChargeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getClientChargeCalculationTypeOptions() {
    return clientChargeCalculationTypeOptions;
  }


  public void setClientChargeCalculationTypeOptions(List<EnumOptionData> clientChargeCalculationTypeOptions) {
    this.clientChargeCalculationTypeOptions = clientChargeCalculationTypeOptions;
  }

  public ChargeData clientChargeTimeTypeOptions(List<EnumOptionData> clientChargeTimeTypeOptions) {
    
    this.clientChargeTimeTypeOptions = clientChargeTimeTypeOptions;
    return this;
  }

  public ChargeData addClientChargeTimeTypeOptionsItem(EnumOptionData clientChargeTimeTypeOptionsItem) {
    if (this.clientChargeTimeTypeOptions == null) {
      this.clientChargeTimeTypeOptions = new ArrayList<>();
    }
    this.clientChargeTimeTypeOptions.add(clientChargeTimeTypeOptionsItem);
    return this;
  }

  /**
   * Get clientChargeTimeTypeOptions
   * @return clientChargeTimeTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getClientChargeTimeTypeOptions() {
    return clientChargeTimeTypeOptions;
  }


  public void setClientChargeTimeTypeOptions(List<EnumOptionData> clientChargeTimeTypeOptions) {
    this.clientChargeTimeTypeOptions = clientChargeTimeTypeOptions;
  }

  public ChargeData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public ChargeData currencyOptions(List<CurrencyData> currencyOptions) {
    
    this.currencyOptions = currencyOptions;
    return this;
  }

  public ChargeData addCurrencyOptionsItem(CurrencyData currencyOptionsItem) {
    if (this.currencyOptions == null) {
      this.currencyOptions = new ArrayList<>();
    }
    this.currencyOptions.add(currencyOptionsItem);
    return this;
  }

  /**
   * Get currencyOptions
   * @return currencyOptions
   */
  @javax.annotation.Nullable

  public List<CurrencyData> getCurrencyOptions() {
    return currencyOptions;
  }


  public void setCurrencyOptions(List<CurrencyData> currencyOptions) {
    this.currencyOptions = currencyOptions;
  }

  public ChargeData expenseAccountOptions(List<GLAccountData> expenseAccountOptions) {
    
    this.expenseAccountOptions = expenseAccountOptions;
    return this;
  }

  public ChargeData addExpenseAccountOptionsItem(GLAccountData expenseAccountOptionsItem) {
    if (this.expenseAccountOptions == null) {
      this.expenseAccountOptions = new ArrayList<>();
    }
    this.expenseAccountOptions.add(expenseAccountOptionsItem);
    return this;
  }

  /**
   * Get expenseAccountOptions
   * @return expenseAccountOptions
   */
  @javax.annotation.Nullable

  public List<GLAccountData> getExpenseAccountOptions() {
    return expenseAccountOptions;
  }


  public void setExpenseAccountOptions(List<GLAccountData> expenseAccountOptions) {
    this.expenseAccountOptions = expenseAccountOptions;
  }

  public ChargeData feeFrequency(EnumOptionData feeFrequency) {
    
    this.feeFrequency = feeFrequency;
    return this;
  }

  /**
   * Get feeFrequency
   * @return feeFrequency
   */
  @javax.annotation.Nullable

  public EnumOptionData getFeeFrequency() {
    return feeFrequency;
  }


  public void setFeeFrequency(EnumOptionData feeFrequency) {
    this.feeFrequency = feeFrequency;
  }

  public ChargeData feeFrequencyOptions(List<EnumOptionData> feeFrequencyOptions) {
    
    this.feeFrequencyOptions = feeFrequencyOptions;
    return this;
  }

  public ChargeData addFeeFrequencyOptionsItem(EnumOptionData feeFrequencyOptionsItem) {
    if (this.feeFrequencyOptions == null) {
      this.feeFrequencyOptions = new ArrayList<>();
    }
    this.feeFrequencyOptions.add(feeFrequencyOptionsItem);
    return this;
  }

  /**
   * Get feeFrequencyOptions
   * @return feeFrequencyOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getFeeFrequencyOptions() {
    return feeFrequencyOptions;
  }


  public void setFeeFrequencyOptions(List<EnumOptionData> feeFrequencyOptions) {
    this.feeFrequencyOptions = feeFrequencyOptions;
  }

  public ChargeData feeInterval(Integer feeInterval) {
    
    this.feeInterval = feeInterval;
    return this;
  }

  /**
   * Get feeInterval
   * @return feeInterval
   */
  @javax.annotation.Nullable

  public Integer getFeeInterval() {
    return feeInterval;
  }


  public void setFeeInterval(Integer feeInterval) {
    this.feeInterval = feeInterval;
  }

  public ChargeData feeOnMonthDay(ChargeFeeOnMonthDay feeOnMonthDay) {
    
    this.feeOnMonthDay = feeOnMonthDay;
    return this;
  }

  /**
   * Get feeOnMonthDay
   * @return feeOnMonthDay
   */
  @javax.annotation.Nullable

  public ChargeFeeOnMonthDay getFeeOnMonthDay() {
    return feeOnMonthDay;
  }


  public void setFeeOnMonthDay(ChargeFeeOnMonthDay feeOnMonthDay) {
    this.feeOnMonthDay = feeOnMonthDay;
  }

  public ChargeData freeWithdrawal(Boolean freeWithdrawal) {
    
    this.freeWithdrawal = freeWithdrawal;
    return this;
  }

  /**
   * Get freeWithdrawal
   * @return freeWithdrawal
   */
  @javax.annotation.Nullable

  public Boolean getFreeWithdrawal() {
    return freeWithdrawal;
  }


  public void setFreeWithdrawal(Boolean freeWithdrawal) {
    this.freeWithdrawal = freeWithdrawal;
  }

  public ChargeData freeWithdrawalChargeFrequency(Integer freeWithdrawalChargeFrequency) {
    
    this.freeWithdrawalChargeFrequency = freeWithdrawalChargeFrequency;
    return this;
  }

  /**
   * Get freeWithdrawalChargeFrequency
   * @return freeWithdrawalChargeFrequency
   */
  @javax.annotation.Nullable

  public Integer getFreeWithdrawalChargeFrequency() {
    return freeWithdrawalChargeFrequency;
  }


  public void setFreeWithdrawalChargeFrequency(Integer freeWithdrawalChargeFrequency) {
    this.freeWithdrawalChargeFrequency = freeWithdrawalChargeFrequency;
  }

  public ChargeData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public ChargeData incomeOrLiabilityAccount(GLAccountData incomeOrLiabilityAccount) {
    
    this.incomeOrLiabilityAccount = incomeOrLiabilityAccount;
    return this;
  }

  /**
   * Get incomeOrLiabilityAccount
   * @return incomeOrLiabilityAccount
   */
  @javax.annotation.Nullable

  public GLAccountData getIncomeOrLiabilityAccount() {
    return incomeOrLiabilityAccount;
  }


  public void setIncomeOrLiabilityAccount(GLAccountData incomeOrLiabilityAccount) {
    this.incomeOrLiabilityAccount = incomeOrLiabilityAccount;
  }

  public ChargeData incomeOrLiabilityAccountOptions(Map<String, List<GLAccountData>> incomeOrLiabilityAccountOptions) {
    
    this.incomeOrLiabilityAccountOptions = incomeOrLiabilityAccountOptions;
    return this;
  }

  public ChargeData putIncomeOrLiabilityAccountOptionsItem(String key, List<GLAccountData> incomeOrLiabilityAccountOptionsItem) {
    if (this.incomeOrLiabilityAccountOptions == null) {
      this.incomeOrLiabilityAccountOptions = new HashMap<>();
    }
    this.incomeOrLiabilityAccountOptions.put(key, incomeOrLiabilityAccountOptionsItem);
    return this;
  }

  /**
   * Get incomeOrLiabilityAccountOptions
   * @return incomeOrLiabilityAccountOptions
   */
  @javax.annotation.Nullable

  public Map<String, List<GLAccountData>> getIncomeOrLiabilityAccountOptions() {
    return incomeOrLiabilityAccountOptions;
  }


  public void setIncomeOrLiabilityAccountOptions(Map<String, List<GLAccountData>> incomeOrLiabilityAccountOptions) {
    this.incomeOrLiabilityAccountOptions = incomeOrLiabilityAccountOptions;
  }

  public ChargeData isPaymentType(Boolean isPaymentType) {
    
    this.isPaymentType = isPaymentType;
    return this;
  }

  /**
   * Get isPaymentType
   * @return isPaymentType
   */
  @javax.annotation.Nullable

  public Boolean getIsPaymentType() {
    return isPaymentType;
  }


  public void setIsPaymentType(Boolean isPaymentType) {
    this.isPaymentType = isPaymentType;
  }

  public ChargeData loanChargeCalculationTypeOptions(List<EnumOptionData> loanChargeCalculationTypeOptions) {
    
    this.loanChargeCalculationTypeOptions = loanChargeCalculationTypeOptions;
    return this;
  }

  public ChargeData addLoanChargeCalculationTypeOptionsItem(EnumOptionData loanChargeCalculationTypeOptionsItem) {
    if (this.loanChargeCalculationTypeOptions == null) {
      this.loanChargeCalculationTypeOptions = new ArrayList<>();
    }
    this.loanChargeCalculationTypeOptions.add(loanChargeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get loanChargeCalculationTypeOptions
   * @return loanChargeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLoanChargeCalculationTypeOptions() {
    return loanChargeCalculationTypeOptions;
  }


  public void setLoanChargeCalculationTypeOptions(List<EnumOptionData> loanChargeCalculationTypeOptions) {
    this.loanChargeCalculationTypeOptions = loanChargeCalculationTypeOptions;
  }

  public ChargeData loanChargeTimeTypeOptions(List<EnumOptionData> loanChargeTimeTypeOptions) {
    
    this.loanChargeTimeTypeOptions = loanChargeTimeTypeOptions;
    return this;
  }

  public ChargeData addLoanChargeTimeTypeOptionsItem(EnumOptionData loanChargeTimeTypeOptionsItem) {
    if (this.loanChargeTimeTypeOptions == null) {
      this.loanChargeTimeTypeOptions = new ArrayList<>();
    }
    this.loanChargeTimeTypeOptions.add(loanChargeTimeTypeOptionsItem);
    return this;
  }

  /**
   * Get loanChargeTimeTypeOptions
   * @return loanChargeTimeTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLoanChargeTimeTypeOptions() {
    return loanChargeTimeTypeOptions;
  }


  public void setLoanChargeTimeTypeOptions(List<EnumOptionData> loanChargeTimeTypeOptions) {
    this.loanChargeTimeTypeOptions = loanChargeTimeTypeOptions;
  }

  public ChargeData maxCap(BigDecimal maxCap) {
    
    this.maxCap = maxCap;
    return this;
  }

  /**
   * Get maxCap
   * @return maxCap
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxCap() {
    return maxCap;
  }


  public void setMaxCap(BigDecimal maxCap) {
    this.maxCap = maxCap;
  }

  public ChargeData minCap(BigDecimal minCap) {
    
    this.minCap = minCap;
    return this;
  }

  /**
   * Get minCap
   * @return minCap
   */
  @javax.annotation.Nullable

  public BigDecimal getMinCap() {
    return minCap;
  }


  public void setMinCap(BigDecimal minCap) {
    this.minCap = minCap;
  }

  public ChargeData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public ChargeData overdueInstallmentCharge(Boolean overdueInstallmentCharge) {
    
    this.overdueInstallmentCharge = overdueInstallmentCharge;
    return this;
  }

  /**
   * Get overdueInstallmentCharge
   * @return overdueInstallmentCharge
   */
  @javax.annotation.Nullable

  public Boolean getOverdueInstallmentCharge() {
    return overdueInstallmentCharge;
  }


  public void setOverdueInstallmentCharge(Boolean overdueInstallmentCharge) {
    this.overdueInstallmentCharge = overdueInstallmentCharge;
  }

  public ChargeData paymentTypeOptions(PaymentTypeData paymentTypeOptions) {
    
    this.paymentTypeOptions = paymentTypeOptions;
    return this;
  }

  /**
   * Get paymentTypeOptions
   * @return paymentTypeOptions
   */
  @javax.annotation.Nullable

  public PaymentTypeData getPaymentTypeOptions() {
    return paymentTypeOptions;
  }


  public void setPaymentTypeOptions(PaymentTypeData paymentTypeOptions) {
    this.paymentTypeOptions = paymentTypeOptions;
  }

  public ChargeData penalty(Boolean penalty) {
    
    this.penalty = penalty;
    return this;
  }

  /**
   * Get penalty
   * @return penalty
   */
  @javax.annotation.Nullable

  public Boolean getPenalty() {
    return penalty;
  }


  public void setPenalty(Boolean penalty) {
    this.penalty = penalty;
  }

  public ChargeData restartFrequency(Integer restartFrequency) {
    
    this.restartFrequency = restartFrequency;
    return this;
  }

  /**
   * Get restartFrequency
   * @return restartFrequency
   */
  @javax.annotation.Nullable

  public Integer getRestartFrequency() {
    return restartFrequency;
  }


  public void setRestartFrequency(Integer restartFrequency) {
    this.restartFrequency = restartFrequency;
  }

  public ChargeData restartFrequencyEnum(Integer restartFrequencyEnum) {
    
    this.restartFrequencyEnum = restartFrequencyEnum;
    return this;
  }

  /**
   * Get restartFrequencyEnum
   * @return restartFrequencyEnum
   */
  @javax.annotation.Nullable

  public Integer getRestartFrequencyEnum() {
    return restartFrequencyEnum;
  }


  public void setRestartFrequencyEnum(Integer restartFrequencyEnum) {
    this.restartFrequencyEnum = restartFrequencyEnum;
  }

  public ChargeData savingsChargeCalculationTypeOptions(List<EnumOptionData> savingsChargeCalculationTypeOptions) {
    
    this.savingsChargeCalculationTypeOptions = savingsChargeCalculationTypeOptions;
    return this;
  }

  public ChargeData addSavingsChargeCalculationTypeOptionsItem(EnumOptionData savingsChargeCalculationTypeOptionsItem) {
    if (this.savingsChargeCalculationTypeOptions == null) {
      this.savingsChargeCalculationTypeOptions = new ArrayList<>();
    }
    this.savingsChargeCalculationTypeOptions.add(savingsChargeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get savingsChargeCalculationTypeOptions
   * @return savingsChargeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getSavingsChargeCalculationTypeOptions() {
    return savingsChargeCalculationTypeOptions;
  }


  public void setSavingsChargeCalculationTypeOptions(List<EnumOptionData> savingsChargeCalculationTypeOptions) {
    this.savingsChargeCalculationTypeOptions = savingsChargeCalculationTypeOptions;
  }

  public ChargeData savingsChargeTimeTypeOptions(List<EnumOptionData> savingsChargeTimeTypeOptions) {
    
    this.savingsChargeTimeTypeOptions = savingsChargeTimeTypeOptions;
    return this;
  }

  public ChargeData addSavingsChargeTimeTypeOptionsItem(EnumOptionData savingsChargeTimeTypeOptionsItem) {
    if (this.savingsChargeTimeTypeOptions == null) {
      this.savingsChargeTimeTypeOptions = new ArrayList<>();
    }
    this.savingsChargeTimeTypeOptions.add(savingsChargeTimeTypeOptionsItem);
    return this;
  }

  /**
   * Get savingsChargeTimeTypeOptions
   * @return savingsChargeTimeTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getSavingsChargeTimeTypeOptions() {
    return savingsChargeTimeTypeOptions;
  }


  public void setSavingsChargeTimeTypeOptions(List<EnumOptionData> savingsChargeTimeTypeOptions) {
    this.savingsChargeTimeTypeOptions = savingsChargeTimeTypeOptions;
  }

  public ChargeData shareChargeCalculationTypeOptions(List<EnumOptionData> shareChargeCalculationTypeOptions) {
    
    this.shareChargeCalculationTypeOptions = shareChargeCalculationTypeOptions;
    return this;
  }

  public ChargeData addShareChargeCalculationTypeOptionsItem(EnumOptionData shareChargeCalculationTypeOptionsItem) {
    if (this.shareChargeCalculationTypeOptions == null) {
      this.shareChargeCalculationTypeOptions = new ArrayList<>();
    }
    this.shareChargeCalculationTypeOptions.add(shareChargeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get shareChargeCalculationTypeOptions
   * @return shareChargeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getShareChargeCalculationTypeOptions() {
    return shareChargeCalculationTypeOptions;
  }


  public void setShareChargeCalculationTypeOptions(List<EnumOptionData> shareChargeCalculationTypeOptions) {
    this.shareChargeCalculationTypeOptions = shareChargeCalculationTypeOptions;
  }

  public ChargeData shareChargeTimeTypeOptions(List<EnumOptionData> shareChargeTimeTypeOptions) {
    
    this.shareChargeTimeTypeOptions = shareChargeTimeTypeOptions;
    return this;
  }

  public ChargeData addShareChargeTimeTypeOptionsItem(EnumOptionData shareChargeTimeTypeOptionsItem) {
    if (this.shareChargeTimeTypeOptions == null) {
      this.shareChargeTimeTypeOptions = new ArrayList<>();
    }
    this.shareChargeTimeTypeOptions.add(shareChargeTimeTypeOptionsItem);
    return this;
  }

  /**
   * Get shareChargeTimeTypeOptions
   * @return shareChargeTimeTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getShareChargeTimeTypeOptions() {
    return shareChargeTimeTypeOptions;
  }


  public void setShareChargeTimeTypeOptions(List<EnumOptionData> shareChargeTimeTypeOptions) {
    this.shareChargeTimeTypeOptions = shareChargeTimeTypeOptions;
  }

  public ChargeData taxGroup(TaxGroupData taxGroup) {
    
    this.taxGroup = taxGroup;
    return this;
  }

  /**
   * Get taxGroup
   * @return taxGroup
   */
  @javax.annotation.Nullable

  public TaxGroupData getTaxGroup() {
    return taxGroup;
  }


  public void setTaxGroup(TaxGroupData taxGroup) {
    this.taxGroup = taxGroup;
  }

  public ChargeData taxGroupOptions(List<TaxGroupData> taxGroupOptions) {
    
    this.taxGroupOptions = taxGroupOptions;
    return this;
  }

  public ChargeData addTaxGroupOptionsItem(TaxGroupData taxGroupOptionsItem) {
    if (this.taxGroupOptions == null) {
      this.taxGroupOptions = new ArrayList<>();
    }
    this.taxGroupOptions.add(taxGroupOptionsItem);
    return this;
  }

  /**
   * Get taxGroupOptions
   * @return taxGroupOptions
   */
  @javax.annotation.Nullable

  public List<TaxGroupData> getTaxGroupOptions() {
    return taxGroupOptions;
  }


  public void setTaxGroupOptions(List<TaxGroupData> taxGroupOptions) {
    this.taxGroupOptions = taxGroupOptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChargeData chargeData = (ChargeData) o;
    return Objects.equals(this.accountMappingForChargeConfig, chargeData.accountMappingForChargeConfig) &&
        Objects.equals(this.active, chargeData.active) &&
        Objects.equals(this.amount, chargeData.amount) &&
        Objects.equals(this.assetAccountOptions, chargeData.assetAccountOptions) &&
        Objects.equals(this.chargeAppliesTo, chargeData.chargeAppliesTo) &&
        Objects.equals(this.chargeAppliesToOptions, chargeData.chargeAppliesToOptions) &&
        Objects.equals(this.chargeCalculationType, chargeData.chargeCalculationType) &&
        Objects.equals(this.chargeCalculationTypeOptions, chargeData.chargeCalculationTypeOptions) &&
        Objects.equals(this.chargePaymentMode, chargeData.chargePaymentMode) &&
        Objects.equals(this.chargePaymetModeOptions, chargeData.chargePaymetModeOptions) &&
        Objects.equals(this.chargeTimeType, chargeData.chargeTimeType) &&
        Objects.equals(this.chargeTimeTypeOptions, chargeData.chargeTimeTypeOptions) &&
        Objects.equals(this.clientChargeCalculationTypeOptions, chargeData.clientChargeCalculationTypeOptions) &&
        Objects.equals(this.clientChargeTimeTypeOptions, chargeData.clientChargeTimeTypeOptions) &&
        Objects.equals(this.currency, chargeData.currency) &&
        Objects.equals(this.currencyOptions, chargeData.currencyOptions) &&
        Objects.equals(this.expenseAccountOptions, chargeData.expenseAccountOptions) &&
        Objects.equals(this.feeFrequency, chargeData.feeFrequency) &&
        Objects.equals(this.feeFrequencyOptions, chargeData.feeFrequencyOptions) &&
        Objects.equals(this.feeInterval, chargeData.feeInterval) &&
        Objects.equals(this.feeOnMonthDay, chargeData.feeOnMonthDay) &&
        Objects.equals(this.freeWithdrawal, chargeData.freeWithdrawal) &&
        Objects.equals(this.freeWithdrawalChargeFrequency, chargeData.freeWithdrawalChargeFrequency) &&
        Objects.equals(this.id, chargeData.id) &&
        Objects.equals(this.incomeOrLiabilityAccount, chargeData.incomeOrLiabilityAccount) &&
        Objects.equals(this.incomeOrLiabilityAccountOptions, chargeData.incomeOrLiabilityAccountOptions) &&
        Objects.equals(this.isPaymentType, chargeData.isPaymentType) &&
        Objects.equals(this.loanChargeCalculationTypeOptions, chargeData.loanChargeCalculationTypeOptions) &&
        Objects.equals(this.loanChargeTimeTypeOptions, chargeData.loanChargeTimeTypeOptions) &&
        Objects.equals(this.maxCap, chargeData.maxCap) &&
        Objects.equals(this.minCap, chargeData.minCap) &&
        Objects.equals(this.name, chargeData.name) &&
        Objects.equals(this.overdueInstallmentCharge, chargeData.overdueInstallmentCharge) &&
        Objects.equals(this.paymentTypeOptions, chargeData.paymentTypeOptions) &&
        Objects.equals(this.penalty, chargeData.penalty) &&
        Objects.equals(this.restartFrequency, chargeData.restartFrequency) &&
        Objects.equals(this.restartFrequencyEnum, chargeData.restartFrequencyEnum) &&
        Objects.equals(this.savingsChargeCalculationTypeOptions, chargeData.savingsChargeCalculationTypeOptions) &&
        Objects.equals(this.savingsChargeTimeTypeOptions, chargeData.savingsChargeTimeTypeOptions) &&
        Objects.equals(this.shareChargeCalculationTypeOptions, chargeData.shareChargeCalculationTypeOptions) &&
        Objects.equals(this.shareChargeTimeTypeOptions, chargeData.shareChargeTimeTypeOptions) &&
        Objects.equals(this.taxGroup, chargeData.taxGroup) &&
        Objects.equals(this.taxGroupOptions, chargeData.taxGroupOptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountMappingForChargeConfig, active, amount, assetAccountOptions, chargeAppliesTo, chargeAppliesToOptions, chargeCalculationType, chargeCalculationTypeOptions, chargePaymentMode, chargePaymetModeOptions, chargeTimeType, chargeTimeTypeOptions, clientChargeCalculationTypeOptions, clientChargeTimeTypeOptions, currency, currencyOptions, expenseAccountOptions, feeFrequency, feeFrequencyOptions, feeInterval, feeOnMonthDay, freeWithdrawal, freeWithdrawalChargeFrequency, id, incomeOrLiabilityAccount, incomeOrLiabilityAccountOptions, isPaymentType, loanChargeCalculationTypeOptions, loanChargeTimeTypeOptions, maxCap, minCap, name, overdueInstallmentCharge, paymentTypeOptions, penalty, restartFrequency, restartFrequencyEnum, savingsChargeCalculationTypeOptions, savingsChargeTimeTypeOptions, shareChargeCalculationTypeOptions, shareChargeTimeTypeOptions, taxGroup, taxGroupOptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChargeData {\n");
    sb.append("    accountMappingForChargeConfig: ").append(toIndentedString(accountMappingForChargeConfig)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    assetAccountOptions: ").append(toIndentedString(assetAccountOptions)).append("\n");
    sb.append("    chargeAppliesTo: ").append(toIndentedString(chargeAppliesTo)).append("\n");
    sb.append("    chargeAppliesToOptions: ").append(toIndentedString(chargeAppliesToOptions)).append("\n");
    sb.append("    chargeCalculationType: ").append(toIndentedString(chargeCalculationType)).append("\n");
    sb.append("    chargeCalculationTypeOptions: ").append(toIndentedString(chargeCalculationTypeOptions)).append("\n");
    sb.append("    chargePaymentMode: ").append(toIndentedString(chargePaymentMode)).append("\n");
    sb.append("    chargePaymetModeOptions: ").append(toIndentedString(chargePaymetModeOptions)).append("\n");
    sb.append("    chargeTimeType: ").append(toIndentedString(chargeTimeType)).append("\n");
    sb.append("    chargeTimeTypeOptions: ").append(toIndentedString(chargeTimeTypeOptions)).append("\n");
    sb.append("    clientChargeCalculationTypeOptions: ").append(toIndentedString(clientChargeCalculationTypeOptions)).append("\n");
    sb.append("    clientChargeTimeTypeOptions: ").append(toIndentedString(clientChargeTimeTypeOptions)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    currencyOptions: ").append(toIndentedString(currencyOptions)).append("\n");
    sb.append("    expenseAccountOptions: ").append(toIndentedString(expenseAccountOptions)).append("\n");
    sb.append("    feeFrequency: ").append(toIndentedString(feeFrequency)).append("\n");
    sb.append("    feeFrequencyOptions: ").append(toIndentedString(feeFrequencyOptions)).append("\n");
    sb.append("    feeInterval: ").append(toIndentedString(feeInterval)).append("\n");
    sb.append("    feeOnMonthDay: ").append(toIndentedString(feeOnMonthDay)).append("\n");
    sb.append("    freeWithdrawal: ").append(toIndentedString(freeWithdrawal)).append("\n");
    sb.append("    freeWithdrawalChargeFrequency: ").append(toIndentedString(freeWithdrawalChargeFrequency)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    incomeOrLiabilityAccount: ").append(toIndentedString(incomeOrLiabilityAccount)).append("\n");
    sb.append("    incomeOrLiabilityAccountOptions: ").append(toIndentedString(incomeOrLiabilityAccountOptions)).append("\n");
    sb.append("    isPaymentType: ").append(toIndentedString(isPaymentType)).append("\n");
    sb.append("    loanChargeCalculationTypeOptions: ").append(toIndentedString(loanChargeCalculationTypeOptions)).append("\n");
    sb.append("    loanChargeTimeTypeOptions: ").append(toIndentedString(loanChargeTimeTypeOptions)).append("\n");
    sb.append("    maxCap: ").append(toIndentedString(maxCap)).append("\n");
    sb.append("    minCap: ").append(toIndentedString(minCap)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    overdueInstallmentCharge: ").append(toIndentedString(overdueInstallmentCharge)).append("\n");
    sb.append("    paymentTypeOptions: ").append(toIndentedString(paymentTypeOptions)).append("\n");
    sb.append("    penalty: ").append(toIndentedString(penalty)).append("\n");
    sb.append("    restartFrequency: ").append(toIndentedString(restartFrequency)).append("\n");
    sb.append("    restartFrequencyEnum: ").append(toIndentedString(restartFrequencyEnum)).append("\n");
    sb.append("    savingsChargeCalculationTypeOptions: ").append(toIndentedString(savingsChargeCalculationTypeOptions)).append("\n");
    sb.append("    savingsChargeTimeTypeOptions: ").append(toIndentedString(savingsChargeTimeTypeOptions)).append("\n");
    sb.append("    shareChargeCalculationTypeOptions: ").append(toIndentedString(shareChargeCalculationTypeOptions)).append("\n");
    sb.append("    shareChargeTimeTypeOptions: ").append(toIndentedString(shareChargeTimeTypeOptions)).append("\n");
    sb.append("    taxGroup: ").append(toIndentedString(taxGroup)).append("\n");
    sb.append("    taxGroupOptions: ").append(toIndentedString(taxGroupOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

