/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * LoanTransactionRelationData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanTransactionRelationData {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_FROM_LOAN_TRANSACTION = "fromLoanTransaction";
  @SerializedName(SERIALIZED_NAME_FROM_LOAN_TRANSACTION)
  private Long fromLoanTransaction;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE = "paymentType";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE)
  private String paymentType;

  /**
   * Gets or Sets relationType
   */
  @JsonAdapter(RelationTypeEnum.Adapter.class)
  public enum RelationTypeEnum {
    INVALID("INVALID"),
    
    CHARGEBACK("CHARGEBACK"),
    
    CHARGE_ADJUSTMENT("CHARGE_ADJUSTMENT"),
    
    REPLAYED("REPLAYED"),
    
    RELATED("RELATED"),
    
    ADJUSTMENT("ADJUSTMENT");

    private String value;

    RelationTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RelationTypeEnum fromValue(String value) {
      for (RelationTypeEnum b : RelationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RelationTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RelationTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RelationTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RelationTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RELATION_TYPE = "relationType";
  @SerializedName(SERIALIZED_NAME_RELATION_TYPE)
  private RelationTypeEnum relationType;

  public static final String SERIALIZED_NAME_TO_LOAN_CHARGE = "toLoanCharge";
  @SerializedName(SERIALIZED_NAME_TO_LOAN_CHARGE)
  private Long toLoanCharge;

  public static final String SERIALIZED_NAME_TO_LOAN_TRANSACTION = "toLoanTransaction";
  @SerializedName(SERIALIZED_NAME_TO_LOAN_TRANSACTION)
  private Long toLoanTransaction;

  public LoanTransactionRelationData() {
  }

  public LoanTransactionRelationData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public LoanTransactionRelationData fromLoanTransaction(Long fromLoanTransaction) {
    
    this.fromLoanTransaction = fromLoanTransaction;
    return this;
  }

  /**
   * Get fromLoanTransaction
   * @return fromLoanTransaction
   */
  @javax.annotation.Nullable

  public Long getFromLoanTransaction() {
    return fromLoanTransaction;
  }


  public void setFromLoanTransaction(Long fromLoanTransaction) {
    this.fromLoanTransaction = fromLoanTransaction;
  }

  public LoanTransactionRelationData paymentType(String paymentType) {
    
    this.paymentType = paymentType;
    return this;
  }

  /**
   * Get paymentType
   * @return paymentType
   */
  @javax.annotation.Nullable

  public String getPaymentType() {
    return paymentType;
  }


  public void setPaymentType(String paymentType) {
    this.paymentType = paymentType;
  }

  public LoanTransactionRelationData relationType(RelationTypeEnum relationType) {
    
    this.relationType = relationType;
    return this;
  }

  /**
   * Get relationType
   * @return relationType
   */
  @javax.annotation.Nullable

  public RelationTypeEnum getRelationType() {
    return relationType;
  }


  public void setRelationType(RelationTypeEnum relationType) {
    this.relationType = relationType;
  }

  public LoanTransactionRelationData toLoanCharge(Long toLoanCharge) {
    
    this.toLoanCharge = toLoanCharge;
    return this;
  }

  /**
   * Get toLoanCharge
   * @return toLoanCharge
   */
  @javax.annotation.Nullable

  public Long getToLoanCharge() {
    return toLoanCharge;
  }


  public void setToLoanCharge(Long toLoanCharge) {
    this.toLoanCharge = toLoanCharge;
  }

  public LoanTransactionRelationData toLoanTransaction(Long toLoanTransaction) {
    
    this.toLoanTransaction = toLoanTransaction;
    return this;
  }

  /**
   * Get toLoanTransaction
   * @return toLoanTransaction
   */
  @javax.annotation.Nullable

  public Long getToLoanTransaction() {
    return toLoanTransaction;
  }


  public void setToLoanTransaction(Long toLoanTransaction) {
    this.toLoanTransaction = toLoanTransaction;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanTransactionRelationData loanTransactionRelationData = (LoanTransactionRelationData) o;
    return Objects.equals(this.amount, loanTransactionRelationData.amount) &&
        Objects.equals(this.fromLoanTransaction, loanTransactionRelationData.fromLoanTransaction) &&
        Objects.equals(this.paymentType, loanTransactionRelationData.paymentType) &&
        Objects.equals(this.relationType, loanTransactionRelationData.relationType) &&
        Objects.equals(this.toLoanCharge, loanTransactionRelationData.toLoanCharge) &&
        Objects.equals(this.toLoanTransaction, loanTransactionRelationData.toLoanTransaction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, fromLoanTransaction, paymentType, relationType, toLoanCharge, toLoanTransaction);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanTransactionRelationData {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    fromLoanTransaction: ").append(toIndentedString(fromLoanTransaction)).append("\n");
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("    relationType: ").append(toIndentedString(relationType)).append("\n");
    sb.append("    toLoanCharge: ").append(toIndentedString(toLoanCharge)).append("\n");
    sb.append("    toLoanTransaction: ").append(toIndentedString(toLoanTransaction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

