/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.ChargeData;
import org.apache.fineract.client.models.ClientData;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.DatatableData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GroupGeneralData;
import org.apache.fineract.client.models.SavingsAccountApplicationTimelineData;
import org.apache.fineract.client.models.SavingsAccountChargeData;
import org.apache.fineract.client.models.SavingsAccountStatusEnumData;
import org.apache.fineract.client.models.SavingsAccountSubStatusEnumData;
import org.apache.fineract.client.models.SavingsAccountSummaryData;
import org.apache.fineract.client.models.SavingsAccountTransactionData;
import org.apache.fineract.client.models.SavingsProductData;
import org.apache.fineract.client.models.StaffData;
import org.apache.fineract.client.models.TaxGroupData;

/**
 * SavingsAccountData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class SavingsAccountData {
  public static final String SERIALIZED_NAME_ACCOUNT_NO = "accountNo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_ACCRUAL_BASED_ACCOUNTING_ENABLED_ON_SAVINGS_PRODUCT = "accrualBasedAccountingEnabledOnSavingsProduct";
  @SerializedName(SERIALIZED_NAME_ACCRUAL_BASED_ACCOUNTING_ENABLED_ON_SAVINGS_PRODUCT)
  private Boolean accrualBasedAccountingEnabledOnSavingsProduct;

  public static final String SERIALIZED_NAME_ACTIVATED_ON_DATE = "activatedOnDate";
  @SerializedName(SERIALIZED_NAME_ACTIVATED_ON_DATE)
  private LocalDate activatedOnDate;

  public static final String SERIALIZED_NAME_ACTIVATION_LOCAL_DATE = "activationLocalDate";
  @SerializedName(SERIALIZED_NAME_ACTIVATION_LOCAL_DATE)
  private LocalDate activationLocalDate;

  public static final String SERIALIZED_NAME_ALLOW_OVERDRAFT = "allowOverdraft";
  @SerializedName(SERIALIZED_NAME_ALLOW_OVERDRAFT)
  private Boolean allowOverdraft;

  public static final String SERIALIZED_NAME_ANNUAL_FEE = "annualFee";
  @SerializedName(SERIALIZED_NAME_ANNUAL_FEE)
  private SavingsAccountChargeData annualFee;

  public static final String SERIALIZED_NAME_CASH_BASED_ACCOUNTING_ENABLED_ON_SAVINGS_PRODUCT = "cashBasedAccountingEnabledOnSavingsProduct";
  @SerializedName(SERIALIZED_NAME_CASH_BASED_ACCOUNTING_ENABLED_ON_SAVINGS_PRODUCT)
  private Boolean cashBasedAccountingEnabledOnSavingsProduct;

  public static final String SERIALIZED_NAME_CHARGE_OPTIONS = "chargeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OPTIONS)
  private List<ChargeData> chargeOptions;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<SavingsAccountChargeData> charges;

  public static final String SERIALIZED_NAME_CLIENT_DATA = "clientData";
  @SerializedName(SERIALIZED_NAME_CLIENT_DATA)
  private ClientData clientData;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_CLIENT_NAME = "clientName";
  @SerializedName(SERIALIZED_NAME_CLIENT_NAME)
  private String clientName;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_DATATABLES = "datatables";
  @SerializedName(SERIALIZED_NAME_DATATABLES)
  private List<DatatableData> datatables;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DAYS_TO_DORMANCY = "daysToDormancy";
  @SerializedName(SERIALIZED_NAME_DAYS_TO_DORMANCY)
  private Integer daysToDormancy;

  public static final String SERIALIZED_NAME_DAYS_TO_ESCHEAT = "daysToEscheat";
  @SerializedName(SERIALIZED_NAME_DAYS_TO_ESCHEAT)
  private Integer daysToEscheat;

  public static final String SERIALIZED_NAME_DAYS_TO_INACTIVE = "daysToInactive";
  @SerializedName(SERIALIZED_NAME_DAYS_TO_INACTIVE)
  private Integer daysToInactive;

  public static final String SERIALIZED_NAME_DEPOSIT_TYPE = "depositType";
  @SerializedName(SERIALIZED_NAME_DEPOSIT_TYPE)
  private EnumOptionData depositType;

  public static final String SERIALIZED_NAME_DEPOSIT_TYPE_ID = "depositTypeId";
  @SerializedName(SERIALIZED_NAME_DEPOSIT_TYPE_ID)
  private Integer depositTypeId;

  public static final String SERIALIZED_NAME_ENFORCE_MIN_REQUIRED_BALANCE = "enforceMinRequiredBalance";
  @SerializedName(SERIALIZED_NAME_ENFORCE_MIN_REQUIRED_BALANCE)
  private Boolean enforceMinRequiredBalance;

  public static final String SERIALIZED_NAME_EXISTING_REVERSED_TRANSACTION_IDS = "existingReversedTransactionIds";
  @SerializedName(SERIALIZED_NAME_EXISTING_REVERSED_TRANSACTION_IDS)
  private Set<Long> existingReversedTransactionIds;

  public static final String SERIALIZED_NAME_EXISTING_TRANSACTION_IDS = "existingTransactionIds";
  @SerializedName(SERIALIZED_NAME_EXISTING_TRANSACTION_IDS)
  private Set<Long> existingTransactionIds;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_FIELD_OFFICER_ID = "fieldOfficerId";
  @SerializedName(SERIALIZED_NAME_FIELD_OFFICER_ID)
  private Long fieldOfficerId;

  public static final String SERIALIZED_NAME_FIELD_OFFICER_NAME = "fieldOfficerName";
  @SerializedName(SERIALIZED_NAME_FIELD_OFFICER_NAME)
  private String fieldOfficerName;

  public static final String SERIALIZED_NAME_FIELD_OFFICER_OPTIONS = "fieldOfficerOptions";
  @SerializedName(SERIALIZED_NAME_FIELD_OFFICER_OPTIONS)
  private List<StaffData> fieldOfficerOptions;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_INTEREST_ON_SAVINGS = "glAccountIdForInterestOnSavings";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_INTEREST_ON_SAVINGS)
  private Long glAccountIdForInterestOnSavings;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_INTEREST_PAYABLE = "glAccountIdForInterestPayable";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_INTEREST_PAYABLE)
  private Long glAccountIdForInterestPayable;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_INTEREST_RECEIVABLE = "glAccountIdForInterestReceivable";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_INTEREST_RECEIVABLE)
  private Long glAccountIdForInterestReceivable;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_OVERDRAFT_PORFOLIO = "glAccountIdForOverdraftPorfolio";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_OVERDRAFT_PORFOLIO)
  private Long glAccountIdForOverdraftPorfolio;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_SAVINGS_CONTROL = "glAccountIdForSavingsControl";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_ID_FOR_SAVINGS_CONTROL)
  private Long glAccountIdForSavingsControl;

  public static final String SERIALIZED_NAME_GROUP_GENERAL_DATA = "groupGeneralData";
  @SerializedName(SERIALIZED_NAME_GROUP_GENERAL_DATA)
  private GroupGeneralData groupGeneralData;

  public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
  @SerializedName(SERIALIZED_NAME_GROUP_ID)
  private Long groupId;

  public static final String SERIALIZED_NAME_GROUP_NAME = "groupName";
  @SerializedName(SERIALIZED_NAME_GROUP_NAME)
  private String groupName;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_DAYS_IN_YEAR_TYPE = "interestCalculationDaysInYearType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_DAYS_IN_YEAR_TYPE)
  private EnumOptionData interestCalculationDaysInYearType;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_DAYS_IN_YEAR_TYPE_ID = "interestCalculationDaysInYearTypeId";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_DAYS_IN_YEAR_TYPE_ID)
  private Integer interestCalculationDaysInYearTypeId;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_DAYS_IN_YEAR_TYPE_OPTIONS = "interestCalculationDaysInYearTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_DAYS_IN_YEAR_TYPE_OPTIONS)
  private List<EnumOptionData> interestCalculationDaysInYearTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_TYPE = "interestCalculationType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_TYPE)
  private EnumOptionData interestCalculationType;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_TYPE_ID = "interestCalculationTypeId";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_TYPE_ID)
  private Integer interestCalculationTypeId;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_TYPE_OPTIONS = "interestCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_TYPE_OPTIONS)
  private List<EnumOptionData> interestCalculationTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_COMPOUNDING_PERIOD_TYPE = "interestCompoundingPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_COMPOUNDING_PERIOD_TYPE)
  private EnumOptionData interestCompoundingPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_COMPOUNDING_PERIOD_TYPE_ID = "interestCompoundingPeriodTypeId";
  @SerializedName(SERIALIZED_NAME_INTEREST_COMPOUNDING_PERIOD_TYPE_ID)
  private Integer interestCompoundingPeriodTypeId;

  public static final String SERIALIZED_NAME_INTEREST_COMPOUNDING_PERIOD_TYPE_OPTIONS = "interestCompoundingPeriodTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_COMPOUNDING_PERIOD_TYPE_OPTIONS)
  private List<EnumOptionData> interestCompoundingPeriodTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_POSTING = "interestPosting";
  @SerializedName(SERIALIZED_NAME_INTEREST_POSTING)
  private BigDecimal interestPosting;

  public static final String SERIALIZED_NAME_INTEREST_POSTING_PERIOD_TYPE = "interestPostingPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_POSTING_PERIOD_TYPE)
  private EnumOptionData interestPostingPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_POSTING_PERIOD_TYPE_ID = "interestPostingPeriodTypeId";
  @SerializedName(SERIALIZED_NAME_INTEREST_POSTING_PERIOD_TYPE_ID)
  private Integer interestPostingPeriodTypeId;

  public static final String SERIALIZED_NAME_INTEREST_POSTING_PERIOD_TYPE_OPTIONS = "interestPostingPeriodTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_POSTING_PERIOD_TYPE_OPTIONS)
  private List<EnumOptionData> interestPostingPeriodTypeOptions;

  public static final String SERIALIZED_NAME_IS_DORMANCY_TRACKING_ACTIVE = "isDormancyTrackingActive";
  @SerializedName(SERIALIZED_NAME_IS_DORMANCY_TRACKING_ACTIVE)
  private Boolean isDormancyTrackingActive;

  public static final String SERIALIZED_NAME_LAST_ACTIVE_TRANSACTION_DATE = "lastActiveTransactionDate";
  @SerializedName(SERIALIZED_NAME_LAST_ACTIVE_TRANSACTION_DATE)
  private LocalDate lastActiveTransactionDate;

  public static final String SERIALIZED_NAME_LAST_SAVINGS_ACCOUNT_TRANSACTION = "lastSavingsAccountTransaction";
  @SerializedName(SERIALIZED_NAME_LAST_SAVINGS_ACCOUNT_TRANSACTION)
  private SavingsAccountTransactionData lastSavingsAccountTransaction;

  public static final String SERIALIZED_NAME_LIEN_ALLOWED = "lienAllowed";
  @SerializedName(SERIALIZED_NAME_LIEN_ALLOWED)
  private Boolean lienAllowed;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_LOCKED_IN_UNTIL_DATE = "lockedInUntilDate";
  @SerializedName(SERIALIZED_NAME_LOCKED_IN_UNTIL_DATE)
  private LocalDate lockedInUntilDate;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY = "lockinPeriodFrequency";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY)
  private Integer lockinPeriodFrequency;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE = "lockinPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE)
  private EnumOptionData lockinPeriodFrequencyType;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE_ID = "lockinPeriodFrequencyTypeId";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE_ID)
  private Integer lockinPeriodFrequencyTypeId;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE_OPTIONS = "lockinPeriodFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE_OPTIONS)
  private List<EnumOptionData> lockinPeriodFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_MAX_ALLOWED_LIEN_LIMIT = "maxAllowedLienLimit";
  @SerializedName(SERIALIZED_NAME_MAX_ALLOWED_LIEN_LIMIT)
  private BigDecimal maxAllowedLienLimit;

  public static final String SERIALIZED_NAME_MIN_BALANCE_FOR_INTEREST_CALCULATION = "minBalanceForInterestCalculation";
  @SerializedName(SERIALIZED_NAME_MIN_BALANCE_FOR_INTEREST_CALCULATION)
  private BigDecimal minBalanceForInterestCalculation;

  public static final String SERIALIZED_NAME_MIN_OVERDRAFT_FOR_INTEREST_CALCULATION = "minOverdraftForInterestCalculation";
  @SerializedName(SERIALIZED_NAME_MIN_OVERDRAFT_FOR_INTEREST_CALCULATION)
  private BigDecimal minOverdraftForInterestCalculation;

  public static final String SERIALIZED_NAME_MIN_REQUIRED_BALANCE = "minRequiredBalance";
  @SerializedName(SERIALIZED_NAME_MIN_REQUIRED_BALANCE)
  private BigDecimal minRequiredBalance;

  public static final String SERIALIZED_NAME_MIN_REQUIRED_OPENING_BALANCE = "minRequiredOpeningBalance";
  @SerializedName(SERIALIZED_NAME_MIN_REQUIRED_OPENING_BALANCE)
  private BigDecimal minRequiredOpeningBalance;

  public static final String SERIALIZED_NAME_NEW_SAVINGS_ACCOUNT_TRANSACTION_DATA = "newSavingsAccountTransactionData";
  @SerializedName(SERIALIZED_NAME_NEW_SAVINGS_ACCOUNT_TRANSACTION_DATA)
  private List<SavingsAccountTransactionData> newSavingsAccountTransactionData;

  public static final String SERIALIZED_NAME_NOMINAL_ANNUAL_INTEREST_RATE = "nominalAnnualInterestRate";
  @SerializedName(SERIALIZED_NAME_NOMINAL_ANNUAL_INTEREST_RATE)
  private BigDecimal nominalAnnualInterestRate;

  public static final String SERIALIZED_NAME_NOMINAL_ANNUAL_INTEREST_RATE_OVERDRAFT = "nominalAnnualInterestRateOverdraft";
  @SerializedName(SERIALIZED_NAME_NOMINAL_ANNUAL_INTEREST_RATE_OVERDRAFT)
  private BigDecimal nominalAnnualInterestRateOverdraft;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_ON_HOLD_FUNDS = "onHoldFunds";
  @SerializedName(SERIALIZED_NAME_ON_HOLD_FUNDS)
  private BigDecimal onHoldFunds;

  public static final String SERIALIZED_NAME_OVERDRAFT_LIMIT = "overdraftLimit";
  @SerializedName(SERIALIZED_NAME_OVERDRAFT_LIMIT)
  private BigDecimal overdraftLimit;

  public static final String SERIALIZED_NAME_OVERDRAFT_POSTING = "overdraftPosting";
  @SerializedName(SERIALIZED_NAME_OVERDRAFT_POSTING)
  private BigDecimal overdraftPosting;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_PRODUCT_OPTIONS = "productOptions";
  @SerializedName(SERIALIZED_NAME_PRODUCT_OPTIONS)
  private List<SavingsProductData> productOptions;

  public static final String SERIALIZED_NAME_REASON_FOR_BLOCK = "reasonForBlock";
  @SerializedName(SERIALIZED_NAME_REASON_FOR_BLOCK)
  private String reasonForBlock;

  public static final String SERIALIZED_NAME_ROW_INDEX = "rowIndex";
  @SerializedName(SERIALIZED_NAME_ROW_INDEX)
  private Integer rowIndex;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_SUMMARY_DATA = "savingsAccountSummaryData";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_SUMMARY_DATA)
  private SavingsAccountSummaryData savingsAccountSummaryData;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_TRANSACTION_DATA = "savingsAccountTransactionData";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_TRANSACTION_DATA)
  private List<SavingsAccountTransactionData> savingsAccountTransactionData;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_TRANSACTION_SUMMARY_WRAPPER = "savingsAccountTransactionSummaryWrapper";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_TRANSACTION_SUMMARY_WRAPPER)
  private Object savingsAccountTransactionSummaryWrapper;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_TRANSACTIONS_WITH_PIVOT_CONFIG = "savingsAccountTransactionsWithPivotConfig";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_TRANSACTIONS_WITH_PIVOT_CONFIG)
  private List<SavingsAccountTransactionData> savingsAccountTransactionsWithPivotConfig;

  public static final String SERIALIZED_NAME_SAVINGS_AMOUNT_ON_HOLD = "savingsAmountOnHold";
  @SerializedName(SERIALIZED_NAME_SAVINGS_AMOUNT_ON_HOLD)
  private BigDecimal savingsAmountOnHold;

  public static final String SERIALIZED_NAME_SAVINGS_HELPER = "savingsHelper";
  @SerializedName(SERIALIZED_NAME_SAVINGS_HELPER)
  private Object savingsHelper;

  public static final String SERIALIZED_NAME_SAVINGS_PRODUCT = "savingsProduct";
  @SerializedName(SERIALIZED_NAME_SAVINGS_PRODUCT)
  private SavingsProductData savingsProduct;

  public static final String SERIALIZED_NAME_SAVINGS_PRODUCT_DATA = "savingsProductData";
  @SerializedName(SERIALIZED_NAME_SAVINGS_PRODUCT_DATA)
  private SavingsProductData savingsProductData;

  public static final String SERIALIZED_NAME_SAVINGS_PRODUCT_ID = "savingsProductId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_PRODUCT_ID)
  private Long savingsProductId;

  public static final String SERIALIZED_NAME_SAVINGS_PRODUCT_NAME = "savingsProductName";
  @SerializedName(SERIALIZED_NAME_SAVINGS_PRODUCT_NAME)
  private String savingsProductName;

  public static final String SERIALIZED_NAME_START_INTEREST_CALCULATION_DATE = "startInterestCalculationDate";
  @SerializedName(SERIALIZED_NAME_START_INTEREST_CALCULATION_DATE)
  private LocalDate startInterestCalculationDate;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private SavingsAccountStatusEnumData status;

  public static final String SERIALIZED_NAME_SUB_STATUS = "subStatus";
  @SerializedName(SERIALIZED_NAME_SUB_STATUS)
  private SavingsAccountSubStatusEnumData subStatus;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private LocalDate submittedOnDate;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private SavingsAccountSummaryData summary;

  public static final String SERIALIZED_NAME_TAX_GROUP = "taxGroup";
  @SerializedName(SERIALIZED_NAME_TAX_GROUP)
  private TaxGroupData taxGroup;

  public static final String SERIALIZED_NAME_TIMELINE = "timeline";
  @SerializedName(SERIALIZED_NAME_TIMELINE)
  private SavingsAccountApplicationTimelineData timeline;

  public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
  @SerializedName(SERIALIZED_NAME_TRANSACTIONS)
  private List<SavingsAccountTransactionData> transactions;

  public static final String SERIALIZED_NAME_UPDATED_TRANSACTIONS = "updatedTransactions";
  @SerializedName(SERIALIZED_NAME_UPDATED_TRANSACTIONS)
  private List<SavingsAccountTransactionData> updatedTransactions;

  public static final String SERIALIZED_NAME_WITH_HOLD_TAX = "withHoldTax";
  @SerializedName(SERIALIZED_NAME_WITH_HOLD_TAX)
  private Boolean withHoldTax;

  public static final String SERIALIZED_NAME_WITHDRAWAL_FEE = "withdrawalFee";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL_FEE)
  private SavingsAccountChargeData withdrawalFee;

  public static final String SERIALIZED_NAME_WITHDRAWAL_FEE_FOR_TRANSFERS = "withdrawalFeeForTransfers";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL_FEE_FOR_TRANSFERS)
  private Boolean withdrawalFeeForTransfers;

  public static final String SERIALIZED_NAME_WITHDRAWAL_FEE_TYPE_OPTIONS = "withdrawalFeeTypeOptions";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL_FEE_TYPE_OPTIONS)
  private List<EnumOptionData> withdrawalFeeTypeOptions;

  public SavingsAccountData() {
  }

  public SavingsAccountData accountNo(String accountNo) {
    
    this.accountNo = accountNo;
    return this;
  }

  /**
   * Get accountNo
   * @return accountNo
   */
  @javax.annotation.Nullable

  public String getAccountNo() {
    return accountNo;
  }


  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }

  public SavingsAccountData accrualBasedAccountingEnabledOnSavingsProduct(Boolean accrualBasedAccountingEnabledOnSavingsProduct) {
    
    this.accrualBasedAccountingEnabledOnSavingsProduct = accrualBasedAccountingEnabledOnSavingsProduct;
    return this;
  }

  /**
   * Get accrualBasedAccountingEnabledOnSavingsProduct
   * @return accrualBasedAccountingEnabledOnSavingsProduct
   */
  @javax.annotation.Nullable

  public Boolean getAccrualBasedAccountingEnabledOnSavingsProduct() {
    return accrualBasedAccountingEnabledOnSavingsProduct;
  }


  public void setAccrualBasedAccountingEnabledOnSavingsProduct(Boolean accrualBasedAccountingEnabledOnSavingsProduct) {
    this.accrualBasedAccountingEnabledOnSavingsProduct = accrualBasedAccountingEnabledOnSavingsProduct;
  }

  public SavingsAccountData activatedOnDate(LocalDate activatedOnDate) {
    
    this.activatedOnDate = activatedOnDate;
    return this;
  }

  /**
   * Get activatedOnDate
   * @return activatedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getActivatedOnDate() {
    return activatedOnDate;
  }


  public void setActivatedOnDate(LocalDate activatedOnDate) {
    this.activatedOnDate = activatedOnDate;
  }

  public SavingsAccountData activationLocalDate(LocalDate activationLocalDate) {
    
    this.activationLocalDate = activationLocalDate;
    return this;
  }

  /**
   * Get activationLocalDate
   * @return activationLocalDate
   */
  @javax.annotation.Nullable

  public LocalDate getActivationLocalDate() {
    return activationLocalDate;
  }


  public void setActivationLocalDate(LocalDate activationLocalDate) {
    this.activationLocalDate = activationLocalDate;
  }

  public SavingsAccountData allowOverdraft(Boolean allowOverdraft) {
    
    this.allowOverdraft = allowOverdraft;
    return this;
  }

  /**
   * Get allowOverdraft
   * @return allowOverdraft
   */
  @javax.annotation.Nullable

  public Boolean getAllowOverdraft() {
    return allowOverdraft;
  }


  public void setAllowOverdraft(Boolean allowOverdraft) {
    this.allowOverdraft = allowOverdraft;
  }

  public SavingsAccountData annualFee(SavingsAccountChargeData annualFee) {
    
    this.annualFee = annualFee;
    return this;
  }

  /**
   * Get annualFee
   * @return annualFee
   */
  @javax.annotation.Nullable

  public SavingsAccountChargeData getAnnualFee() {
    return annualFee;
  }


  public void setAnnualFee(SavingsAccountChargeData annualFee) {
    this.annualFee = annualFee;
  }

  public SavingsAccountData cashBasedAccountingEnabledOnSavingsProduct(Boolean cashBasedAccountingEnabledOnSavingsProduct) {
    
    this.cashBasedAccountingEnabledOnSavingsProduct = cashBasedAccountingEnabledOnSavingsProduct;
    return this;
  }

  /**
   * Get cashBasedAccountingEnabledOnSavingsProduct
   * @return cashBasedAccountingEnabledOnSavingsProduct
   */
  @javax.annotation.Nullable

  public Boolean getCashBasedAccountingEnabledOnSavingsProduct() {
    return cashBasedAccountingEnabledOnSavingsProduct;
  }


  public void setCashBasedAccountingEnabledOnSavingsProduct(Boolean cashBasedAccountingEnabledOnSavingsProduct) {
    this.cashBasedAccountingEnabledOnSavingsProduct = cashBasedAccountingEnabledOnSavingsProduct;
  }

  public SavingsAccountData chargeOptions(List<ChargeData> chargeOptions) {
    
    this.chargeOptions = chargeOptions;
    return this;
  }

  public SavingsAccountData addChargeOptionsItem(ChargeData chargeOptionsItem) {
    if (this.chargeOptions == null) {
      this.chargeOptions = new ArrayList<>();
    }
    this.chargeOptions.add(chargeOptionsItem);
    return this;
  }

  /**
   * Get chargeOptions
   * @return chargeOptions
   */
  @javax.annotation.Nullable

  public List<ChargeData> getChargeOptions() {
    return chargeOptions;
  }


  public void setChargeOptions(List<ChargeData> chargeOptions) {
    this.chargeOptions = chargeOptions;
  }

  public SavingsAccountData charges(List<SavingsAccountChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public SavingsAccountData addChargesItem(SavingsAccountChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<SavingsAccountChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<SavingsAccountChargeData> charges) {
    this.charges = charges;
  }

  public SavingsAccountData clientData(ClientData clientData) {
    
    this.clientData = clientData;
    return this;
  }

  /**
   * Get clientData
   * @return clientData
   */
  @javax.annotation.Nullable

  public ClientData getClientData() {
    return clientData;
  }


  public void setClientData(ClientData clientData) {
    this.clientData = clientData;
  }

  public SavingsAccountData clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public SavingsAccountData clientName(String clientName) {
    
    this.clientName = clientName;
    return this;
  }

  /**
   * Get clientName
   * @return clientName
   */
  @javax.annotation.Nullable

  public String getClientName() {
    return clientName;
  }


  public void setClientName(String clientName) {
    this.clientName = clientName;
  }

  public SavingsAccountData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public SavingsAccountData datatables(List<DatatableData> datatables) {
    
    this.datatables = datatables;
    return this;
  }

  public SavingsAccountData addDatatablesItem(DatatableData datatablesItem) {
    if (this.datatables == null) {
      this.datatables = new ArrayList<>();
    }
    this.datatables.add(datatablesItem);
    return this;
  }

  /**
   * Get datatables
   * @return datatables
   */
  @javax.annotation.Nullable

  public List<DatatableData> getDatatables() {
    return datatables;
  }


  public void setDatatables(List<DatatableData> datatables) {
    this.datatables = datatables;
  }

  public SavingsAccountData dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public SavingsAccountData daysToDormancy(Integer daysToDormancy) {
    
    this.daysToDormancy = daysToDormancy;
    return this;
  }

  /**
   * Get daysToDormancy
   * @return daysToDormancy
   */
  @javax.annotation.Nullable

  public Integer getDaysToDormancy() {
    return daysToDormancy;
  }


  public void setDaysToDormancy(Integer daysToDormancy) {
    this.daysToDormancy = daysToDormancy;
  }

  public SavingsAccountData daysToEscheat(Integer daysToEscheat) {
    
    this.daysToEscheat = daysToEscheat;
    return this;
  }

  /**
   * Get daysToEscheat
   * @return daysToEscheat
   */
  @javax.annotation.Nullable

  public Integer getDaysToEscheat() {
    return daysToEscheat;
  }


  public void setDaysToEscheat(Integer daysToEscheat) {
    this.daysToEscheat = daysToEscheat;
  }

  public SavingsAccountData daysToInactive(Integer daysToInactive) {
    
    this.daysToInactive = daysToInactive;
    return this;
  }

  /**
   * Get daysToInactive
   * @return daysToInactive
   */
  @javax.annotation.Nullable

  public Integer getDaysToInactive() {
    return daysToInactive;
  }


  public void setDaysToInactive(Integer daysToInactive) {
    this.daysToInactive = daysToInactive;
  }

  public SavingsAccountData depositType(EnumOptionData depositType) {
    
    this.depositType = depositType;
    return this;
  }

  /**
   * Get depositType
   * @return depositType
   */
  @javax.annotation.Nullable

  public EnumOptionData getDepositType() {
    return depositType;
  }


  public void setDepositType(EnumOptionData depositType) {
    this.depositType = depositType;
  }

  public SavingsAccountData depositTypeId(Integer depositTypeId) {
    
    this.depositTypeId = depositTypeId;
    return this;
  }

  /**
   * Get depositTypeId
   * @return depositTypeId
   */
  @javax.annotation.Nullable

  public Integer getDepositTypeId() {
    return depositTypeId;
  }


  public void setDepositTypeId(Integer depositTypeId) {
    this.depositTypeId = depositTypeId;
  }

  public SavingsAccountData enforceMinRequiredBalance(Boolean enforceMinRequiredBalance) {
    
    this.enforceMinRequiredBalance = enforceMinRequiredBalance;
    return this;
  }

  /**
   * Get enforceMinRequiredBalance
   * @return enforceMinRequiredBalance
   */
  @javax.annotation.Nullable

  public Boolean getEnforceMinRequiredBalance() {
    return enforceMinRequiredBalance;
  }


  public void setEnforceMinRequiredBalance(Boolean enforceMinRequiredBalance) {
    this.enforceMinRequiredBalance = enforceMinRequiredBalance;
  }

  public SavingsAccountData existingReversedTransactionIds(Set<Long> existingReversedTransactionIds) {
    
    this.existingReversedTransactionIds = existingReversedTransactionIds;
    return this;
  }

  public SavingsAccountData addExistingReversedTransactionIdsItem(Long existingReversedTransactionIdsItem) {
    if (this.existingReversedTransactionIds == null) {
      this.existingReversedTransactionIds = new LinkedHashSet<>();
    }
    this.existingReversedTransactionIds.add(existingReversedTransactionIdsItem);
    return this;
  }

  /**
   * Get existingReversedTransactionIds
   * @return existingReversedTransactionIds
   */
  @javax.annotation.Nullable

  public Set<Long> getExistingReversedTransactionIds() {
    return existingReversedTransactionIds;
  }


  public void setExistingReversedTransactionIds(Set<Long> existingReversedTransactionIds) {
    this.existingReversedTransactionIds = existingReversedTransactionIds;
  }

  public SavingsAccountData existingTransactionIds(Set<Long> existingTransactionIds) {
    
    this.existingTransactionIds = existingTransactionIds;
    return this;
  }

  public SavingsAccountData addExistingTransactionIdsItem(Long existingTransactionIdsItem) {
    if (this.existingTransactionIds == null) {
      this.existingTransactionIds = new LinkedHashSet<>();
    }
    this.existingTransactionIds.add(existingTransactionIdsItem);
    return this;
  }

  /**
   * Get existingTransactionIds
   * @return existingTransactionIds
   */
  @javax.annotation.Nullable

  public Set<Long> getExistingTransactionIds() {
    return existingTransactionIds;
  }


  public void setExistingTransactionIds(Set<Long> existingTransactionIds) {
    this.existingTransactionIds = existingTransactionIds;
  }

  public SavingsAccountData externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public SavingsAccountData fieldOfficerId(Long fieldOfficerId) {
    
    this.fieldOfficerId = fieldOfficerId;
    return this;
  }

  /**
   * Get fieldOfficerId
   * @return fieldOfficerId
   */
  @javax.annotation.Nullable

  public Long getFieldOfficerId() {
    return fieldOfficerId;
  }


  public void setFieldOfficerId(Long fieldOfficerId) {
    this.fieldOfficerId = fieldOfficerId;
  }

  public SavingsAccountData fieldOfficerName(String fieldOfficerName) {
    
    this.fieldOfficerName = fieldOfficerName;
    return this;
  }

  /**
   * Get fieldOfficerName
   * @return fieldOfficerName
   */
  @javax.annotation.Nullable

  public String getFieldOfficerName() {
    return fieldOfficerName;
  }


  public void setFieldOfficerName(String fieldOfficerName) {
    this.fieldOfficerName = fieldOfficerName;
  }

  public SavingsAccountData fieldOfficerOptions(List<StaffData> fieldOfficerOptions) {
    
    this.fieldOfficerOptions = fieldOfficerOptions;
    return this;
  }

  public SavingsAccountData addFieldOfficerOptionsItem(StaffData fieldOfficerOptionsItem) {
    if (this.fieldOfficerOptions == null) {
      this.fieldOfficerOptions = new ArrayList<>();
    }
    this.fieldOfficerOptions.add(fieldOfficerOptionsItem);
    return this;
  }

  /**
   * Get fieldOfficerOptions
   * @return fieldOfficerOptions
   */
  @javax.annotation.Nullable

  public List<StaffData> getFieldOfficerOptions() {
    return fieldOfficerOptions;
  }


  public void setFieldOfficerOptions(List<StaffData> fieldOfficerOptions) {
    this.fieldOfficerOptions = fieldOfficerOptions;
  }

  public SavingsAccountData glAccountIdForInterestOnSavings(Long glAccountIdForInterestOnSavings) {
    
    this.glAccountIdForInterestOnSavings = glAccountIdForInterestOnSavings;
    return this;
  }

  /**
   * Get glAccountIdForInterestOnSavings
   * @return glAccountIdForInterestOnSavings
   */
  @javax.annotation.Nullable

  public Long getGlAccountIdForInterestOnSavings() {
    return glAccountIdForInterestOnSavings;
  }


  public void setGlAccountIdForInterestOnSavings(Long glAccountIdForInterestOnSavings) {
    this.glAccountIdForInterestOnSavings = glAccountIdForInterestOnSavings;
  }

  public SavingsAccountData glAccountIdForInterestPayable(Long glAccountIdForInterestPayable) {
    
    this.glAccountIdForInterestPayable = glAccountIdForInterestPayable;
    return this;
  }

  /**
   * Get glAccountIdForInterestPayable
   * @return glAccountIdForInterestPayable
   */
  @javax.annotation.Nullable

  public Long getGlAccountIdForInterestPayable() {
    return glAccountIdForInterestPayable;
  }


  public void setGlAccountIdForInterestPayable(Long glAccountIdForInterestPayable) {
    this.glAccountIdForInterestPayable = glAccountIdForInterestPayable;
  }

  public SavingsAccountData glAccountIdForInterestReceivable(Long glAccountIdForInterestReceivable) {
    
    this.glAccountIdForInterestReceivable = glAccountIdForInterestReceivable;
    return this;
  }

  /**
   * Get glAccountIdForInterestReceivable
   * @return glAccountIdForInterestReceivable
   */
  @javax.annotation.Nullable

  public Long getGlAccountIdForInterestReceivable() {
    return glAccountIdForInterestReceivable;
  }


  public void setGlAccountIdForInterestReceivable(Long glAccountIdForInterestReceivable) {
    this.glAccountIdForInterestReceivable = glAccountIdForInterestReceivable;
  }

  public SavingsAccountData glAccountIdForOverdraftPorfolio(Long glAccountIdForOverdraftPorfolio) {
    
    this.glAccountIdForOverdraftPorfolio = glAccountIdForOverdraftPorfolio;
    return this;
  }

  /**
   * Get glAccountIdForOverdraftPorfolio
   * @return glAccountIdForOverdraftPorfolio
   */
  @javax.annotation.Nullable

  public Long getGlAccountIdForOverdraftPorfolio() {
    return glAccountIdForOverdraftPorfolio;
  }


  public void setGlAccountIdForOverdraftPorfolio(Long glAccountIdForOverdraftPorfolio) {
    this.glAccountIdForOverdraftPorfolio = glAccountIdForOverdraftPorfolio;
  }

  public SavingsAccountData glAccountIdForSavingsControl(Long glAccountIdForSavingsControl) {
    
    this.glAccountIdForSavingsControl = glAccountIdForSavingsControl;
    return this;
  }

  /**
   * Get glAccountIdForSavingsControl
   * @return glAccountIdForSavingsControl
   */
  @javax.annotation.Nullable

  public Long getGlAccountIdForSavingsControl() {
    return glAccountIdForSavingsControl;
  }


  public void setGlAccountIdForSavingsControl(Long glAccountIdForSavingsControl) {
    this.glAccountIdForSavingsControl = glAccountIdForSavingsControl;
  }

  public SavingsAccountData groupGeneralData(GroupGeneralData groupGeneralData) {
    
    this.groupGeneralData = groupGeneralData;
    return this;
  }

  /**
   * Get groupGeneralData
   * @return groupGeneralData
   */
  @javax.annotation.Nullable

  public GroupGeneralData getGroupGeneralData() {
    return groupGeneralData;
  }


  public void setGroupGeneralData(GroupGeneralData groupGeneralData) {
    this.groupGeneralData = groupGeneralData;
  }

  public SavingsAccountData groupId(Long groupId) {
    
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
   */
  @javax.annotation.Nullable

  public Long getGroupId() {
    return groupId;
  }


  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  public SavingsAccountData groupName(String groupName) {
    
    this.groupName = groupName;
    return this;
  }

  /**
   * Get groupName
   * @return groupName
   */
  @javax.annotation.Nullable

  public String getGroupName() {
    return groupName;
  }


  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  public SavingsAccountData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public SavingsAccountData interestCalculationDaysInYearType(EnumOptionData interestCalculationDaysInYearType) {
    
    this.interestCalculationDaysInYearType = interestCalculationDaysInYearType;
    return this;
  }

  /**
   * Get interestCalculationDaysInYearType
   * @return interestCalculationDaysInYearType
   */
  @javax.annotation.Nullable

  public EnumOptionData getInterestCalculationDaysInYearType() {
    return interestCalculationDaysInYearType;
  }


  public void setInterestCalculationDaysInYearType(EnumOptionData interestCalculationDaysInYearType) {
    this.interestCalculationDaysInYearType = interestCalculationDaysInYearType;
  }

  public SavingsAccountData interestCalculationDaysInYearTypeId(Integer interestCalculationDaysInYearTypeId) {
    
    this.interestCalculationDaysInYearTypeId = interestCalculationDaysInYearTypeId;
    return this;
  }

  /**
   * Get interestCalculationDaysInYearTypeId
   * @return interestCalculationDaysInYearTypeId
   */
  @javax.annotation.Nullable

  public Integer getInterestCalculationDaysInYearTypeId() {
    return interestCalculationDaysInYearTypeId;
  }


  public void setInterestCalculationDaysInYearTypeId(Integer interestCalculationDaysInYearTypeId) {
    this.interestCalculationDaysInYearTypeId = interestCalculationDaysInYearTypeId;
  }

  public SavingsAccountData interestCalculationDaysInYearTypeOptions(List<EnumOptionData> interestCalculationDaysInYearTypeOptions) {
    
    this.interestCalculationDaysInYearTypeOptions = interestCalculationDaysInYearTypeOptions;
    return this;
  }

  public SavingsAccountData addInterestCalculationDaysInYearTypeOptionsItem(EnumOptionData interestCalculationDaysInYearTypeOptionsItem) {
    if (this.interestCalculationDaysInYearTypeOptions == null) {
      this.interestCalculationDaysInYearTypeOptions = new ArrayList<>();
    }
    this.interestCalculationDaysInYearTypeOptions.add(interestCalculationDaysInYearTypeOptionsItem);
    return this;
  }

  /**
   * Get interestCalculationDaysInYearTypeOptions
   * @return interestCalculationDaysInYearTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestCalculationDaysInYearTypeOptions() {
    return interestCalculationDaysInYearTypeOptions;
  }


  public void setInterestCalculationDaysInYearTypeOptions(List<EnumOptionData> interestCalculationDaysInYearTypeOptions) {
    this.interestCalculationDaysInYearTypeOptions = interestCalculationDaysInYearTypeOptions;
  }

  public SavingsAccountData interestCalculationType(EnumOptionData interestCalculationType) {
    
    this.interestCalculationType = interestCalculationType;
    return this;
  }

  /**
   * Get interestCalculationType
   * @return interestCalculationType
   */
  @javax.annotation.Nullable

  public EnumOptionData getInterestCalculationType() {
    return interestCalculationType;
  }


  public void setInterestCalculationType(EnumOptionData interestCalculationType) {
    this.interestCalculationType = interestCalculationType;
  }

  public SavingsAccountData interestCalculationTypeId(Integer interestCalculationTypeId) {
    
    this.interestCalculationTypeId = interestCalculationTypeId;
    return this;
  }

  /**
   * Get interestCalculationTypeId
   * @return interestCalculationTypeId
   */
  @javax.annotation.Nullable

  public Integer getInterestCalculationTypeId() {
    return interestCalculationTypeId;
  }


  public void setInterestCalculationTypeId(Integer interestCalculationTypeId) {
    this.interestCalculationTypeId = interestCalculationTypeId;
  }

  public SavingsAccountData interestCalculationTypeOptions(List<EnumOptionData> interestCalculationTypeOptions) {
    
    this.interestCalculationTypeOptions = interestCalculationTypeOptions;
    return this;
  }

  public SavingsAccountData addInterestCalculationTypeOptionsItem(EnumOptionData interestCalculationTypeOptionsItem) {
    if (this.interestCalculationTypeOptions == null) {
      this.interestCalculationTypeOptions = new ArrayList<>();
    }
    this.interestCalculationTypeOptions.add(interestCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get interestCalculationTypeOptions
   * @return interestCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestCalculationTypeOptions() {
    return interestCalculationTypeOptions;
  }


  public void setInterestCalculationTypeOptions(List<EnumOptionData> interestCalculationTypeOptions) {
    this.interestCalculationTypeOptions = interestCalculationTypeOptions;
  }

  public SavingsAccountData interestCompoundingPeriodType(EnumOptionData interestCompoundingPeriodType) {
    
    this.interestCompoundingPeriodType = interestCompoundingPeriodType;
    return this;
  }

  /**
   * Get interestCompoundingPeriodType
   * @return interestCompoundingPeriodType
   */
  @javax.annotation.Nullable

  public EnumOptionData getInterestCompoundingPeriodType() {
    return interestCompoundingPeriodType;
  }


  public void setInterestCompoundingPeriodType(EnumOptionData interestCompoundingPeriodType) {
    this.interestCompoundingPeriodType = interestCompoundingPeriodType;
  }

  public SavingsAccountData interestCompoundingPeriodTypeId(Integer interestCompoundingPeriodTypeId) {
    
    this.interestCompoundingPeriodTypeId = interestCompoundingPeriodTypeId;
    return this;
  }

  /**
   * Get interestCompoundingPeriodTypeId
   * @return interestCompoundingPeriodTypeId
   */
  @javax.annotation.Nullable

  public Integer getInterestCompoundingPeriodTypeId() {
    return interestCompoundingPeriodTypeId;
  }


  public void setInterestCompoundingPeriodTypeId(Integer interestCompoundingPeriodTypeId) {
    this.interestCompoundingPeriodTypeId = interestCompoundingPeriodTypeId;
  }

  public SavingsAccountData interestCompoundingPeriodTypeOptions(List<EnumOptionData> interestCompoundingPeriodTypeOptions) {
    
    this.interestCompoundingPeriodTypeOptions = interestCompoundingPeriodTypeOptions;
    return this;
  }

  public SavingsAccountData addInterestCompoundingPeriodTypeOptionsItem(EnumOptionData interestCompoundingPeriodTypeOptionsItem) {
    if (this.interestCompoundingPeriodTypeOptions == null) {
      this.interestCompoundingPeriodTypeOptions = new ArrayList<>();
    }
    this.interestCompoundingPeriodTypeOptions.add(interestCompoundingPeriodTypeOptionsItem);
    return this;
  }

  /**
   * Get interestCompoundingPeriodTypeOptions
   * @return interestCompoundingPeriodTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestCompoundingPeriodTypeOptions() {
    return interestCompoundingPeriodTypeOptions;
  }


  public void setInterestCompoundingPeriodTypeOptions(List<EnumOptionData> interestCompoundingPeriodTypeOptions) {
    this.interestCompoundingPeriodTypeOptions = interestCompoundingPeriodTypeOptions;
  }

  public SavingsAccountData interestPosting(BigDecimal interestPosting) {
    
    this.interestPosting = interestPosting;
    return this;
  }

  /**
   * Get interestPosting
   * @return interestPosting
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestPosting() {
    return interestPosting;
  }


  public void setInterestPosting(BigDecimal interestPosting) {
    this.interestPosting = interestPosting;
  }

  public SavingsAccountData interestPostingPeriodType(EnumOptionData interestPostingPeriodType) {
    
    this.interestPostingPeriodType = interestPostingPeriodType;
    return this;
  }

  /**
   * Get interestPostingPeriodType
   * @return interestPostingPeriodType
   */
  @javax.annotation.Nullable

  public EnumOptionData getInterestPostingPeriodType() {
    return interestPostingPeriodType;
  }


  public void setInterestPostingPeriodType(EnumOptionData interestPostingPeriodType) {
    this.interestPostingPeriodType = interestPostingPeriodType;
  }

  public SavingsAccountData interestPostingPeriodTypeId(Integer interestPostingPeriodTypeId) {
    
    this.interestPostingPeriodTypeId = interestPostingPeriodTypeId;
    return this;
  }

  /**
   * Get interestPostingPeriodTypeId
   * @return interestPostingPeriodTypeId
   */
  @javax.annotation.Nullable

  public Integer getInterestPostingPeriodTypeId() {
    return interestPostingPeriodTypeId;
  }


  public void setInterestPostingPeriodTypeId(Integer interestPostingPeriodTypeId) {
    this.interestPostingPeriodTypeId = interestPostingPeriodTypeId;
  }

  public SavingsAccountData interestPostingPeriodTypeOptions(List<EnumOptionData> interestPostingPeriodTypeOptions) {
    
    this.interestPostingPeriodTypeOptions = interestPostingPeriodTypeOptions;
    return this;
  }

  public SavingsAccountData addInterestPostingPeriodTypeOptionsItem(EnumOptionData interestPostingPeriodTypeOptionsItem) {
    if (this.interestPostingPeriodTypeOptions == null) {
      this.interestPostingPeriodTypeOptions = new ArrayList<>();
    }
    this.interestPostingPeriodTypeOptions.add(interestPostingPeriodTypeOptionsItem);
    return this;
  }

  /**
   * Get interestPostingPeriodTypeOptions
   * @return interestPostingPeriodTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestPostingPeriodTypeOptions() {
    return interestPostingPeriodTypeOptions;
  }


  public void setInterestPostingPeriodTypeOptions(List<EnumOptionData> interestPostingPeriodTypeOptions) {
    this.interestPostingPeriodTypeOptions = interestPostingPeriodTypeOptions;
  }

  public SavingsAccountData isDormancyTrackingActive(Boolean isDormancyTrackingActive) {
    
    this.isDormancyTrackingActive = isDormancyTrackingActive;
    return this;
  }

  /**
   * Get isDormancyTrackingActive
   * @return isDormancyTrackingActive
   */
  @javax.annotation.Nullable

  public Boolean getIsDormancyTrackingActive() {
    return isDormancyTrackingActive;
  }


  public void setIsDormancyTrackingActive(Boolean isDormancyTrackingActive) {
    this.isDormancyTrackingActive = isDormancyTrackingActive;
  }

  public SavingsAccountData lastActiveTransactionDate(LocalDate lastActiveTransactionDate) {
    
    this.lastActiveTransactionDate = lastActiveTransactionDate;
    return this;
  }

  /**
   * Get lastActiveTransactionDate
   * @return lastActiveTransactionDate
   */
  @javax.annotation.Nullable

  public LocalDate getLastActiveTransactionDate() {
    return lastActiveTransactionDate;
  }


  public void setLastActiveTransactionDate(LocalDate lastActiveTransactionDate) {
    this.lastActiveTransactionDate = lastActiveTransactionDate;
  }

  public SavingsAccountData lastSavingsAccountTransaction(SavingsAccountTransactionData lastSavingsAccountTransaction) {
    
    this.lastSavingsAccountTransaction = lastSavingsAccountTransaction;
    return this;
  }

  /**
   * Get lastSavingsAccountTransaction
   * @return lastSavingsAccountTransaction
   */
  @javax.annotation.Nullable

  public SavingsAccountTransactionData getLastSavingsAccountTransaction() {
    return lastSavingsAccountTransaction;
  }


  public void setLastSavingsAccountTransaction(SavingsAccountTransactionData lastSavingsAccountTransaction) {
    this.lastSavingsAccountTransaction = lastSavingsAccountTransaction;
  }

  public SavingsAccountData lienAllowed(Boolean lienAllowed) {
    
    this.lienAllowed = lienAllowed;
    return this;
  }

  /**
   * Get lienAllowed
   * @return lienAllowed
   */
  @javax.annotation.Nullable

  public Boolean getLienAllowed() {
    return lienAllowed;
  }


  public void setLienAllowed(Boolean lienAllowed) {
    this.lienAllowed = lienAllowed;
  }

  public SavingsAccountData locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public SavingsAccountData lockedInUntilDate(LocalDate lockedInUntilDate) {
    
    this.lockedInUntilDate = lockedInUntilDate;
    return this;
  }

  /**
   * Get lockedInUntilDate
   * @return lockedInUntilDate
   */
  @javax.annotation.Nullable

  public LocalDate getLockedInUntilDate() {
    return lockedInUntilDate;
  }


  public void setLockedInUntilDate(LocalDate lockedInUntilDate) {
    this.lockedInUntilDate = lockedInUntilDate;
  }

  public SavingsAccountData lockinPeriodFrequency(Integer lockinPeriodFrequency) {
    
    this.lockinPeriodFrequency = lockinPeriodFrequency;
    return this;
  }

  /**
   * Get lockinPeriodFrequency
   * @return lockinPeriodFrequency
   */
  @javax.annotation.Nullable

  public Integer getLockinPeriodFrequency() {
    return lockinPeriodFrequency;
  }


  public void setLockinPeriodFrequency(Integer lockinPeriodFrequency) {
    this.lockinPeriodFrequency = lockinPeriodFrequency;
  }

  public SavingsAccountData lockinPeriodFrequencyType(EnumOptionData lockinPeriodFrequencyType) {
    
    this.lockinPeriodFrequencyType = lockinPeriodFrequencyType;
    return this;
  }

  /**
   * Get lockinPeriodFrequencyType
   * @return lockinPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public EnumOptionData getLockinPeriodFrequencyType() {
    return lockinPeriodFrequencyType;
  }


  public void setLockinPeriodFrequencyType(EnumOptionData lockinPeriodFrequencyType) {
    this.lockinPeriodFrequencyType = lockinPeriodFrequencyType;
  }

  public SavingsAccountData lockinPeriodFrequencyTypeId(Integer lockinPeriodFrequencyTypeId) {
    
    this.lockinPeriodFrequencyTypeId = lockinPeriodFrequencyTypeId;
    return this;
  }

  /**
   * Get lockinPeriodFrequencyTypeId
   * @return lockinPeriodFrequencyTypeId
   */
  @javax.annotation.Nullable

  public Integer getLockinPeriodFrequencyTypeId() {
    return lockinPeriodFrequencyTypeId;
  }


  public void setLockinPeriodFrequencyTypeId(Integer lockinPeriodFrequencyTypeId) {
    this.lockinPeriodFrequencyTypeId = lockinPeriodFrequencyTypeId;
  }

  public SavingsAccountData lockinPeriodFrequencyTypeOptions(List<EnumOptionData> lockinPeriodFrequencyTypeOptions) {
    
    this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
    return this;
  }

  public SavingsAccountData addLockinPeriodFrequencyTypeOptionsItem(EnumOptionData lockinPeriodFrequencyTypeOptionsItem) {
    if (this.lockinPeriodFrequencyTypeOptions == null) {
      this.lockinPeriodFrequencyTypeOptions = new ArrayList<>();
    }
    this.lockinPeriodFrequencyTypeOptions.add(lockinPeriodFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get lockinPeriodFrequencyTypeOptions
   * @return lockinPeriodFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLockinPeriodFrequencyTypeOptions() {
    return lockinPeriodFrequencyTypeOptions;
  }


  public void setLockinPeriodFrequencyTypeOptions(List<EnumOptionData> lockinPeriodFrequencyTypeOptions) {
    this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
  }

  public SavingsAccountData maxAllowedLienLimit(BigDecimal maxAllowedLienLimit) {
    
    this.maxAllowedLienLimit = maxAllowedLienLimit;
    return this;
  }

  /**
   * Get maxAllowedLienLimit
   * @return maxAllowedLienLimit
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxAllowedLienLimit() {
    return maxAllowedLienLimit;
  }


  public void setMaxAllowedLienLimit(BigDecimal maxAllowedLienLimit) {
    this.maxAllowedLienLimit = maxAllowedLienLimit;
  }

  public SavingsAccountData minBalanceForInterestCalculation(BigDecimal minBalanceForInterestCalculation) {
    
    this.minBalanceForInterestCalculation = minBalanceForInterestCalculation;
    return this;
  }

  /**
   * Get minBalanceForInterestCalculation
   * @return minBalanceForInterestCalculation
   */
  @javax.annotation.Nullable

  public BigDecimal getMinBalanceForInterestCalculation() {
    return minBalanceForInterestCalculation;
  }


  public void setMinBalanceForInterestCalculation(BigDecimal minBalanceForInterestCalculation) {
    this.minBalanceForInterestCalculation = minBalanceForInterestCalculation;
  }

  public SavingsAccountData minOverdraftForInterestCalculation(BigDecimal minOverdraftForInterestCalculation) {
    
    this.minOverdraftForInterestCalculation = minOverdraftForInterestCalculation;
    return this;
  }

  /**
   * Get minOverdraftForInterestCalculation
   * @return minOverdraftForInterestCalculation
   */
  @javax.annotation.Nullable

  public BigDecimal getMinOverdraftForInterestCalculation() {
    return minOverdraftForInterestCalculation;
  }


  public void setMinOverdraftForInterestCalculation(BigDecimal minOverdraftForInterestCalculation) {
    this.minOverdraftForInterestCalculation = minOverdraftForInterestCalculation;
  }

  public SavingsAccountData minRequiredBalance(BigDecimal minRequiredBalance) {
    
    this.minRequiredBalance = minRequiredBalance;
    return this;
  }

  /**
   * Get minRequiredBalance
   * @return minRequiredBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getMinRequiredBalance() {
    return minRequiredBalance;
  }


  public void setMinRequiredBalance(BigDecimal minRequiredBalance) {
    this.minRequiredBalance = minRequiredBalance;
  }

  public SavingsAccountData minRequiredOpeningBalance(BigDecimal minRequiredOpeningBalance) {
    
    this.minRequiredOpeningBalance = minRequiredOpeningBalance;
    return this;
  }

  /**
   * Get minRequiredOpeningBalance
   * @return minRequiredOpeningBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getMinRequiredOpeningBalance() {
    return minRequiredOpeningBalance;
  }


  public void setMinRequiredOpeningBalance(BigDecimal minRequiredOpeningBalance) {
    this.minRequiredOpeningBalance = minRequiredOpeningBalance;
  }

  public SavingsAccountData newSavingsAccountTransactionData(List<SavingsAccountTransactionData> newSavingsAccountTransactionData) {
    
    this.newSavingsAccountTransactionData = newSavingsAccountTransactionData;
    return this;
  }

  public SavingsAccountData addNewSavingsAccountTransactionDataItem(SavingsAccountTransactionData newSavingsAccountTransactionDataItem) {
    if (this.newSavingsAccountTransactionData == null) {
      this.newSavingsAccountTransactionData = new ArrayList<>();
    }
    this.newSavingsAccountTransactionData.add(newSavingsAccountTransactionDataItem);
    return this;
  }

  /**
   * Get newSavingsAccountTransactionData
   * @return newSavingsAccountTransactionData
   */
  @javax.annotation.Nullable

  public List<SavingsAccountTransactionData> getNewSavingsAccountTransactionData() {
    return newSavingsAccountTransactionData;
  }


  public void setNewSavingsAccountTransactionData(List<SavingsAccountTransactionData> newSavingsAccountTransactionData) {
    this.newSavingsAccountTransactionData = newSavingsAccountTransactionData;
  }

  public SavingsAccountData nominalAnnualInterestRate(BigDecimal nominalAnnualInterestRate) {
    
    this.nominalAnnualInterestRate = nominalAnnualInterestRate;
    return this;
  }

  /**
   * Get nominalAnnualInterestRate
   * @return nominalAnnualInterestRate
   */
  @javax.annotation.Nullable

  public BigDecimal getNominalAnnualInterestRate() {
    return nominalAnnualInterestRate;
  }


  public void setNominalAnnualInterestRate(BigDecimal nominalAnnualInterestRate) {
    this.nominalAnnualInterestRate = nominalAnnualInterestRate;
  }

  public SavingsAccountData nominalAnnualInterestRateOverdraft(BigDecimal nominalAnnualInterestRateOverdraft) {
    
    this.nominalAnnualInterestRateOverdraft = nominalAnnualInterestRateOverdraft;
    return this;
  }

  /**
   * Get nominalAnnualInterestRateOverdraft
   * @return nominalAnnualInterestRateOverdraft
   */
  @javax.annotation.Nullable

  public BigDecimal getNominalAnnualInterestRateOverdraft() {
    return nominalAnnualInterestRateOverdraft;
  }


  public void setNominalAnnualInterestRateOverdraft(BigDecimal nominalAnnualInterestRateOverdraft) {
    this.nominalAnnualInterestRateOverdraft = nominalAnnualInterestRateOverdraft;
  }

  public SavingsAccountData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public SavingsAccountData onHoldFunds(BigDecimal onHoldFunds) {
    
    this.onHoldFunds = onHoldFunds;
    return this;
  }

  /**
   * Get onHoldFunds
   * @return onHoldFunds
   */
  @javax.annotation.Nullable

  public BigDecimal getOnHoldFunds() {
    return onHoldFunds;
  }


  public void setOnHoldFunds(BigDecimal onHoldFunds) {
    this.onHoldFunds = onHoldFunds;
  }

  public SavingsAccountData overdraftLimit(BigDecimal overdraftLimit) {
    
    this.overdraftLimit = overdraftLimit;
    return this;
  }

  /**
   * Get overdraftLimit
   * @return overdraftLimit
   */
  @javax.annotation.Nullable

  public BigDecimal getOverdraftLimit() {
    return overdraftLimit;
  }


  public void setOverdraftLimit(BigDecimal overdraftLimit) {
    this.overdraftLimit = overdraftLimit;
  }

  public SavingsAccountData overdraftPosting(BigDecimal overdraftPosting) {
    
    this.overdraftPosting = overdraftPosting;
    return this;
  }

  /**
   * Get overdraftPosting
   * @return overdraftPosting
   */
  @javax.annotation.Nullable

  public BigDecimal getOverdraftPosting() {
    return overdraftPosting;
  }


  public void setOverdraftPosting(BigDecimal overdraftPosting) {
    this.overdraftPosting = overdraftPosting;
  }

  public SavingsAccountData productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public SavingsAccountData productOptions(List<SavingsProductData> productOptions) {
    
    this.productOptions = productOptions;
    return this;
  }

  public SavingsAccountData addProductOptionsItem(SavingsProductData productOptionsItem) {
    if (this.productOptions == null) {
      this.productOptions = new ArrayList<>();
    }
    this.productOptions.add(productOptionsItem);
    return this;
  }

  /**
   * Get productOptions
   * @return productOptions
   */
  @javax.annotation.Nullable

  public List<SavingsProductData> getProductOptions() {
    return productOptions;
  }


  public void setProductOptions(List<SavingsProductData> productOptions) {
    this.productOptions = productOptions;
  }

  public SavingsAccountData reasonForBlock(String reasonForBlock) {
    
    this.reasonForBlock = reasonForBlock;
    return this;
  }

  /**
   * Get reasonForBlock
   * @return reasonForBlock
   */
  @javax.annotation.Nullable

  public String getReasonForBlock() {
    return reasonForBlock;
  }


  public void setReasonForBlock(String reasonForBlock) {
    this.reasonForBlock = reasonForBlock;
  }

  public SavingsAccountData rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

  /**
   * Get rowIndex
   * @return rowIndex
   */
  @javax.annotation.Nullable

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }

  public SavingsAccountData savingsAccountSummaryData(SavingsAccountSummaryData savingsAccountSummaryData) {
    
    this.savingsAccountSummaryData = savingsAccountSummaryData;
    return this;
  }

  /**
   * Get savingsAccountSummaryData
   * @return savingsAccountSummaryData
   */
  @javax.annotation.Nullable

  public SavingsAccountSummaryData getSavingsAccountSummaryData() {
    return savingsAccountSummaryData;
  }


  public void setSavingsAccountSummaryData(SavingsAccountSummaryData savingsAccountSummaryData) {
    this.savingsAccountSummaryData = savingsAccountSummaryData;
  }

  public SavingsAccountData savingsAccountTransactionData(List<SavingsAccountTransactionData> savingsAccountTransactionData) {
    
    this.savingsAccountTransactionData = savingsAccountTransactionData;
    return this;
  }

  public SavingsAccountData addSavingsAccountTransactionDataItem(SavingsAccountTransactionData savingsAccountTransactionDataItem) {
    if (this.savingsAccountTransactionData == null) {
      this.savingsAccountTransactionData = new ArrayList<>();
    }
    this.savingsAccountTransactionData.add(savingsAccountTransactionDataItem);
    return this;
  }

  /**
   * Get savingsAccountTransactionData
   * @return savingsAccountTransactionData
   */
  @javax.annotation.Nullable

  public List<SavingsAccountTransactionData> getSavingsAccountTransactionData() {
    return savingsAccountTransactionData;
  }


  public void setSavingsAccountTransactionData(List<SavingsAccountTransactionData> savingsAccountTransactionData) {
    this.savingsAccountTransactionData = savingsAccountTransactionData;
  }

  public SavingsAccountData savingsAccountTransactionSummaryWrapper(Object savingsAccountTransactionSummaryWrapper) {
    
    this.savingsAccountTransactionSummaryWrapper = savingsAccountTransactionSummaryWrapper;
    return this;
  }

  /**
   * Get savingsAccountTransactionSummaryWrapper
   * @return savingsAccountTransactionSummaryWrapper
   */
  @javax.annotation.Nullable

  public Object getSavingsAccountTransactionSummaryWrapper() {
    return savingsAccountTransactionSummaryWrapper;
  }


  public void setSavingsAccountTransactionSummaryWrapper(Object savingsAccountTransactionSummaryWrapper) {
    this.savingsAccountTransactionSummaryWrapper = savingsAccountTransactionSummaryWrapper;
  }

  public SavingsAccountData savingsAccountTransactionsWithPivotConfig(List<SavingsAccountTransactionData> savingsAccountTransactionsWithPivotConfig) {
    
    this.savingsAccountTransactionsWithPivotConfig = savingsAccountTransactionsWithPivotConfig;
    return this;
  }

  public SavingsAccountData addSavingsAccountTransactionsWithPivotConfigItem(SavingsAccountTransactionData savingsAccountTransactionsWithPivotConfigItem) {
    if (this.savingsAccountTransactionsWithPivotConfig == null) {
      this.savingsAccountTransactionsWithPivotConfig = new ArrayList<>();
    }
    this.savingsAccountTransactionsWithPivotConfig.add(savingsAccountTransactionsWithPivotConfigItem);
    return this;
  }

  /**
   * Get savingsAccountTransactionsWithPivotConfig
   * @return savingsAccountTransactionsWithPivotConfig
   */
  @javax.annotation.Nullable

  public List<SavingsAccountTransactionData> getSavingsAccountTransactionsWithPivotConfig() {
    return savingsAccountTransactionsWithPivotConfig;
  }


  public void setSavingsAccountTransactionsWithPivotConfig(List<SavingsAccountTransactionData> savingsAccountTransactionsWithPivotConfig) {
    this.savingsAccountTransactionsWithPivotConfig = savingsAccountTransactionsWithPivotConfig;
  }

  public SavingsAccountData savingsAmountOnHold(BigDecimal savingsAmountOnHold) {
    
    this.savingsAmountOnHold = savingsAmountOnHold;
    return this;
  }

  /**
   * Get savingsAmountOnHold
   * @return savingsAmountOnHold
   */
  @javax.annotation.Nullable

  public BigDecimal getSavingsAmountOnHold() {
    return savingsAmountOnHold;
  }


  public void setSavingsAmountOnHold(BigDecimal savingsAmountOnHold) {
    this.savingsAmountOnHold = savingsAmountOnHold;
  }

  public SavingsAccountData savingsHelper(Object savingsHelper) {
    
    this.savingsHelper = savingsHelper;
    return this;
  }

  /**
   * Get savingsHelper
   * @return savingsHelper
   */
  @javax.annotation.Nullable

  public Object getSavingsHelper() {
    return savingsHelper;
  }


  public void setSavingsHelper(Object savingsHelper) {
    this.savingsHelper = savingsHelper;
  }

  public SavingsAccountData savingsProduct(SavingsProductData savingsProduct) {
    
    this.savingsProduct = savingsProduct;
    return this;
  }

  /**
   * Get savingsProduct
   * @return savingsProduct
   */
  @javax.annotation.Nullable

  public SavingsProductData getSavingsProduct() {
    return savingsProduct;
  }


  public void setSavingsProduct(SavingsProductData savingsProduct) {
    this.savingsProduct = savingsProduct;
  }

  public SavingsAccountData savingsProductData(SavingsProductData savingsProductData) {
    
    this.savingsProductData = savingsProductData;
    return this;
  }

  /**
   * Get savingsProductData
   * @return savingsProductData
   */
  @javax.annotation.Nullable

  public SavingsProductData getSavingsProductData() {
    return savingsProductData;
  }


  public void setSavingsProductData(SavingsProductData savingsProductData) {
    this.savingsProductData = savingsProductData;
  }

  public SavingsAccountData savingsProductId(Long savingsProductId) {
    
    this.savingsProductId = savingsProductId;
    return this;
  }

  /**
   * Get savingsProductId
   * @return savingsProductId
   */
  @javax.annotation.Nullable

  public Long getSavingsProductId() {
    return savingsProductId;
  }


  public void setSavingsProductId(Long savingsProductId) {
    this.savingsProductId = savingsProductId;
  }

  public SavingsAccountData savingsProductName(String savingsProductName) {
    
    this.savingsProductName = savingsProductName;
    return this;
  }

  /**
   * Get savingsProductName
   * @return savingsProductName
   */
  @javax.annotation.Nullable

  public String getSavingsProductName() {
    return savingsProductName;
  }


  public void setSavingsProductName(String savingsProductName) {
    this.savingsProductName = savingsProductName;
  }

  public SavingsAccountData startInterestCalculationDate(LocalDate startInterestCalculationDate) {
    
    this.startInterestCalculationDate = startInterestCalculationDate;
    return this;
  }

  /**
   * Get startInterestCalculationDate
   * @return startInterestCalculationDate
   */
  @javax.annotation.Nullable

  public LocalDate getStartInterestCalculationDate() {
    return startInterestCalculationDate;
  }


  public void setStartInterestCalculationDate(LocalDate startInterestCalculationDate) {
    this.startInterestCalculationDate = startInterestCalculationDate;
  }

  public SavingsAccountData status(SavingsAccountStatusEnumData status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public SavingsAccountStatusEnumData getStatus() {
    return status;
  }


  public void setStatus(SavingsAccountStatusEnumData status) {
    this.status = status;
  }

  public SavingsAccountData subStatus(SavingsAccountSubStatusEnumData subStatus) {
    
    this.subStatus = subStatus;
    return this;
  }

  /**
   * Get subStatus
   * @return subStatus
   */
  @javax.annotation.Nullable

  public SavingsAccountSubStatusEnumData getSubStatus() {
    return subStatus;
  }


  public void setSubStatus(SavingsAccountSubStatusEnumData subStatus) {
    this.subStatus = subStatus;
  }

  public SavingsAccountData submittedOnDate(LocalDate submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(LocalDate submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public SavingsAccountData summary(SavingsAccountSummaryData summary) {
    
    this.summary = summary;
    return this;
  }

  /**
   * Get summary
   * @return summary
   */
  @javax.annotation.Nullable

  public SavingsAccountSummaryData getSummary() {
    return summary;
  }


  public void setSummary(SavingsAccountSummaryData summary) {
    this.summary = summary;
  }

  public SavingsAccountData taxGroup(TaxGroupData taxGroup) {
    
    this.taxGroup = taxGroup;
    return this;
  }

  /**
   * Get taxGroup
   * @return taxGroup
   */
  @javax.annotation.Nullable

  public TaxGroupData getTaxGroup() {
    return taxGroup;
  }


  public void setTaxGroup(TaxGroupData taxGroup) {
    this.taxGroup = taxGroup;
  }

  public SavingsAccountData timeline(SavingsAccountApplicationTimelineData timeline) {
    
    this.timeline = timeline;
    return this;
  }

  /**
   * Get timeline
   * @return timeline
   */
  @javax.annotation.Nullable

  public SavingsAccountApplicationTimelineData getTimeline() {
    return timeline;
  }


  public void setTimeline(SavingsAccountApplicationTimelineData timeline) {
    this.timeline = timeline;
  }

  public SavingsAccountData transactions(List<SavingsAccountTransactionData> transactions) {
    
    this.transactions = transactions;
    return this;
  }

  public SavingsAccountData addTransactionsItem(SavingsAccountTransactionData transactionsItem) {
    if (this.transactions == null) {
      this.transactions = new ArrayList<>();
    }
    this.transactions.add(transactionsItem);
    return this;
  }

  /**
   * Get transactions
   * @return transactions
   */
  @javax.annotation.Nullable

  public List<SavingsAccountTransactionData> getTransactions() {
    return transactions;
  }


  public void setTransactions(List<SavingsAccountTransactionData> transactions) {
    this.transactions = transactions;
  }

  public SavingsAccountData updatedTransactions(List<SavingsAccountTransactionData> updatedTransactions) {
    
    this.updatedTransactions = updatedTransactions;
    return this;
  }

  public SavingsAccountData addUpdatedTransactionsItem(SavingsAccountTransactionData updatedTransactionsItem) {
    if (this.updatedTransactions == null) {
      this.updatedTransactions = new ArrayList<>();
    }
    this.updatedTransactions.add(updatedTransactionsItem);
    return this;
  }

  /**
   * Get updatedTransactions
   * @return updatedTransactions
   */
  @javax.annotation.Nullable

  public List<SavingsAccountTransactionData> getUpdatedTransactions() {
    return updatedTransactions;
  }


  public void setUpdatedTransactions(List<SavingsAccountTransactionData> updatedTransactions) {
    this.updatedTransactions = updatedTransactions;
  }

  public SavingsAccountData withHoldTax(Boolean withHoldTax) {
    
    this.withHoldTax = withHoldTax;
    return this;
  }

  /**
   * Get withHoldTax
   * @return withHoldTax
   */
  @javax.annotation.Nullable

  public Boolean getWithHoldTax() {
    return withHoldTax;
  }


  public void setWithHoldTax(Boolean withHoldTax) {
    this.withHoldTax = withHoldTax;
  }

  public SavingsAccountData withdrawalFee(SavingsAccountChargeData withdrawalFee) {
    
    this.withdrawalFee = withdrawalFee;
    return this;
  }

  /**
   * Get withdrawalFee
   * @return withdrawalFee
   */
  @javax.annotation.Nullable

  public SavingsAccountChargeData getWithdrawalFee() {
    return withdrawalFee;
  }


  public void setWithdrawalFee(SavingsAccountChargeData withdrawalFee) {
    this.withdrawalFee = withdrawalFee;
  }

  public SavingsAccountData withdrawalFeeForTransfers(Boolean withdrawalFeeForTransfers) {
    
    this.withdrawalFeeForTransfers = withdrawalFeeForTransfers;
    return this;
  }

  /**
   * Get withdrawalFeeForTransfers
   * @return withdrawalFeeForTransfers
   */
  @javax.annotation.Nullable

  public Boolean getWithdrawalFeeForTransfers() {
    return withdrawalFeeForTransfers;
  }


  public void setWithdrawalFeeForTransfers(Boolean withdrawalFeeForTransfers) {
    this.withdrawalFeeForTransfers = withdrawalFeeForTransfers;
  }

  public SavingsAccountData withdrawalFeeTypeOptions(List<EnumOptionData> withdrawalFeeTypeOptions) {
    
    this.withdrawalFeeTypeOptions = withdrawalFeeTypeOptions;
    return this;
  }

  public SavingsAccountData addWithdrawalFeeTypeOptionsItem(EnumOptionData withdrawalFeeTypeOptionsItem) {
    if (this.withdrawalFeeTypeOptions == null) {
      this.withdrawalFeeTypeOptions = new ArrayList<>();
    }
    this.withdrawalFeeTypeOptions.add(withdrawalFeeTypeOptionsItem);
    return this;
  }

  /**
   * Get withdrawalFeeTypeOptions
   * @return withdrawalFeeTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getWithdrawalFeeTypeOptions() {
    return withdrawalFeeTypeOptions;
  }


  public void setWithdrawalFeeTypeOptions(List<EnumOptionData> withdrawalFeeTypeOptions) {
    this.withdrawalFeeTypeOptions = withdrawalFeeTypeOptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SavingsAccountData savingsAccountData = (SavingsAccountData) o;
    return Objects.equals(this.accountNo, savingsAccountData.accountNo) &&
        Objects.equals(this.accrualBasedAccountingEnabledOnSavingsProduct, savingsAccountData.accrualBasedAccountingEnabledOnSavingsProduct) &&
        Objects.equals(this.activatedOnDate, savingsAccountData.activatedOnDate) &&
        Objects.equals(this.activationLocalDate, savingsAccountData.activationLocalDate) &&
        Objects.equals(this.allowOverdraft, savingsAccountData.allowOverdraft) &&
        Objects.equals(this.annualFee, savingsAccountData.annualFee) &&
        Objects.equals(this.cashBasedAccountingEnabledOnSavingsProduct, savingsAccountData.cashBasedAccountingEnabledOnSavingsProduct) &&
        Objects.equals(this.chargeOptions, savingsAccountData.chargeOptions) &&
        Objects.equals(this.charges, savingsAccountData.charges) &&
        Objects.equals(this.clientData, savingsAccountData.clientData) &&
        Objects.equals(this.clientId, savingsAccountData.clientId) &&
        Objects.equals(this.clientName, savingsAccountData.clientName) &&
        Objects.equals(this.currency, savingsAccountData.currency) &&
        Objects.equals(this.datatables, savingsAccountData.datatables) &&
        Objects.equals(this.dateFormat, savingsAccountData.dateFormat) &&
        Objects.equals(this.daysToDormancy, savingsAccountData.daysToDormancy) &&
        Objects.equals(this.daysToEscheat, savingsAccountData.daysToEscheat) &&
        Objects.equals(this.daysToInactive, savingsAccountData.daysToInactive) &&
        Objects.equals(this.depositType, savingsAccountData.depositType) &&
        Objects.equals(this.depositTypeId, savingsAccountData.depositTypeId) &&
        Objects.equals(this.enforceMinRequiredBalance, savingsAccountData.enforceMinRequiredBalance) &&
        Objects.equals(this.existingReversedTransactionIds, savingsAccountData.existingReversedTransactionIds) &&
        Objects.equals(this.existingTransactionIds, savingsAccountData.existingTransactionIds) &&
        Objects.equals(this.externalId, savingsAccountData.externalId) &&
        Objects.equals(this.fieldOfficerId, savingsAccountData.fieldOfficerId) &&
        Objects.equals(this.fieldOfficerName, savingsAccountData.fieldOfficerName) &&
        Objects.equals(this.fieldOfficerOptions, savingsAccountData.fieldOfficerOptions) &&
        Objects.equals(this.glAccountIdForInterestOnSavings, savingsAccountData.glAccountIdForInterestOnSavings) &&
        Objects.equals(this.glAccountIdForInterestPayable, savingsAccountData.glAccountIdForInterestPayable) &&
        Objects.equals(this.glAccountIdForInterestReceivable, savingsAccountData.glAccountIdForInterestReceivable) &&
        Objects.equals(this.glAccountIdForOverdraftPorfolio, savingsAccountData.glAccountIdForOverdraftPorfolio) &&
        Objects.equals(this.glAccountIdForSavingsControl, savingsAccountData.glAccountIdForSavingsControl) &&
        Objects.equals(this.groupGeneralData, savingsAccountData.groupGeneralData) &&
        Objects.equals(this.groupId, savingsAccountData.groupId) &&
        Objects.equals(this.groupName, savingsAccountData.groupName) &&
        Objects.equals(this.id, savingsAccountData.id) &&
        Objects.equals(this.interestCalculationDaysInYearType, savingsAccountData.interestCalculationDaysInYearType) &&
        Objects.equals(this.interestCalculationDaysInYearTypeId, savingsAccountData.interestCalculationDaysInYearTypeId) &&
        Objects.equals(this.interestCalculationDaysInYearTypeOptions, savingsAccountData.interestCalculationDaysInYearTypeOptions) &&
        Objects.equals(this.interestCalculationType, savingsAccountData.interestCalculationType) &&
        Objects.equals(this.interestCalculationTypeId, savingsAccountData.interestCalculationTypeId) &&
        Objects.equals(this.interestCalculationTypeOptions, savingsAccountData.interestCalculationTypeOptions) &&
        Objects.equals(this.interestCompoundingPeriodType, savingsAccountData.interestCompoundingPeriodType) &&
        Objects.equals(this.interestCompoundingPeriodTypeId, savingsAccountData.interestCompoundingPeriodTypeId) &&
        Objects.equals(this.interestCompoundingPeriodTypeOptions, savingsAccountData.interestCompoundingPeriodTypeOptions) &&
        Objects.equals(this.interestPosting, savingsAccountData.interestPosting) &&
        Objects.equals(this.interestPostingPeriodType, savingsAccountData.interestPostingPeriodType) &&
        Objects.equals(this.interestPostingPeriodTypeId, savingsAccountData.interestPostingPeriodTypeId) &&
        Objects.equals(this.interestPostingPeriodTypeOptions, savingsAccountData.interestPostingPeriodTypeOptions) &&
        Objects.equals(this.isDormancyTrackingActive, savingsAccountData.isDormancyTrackingActive) &&
        Objects.equals(this.lastActiveTransactionDate, savingsAccountData.lastActiveTransactionDate) &&
        Objects.equals(this.lastSavingsAccountTransaction, savingsAccountData.lastSavingsAccountTransaction) &&
        Objects.equals(this.lienAllowed, savingsAccountData.lienAllowed) &&
        Objects.equals(this.locale, savingsAccountData.locale) &&
        Objects.equals(this.lockedInUntilDate, savingsAccountData.lockedInUntilDate) &&
        Objects.equals(this.lockinPeriodFrequency, savingsAccountData.lockinPeriodFrequency) &&
        Objects.equals(this.lockinPeriodFrequencyType, savingsAccountData.lockinPeriodFrequencyType) &&
        Objects.equals(this.lockinPeriodFrequencyTypeId, savingsAccountData.lockinPeriodFrequencyTypeId) &&
        Objects.equals(this.lockinPeriodFrequencyTypeOptions, savingsAccountData.lockinPeriodFrequencyTypeOptions) &&
        Objects.equals(this.maxAllowedLienLimit, savingsAccountData.maxAllowedLienLimit) &&
        Objects.equals(this.minBalanceForInterestCalculation, savingsAccountData.minBalanceForInterestCalculation) &&
        Objects.equals(this.minOverdraftForInterestCalculation, savingsAccountData.minOverdraftForInterestCalculation) &&
        Objects.equals(this.minRequiredBalance, savingsAccountData.minRequiredBalance) &&
        Objects.equals(this.minRequiredOpeningBalance, savingsAccountData.minRequiredOpeningBalance) &&
        Objects.equals(this.newSavingsAccountTransactionData, savingsAccountData.newSavingsAccountTransactionData) &&
        Objects.equals(this.nominalAnnualInterestRate, savingsAccountData.nominalAnnualInterestRate) &&
        Objects.equals(this.nominalAnnualInterestRateOverdraft, savingsAccountData.nominalAnnualInterestRateOverdraft) &&
        Objects.equals(this.officeId, savingsAccountData.officeId) &&
        Objects.equals(this.onHoldFunds, savingsAccountData.onHoldFunds) &&
        Objects.equals(this.overdraftLimit, savingsAccountData.overdraftLimit) &&
        Objects.equals(this.overdraftPosting, savingsAccountData.overdraftPosting) &&
        Objects.equals(this.productId, savingsAccountData.productId) &&
        Objects.equals(this.productOptions, savingsAccountData.productOptions) &&
        Objects.equals(this.reasonForBlock, savingsAccountData.reasonForBlock) &&
        Objects.equals(this.rowIndex, savingsAccountData.rowIndex) &&
        Objects.equals(this.savingsAccountSummaryData, savingsAccountData.savingsAccountSummaryData) &&
        Objects.equals(this.savingsAccountTransactionData, savingsAccountData.savingsAccountTransactionData) &&
        Objects.equals(this.savingsAccountTransactionSummaryWrapper, savingsAccountData.savingsAccountTransactionSummaryWrapper) &&
        Objects.equals(this.savingsAccountTransactionsWithPivotConfig, savingsAccountData.savingsAccountTransactionsWithPivotConfig) &&
        Objects.equals(this.savingsAmountOnHold, savingsAccountData.savingsAmountOnHold) &&
        Objects.equals(this.savingsHelper, savingsAccountData.savingsHelper) &&
        Objects.equals(this.savingsProduct, savingsAccountData.savingsProduct) &&
        Objects.equals(this.savingsProductData, savingsAccountData.savingsProductData) &&
        Objects.equals(this.savingsProductId, savingsAccountData.savingsProductId) &&
        Objects.equals(this.savingsProductName, savingsAccountData.savingsProductName) &&
        Objects.equals(this.startInterestCalculationDate, savingsAccountData.startInterestCalculationDate) &&
        Objects.equals(this.status, savingsAccountData.status) &&
        Objects.equals(this.subStatus, savingsAccountData.subStatus) &&
        Objects.equals(this.submittedOnDate, savingsAccountData.submittedOnDate) &&
        Objects.equals(this.summary, savingsAccountData.summary) &&
        Objects.equals(this.taxGroup, savingsAccountData.taxGroup) &&
        Objects.equals(this.timeline, savingsAccountData.timeline) &&
        Objects.equals(this.transactions, savingsAccountData.transactions) &&
        Objects.equals(this.updatedTransactions, savingsAccountData.updatedTransactions) &&
        Objects.equals(this.withHoldTax, savingsAccountData.withHoldTax) &&
        Objects.equals(this.withdrawalFee, savingsAccountData.withdrawalFee) &&
        Objects.equals(this.withdrawalFeeForTransfers, savingsAccountData.withdrawalFeeForTransfers) &&
        Objects.equals(this.withdrawalFeeTypeOptions, savingsAccountData.withdrawalFeeTypeOptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNo, accrualBasedAccountingEnabledOnSavingsProduct, activatedOnDate, activationLocalDate, allowOverdraft, annualFee, cashBasedAccountingEnabledOnSavingsProduct, chargeOptions, charges, clientData, clientId, clientName, currency, datatables, dateFormat, daysToDormancy, daysToEscheat, daysToInactive, depositType, depositTypeId, enforceMinRequiredBalance, existingReversedTransactionIds, existingTransactionIds, externalId, fieldOfficerId, fieldOfficerName, fieldOfficerOptions, glAccountIdForInterestOnSavings, glAccountIdForInterestPayable, glAccountIdForInterestReceivable, glAccountIdForOverdraftPorfolio, glAccountIdForSavingsControl, groupGeneralData, groupId, groupName, id, interestCalculationDaysInYearType, interestCalculationDaysInYearTypeId, interestCalculationDaysInYearTypeOptions, interestCalculationType, interestCalculationTypeId, interestCalculationTypeOptions, interestCompoundingPeriodType, interestCompoundingPeriodTypeId, interestCompoundingPeriodTypeOptions, interestPosting, interestPostingPeriodType, interestPostingPeriodTypeId, interestPostingPeriodTypeOptions, isDormancyTrackingActive, lastActiveTransactionDate, lastSavingsAccountTransaction, lienAllowed, locale, lockedInUntilDate, lockinPeriodFrequency, lockinPeriodFrequencyType, lockinPeriodFrequencyTypeId, lockinPeriodFrequencyTypeOptions, maxAllowedLienLimit, minBalanceForInterestCalculation, minOverdraftForInterestCalculation, minRequiredBalance, minRequiredOpeningBalance, newSavingsAccountTransactionData, nominalAnnualInterestRate, nominalAnnualInterestRateOverdraft, officeId, onHoldFunds, overdraftLimit, overdraftPosting, productId, productOptions, reasonForBlock, rowIndex, savingsAccountSummaryData, savingsAccountTransactionData, savingsAccountTransactionSummaryWrapper, savingsAccountTransactionsWithPivotConfig, savingsAmountOnHold, savingsHelper, savingsProduct, savingsProductData, savingsProductId, savingsProductName, startInterestCalculationDate, status, subStatus, submittedOnDate, summary, taxGroup, timeline, transactions, updatedTransactions, withHoldTax, withdrawalFee, withdrawalFeeForTransfers, withdrawalFeeTypeOptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SavingsAccountData {\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    accrualBasedAccountingEnabledOnSavingsProduct: ").append(toIndentedString(accrualBasedAccountingEnabledOnSavingsProduct)).append("\n");
    sb.append("    activatedOnDate: ").append(toIndentedString(activatedOnDate)).append("\n");
    sb.append("    activationLocalDate: ").append(toIndentedString(activationLocalDate)).append("\n");
    sb.append("    allowOverdraft: ").append(toIndentedString(allowOverdraft)).append("\n");
    sb.append("    annualFee: ").append(toIndentedString(annualFee)).append("\n");
    sb.append("    cashBasedAccountingEnabledOnSavingsProduct: ").append(toIndentedString(cashBasedAccountingEnabledOnSavingsProduct)).append("\n");
    sb.append("    chargeOptions: ").append(toIndentedString(chargeOptions)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    clientData: ").append(toIndentedString(clientData)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    datatables: ").append(toIndentedString(datatables)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    daysToDormancy: ").append(toIndentedString(daysToDormancy)).append("\n");
    sb.append("    daysToEscheat: ").append(toIndentedString(daysToEscheat)).append("\n");
    sb.append("    daysToInactive: ").append(toIndentedString(daysToInactive)).append("\n");
    sb.append("    depositType: ").append(toIndentedString(depositType)).append("\n");
    sb.append("    depositTypeId: ").append(toIndentedString(depositTypeId)).append("\n");
    sb.append("    enforceMinRequiredBalance: ").append(toIndentedString(enforceMinRequiredBalance)).append("\n");
    sb.append("    existingReversedTransactionIds: ").append(toIndentedString(existingReversedTransactionIds)).append("\n");
    sb.append("    existingTransactionIds: ").append(toIndentedString(existingTransactionIds)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    fieldOfficerId: ").append(toIndentedString(fieldOfficerId)).append("\n");
    sb.append("    fieldOfficerName: ").append(toIndentedString(fieldOfficerName)).append("\n");
    sb.append("    fieldOfficerOptions: ").append(toIndentedString(fieldOfficerOptions)).append("\n");
    sb.append("    glAccountIdForInterestOnSavings: ").append(toIndentedString(glAccountIdForInterestOnSavings)).append("\n");
    sb.append("    glAccountIdForInterestPayable: ").append(toIndentedString(glAccountIdForInterestPayable)).append("\n");
    sb.append("    glAccountIdForInterestReceivable: ").append(toIndentedString(glAccountIdForInterestReceivable)).append("\n");
    sb.append("    glAccountIdForOverdraftPorfolio: ").append(toIndentedString(glAccountIdForOverdraftPorfolio)).append("\n");
    sb.append("    glAccountIdForSavingsControl: ").append(toIndentedString(glAccountIdForSavingsControl)).append("\n");
    sb.append("    groupGeneralData: ").append(toIndentedString(groupGeneralData)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    interestCalculationDaysInYearType: ").append(toIndentedString(interestCalculationDaysInYearType)).append("\n");
    sb.append("    interestCalculationDaysInYearTypeId: ").append(toIndentedString(interestCalculationDaysInYearTypeId)).append("\n");
    sb.append("    interestCalculationDaysInYearTypeOptions: ").append(toIndentedString(interestCalculationDaysInYearTypeOptions)).append("\n");
    sb.append("    interestCalculationType: ").append(toIndentedString(interestCalculationType)).append("\n");
    sb.append("    interestCalculationTypeId: ").append(toIndentedString(interestCalculationTypeId)).append("\n");
    sb.append("    interestCalculationTypeOptions: ").append(toIndentedString(interestCalculationTypeOptions)).append("\n");
    sb.append("    interestCompoundingPeriodType: ").append(toIndentedString(interestCompoundingPeriodType)).append("\n");
    sb.append("    interestCompoundingPeriodTypeId: ").append(toIndentedString(interestCompoundingPeriodTypeId)).append("\n");
    sb.append("    interestCompoundingPeriodTypeOptions: ").append(toIndentedString(interestCompoundingPeriodTypeOptions)).append("\n");
    sb.append("    interestPosting: ").append(toIndentedString(interestPosting)).append("\n");
    sb.append("    interestPostingPeriodType: ").append(toIndentedString(interestPostingPeriodType)).append("\n");
    sb.append("    interestPostingPeriodTypeId: ").append(toIndentedString(interestPostingPeriodTypeId)).append("\n");
    sb.append("    interestPostingPeriodTypeOptions: ").append(toIndentedString(interestPostingPeriodTypeOptions)).append("\n");
    sb.append("    isDormancyTrackingActive: ").append(toIndentedString(isDormancyTrackingActive)).append("\n");
    sb.append("    lastActiveTransactionDate: ").append(toIndentedString(lastActiveTransactionDate)).append("\n");
    sb.append("    lastSavingsAccountTransaction: ").append(toIndentedString(lastSavingsAccountTransaction)).append("\n");
    sb.append("    lienAllowed: ").append(toIndentedString(lienAllowed)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    lockedInUntilDate: ").append(toIndentedString(lockedInUntilDate)).append("\n");
    sb.append("    lockinPeriodFrequency: ").append(toIndentedString(lockinPeriodFrequency)).append("\n");
    sb.append("    lockinPeriodFrequencyType: ").append(toIndentedString(lockinPeriodFrequencyType)).append("\n");
    sb.append("    lockinPeriodFrequencyTypeId: ").append(toIndentedString(lockinPeriodFrequencyTypeId)).append("\n");
    sb.append("    lockinPeriodFrequencyTypeOptions: ").append(toIndentedString(lockinPeriodFrequencyTypeOptions)).append("\n");
    sb.append("    maxAllowedLienLimit: ").append(toIndentedString(maxAllowedLienLimit)).append("\n");
    sb.append("    minBalanceForInterestCalculation: ").append(toIndentedString(minBalanceForInterestCalculation)).append("\n");
    sb.append("    minOverdraftForInterestCalculation: ").append(toIndentedString(minOverdraftForInterestCalculation)).append("\n");
    sb.append("    minRequiredBalance: ").append(toIndentedString(minRequiredBalance)).append("\n");
    sb.append("    minRequiredOpeningBalance: ").append(toIndentedString(minRequiredOpeningBalance)).append("\n");
    sb.append("    newSavingsAccountTransactionData: ").append(toIndentedString(newSavingsAccountTransactionData)).append("\n");
    sb.append("    nominalAnnualInterestRate: ").append(toIndentedString(nominalAnnualInterestRate)).append("\n");
    sb.append("    nominalAnnualInterestRateOverdraft: ").append(toIndentedString(nominalAnnualInterestRateOverdraft)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    onHoldFunds: ").append(toIndentedString(onHoldFunds)).append("\n");
    sb.append("    overdraftLimit: ").append(toIndentedString(overdraftLimit)).append("\n");
    sb.append("    overdraftPosting: ").append(toIndentedString(overdraftPosting)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    productOptions: ").append(toIndentedString(productOptions)).append("\n");
    sb.append("    reasonForBlock: ").append(toIndentedString(reasonForBlock)).append("\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    savingsAccountSummaryData: ").append(toIndentedString(savingsAccountSummaryData)).append("\n");
    sb.append("    savingsAccountTransactionData: ").append(toIndentedString(savingsAccountTransactionData)).append("\n");
    sb.append("    savingsAccountTransactionSummaryWrapper: ").append(toIndentedString(savingsAccountTransactionSummaryWrapper)).append("\n");
    sb.append("    savingsAccountTransactionsWithPivotConfig: ").append(toIndentedString(savingsAccountTransactionsWithPivotConfig)).append("\n");
    sb.append("    savingsAmountOnHold: ").append(toIndentedString(savingsAmountOnHold)).append("\n");
    sb.append("    savingsHelper: ").append(toIndentedString(savingsHelper)).append("\n");
    sb.append("    savingsProduct: ").append(toIndentedString(savingsProduct)).append("\n");
    sb.append("    savingsProductData: ").append(toIndentedString(savingsProductData)).append("\n");
    sb.append("    savingsProductId: ").append(toIndentedString(savingsProductId)).append("\n");
    sb.append("    savingsProductName: ").append(toIndentedString(savingsProductName)).append("\n");
    sb.append("    startInterestCalculationDate: ").append(toIndentedString(startInterestCalculationDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    subStatus: ").append(toIndentedString(subStatus)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    taxGroup: ").append(toIndentedString(taxGroup)).append("\n");
    sb.append("    timeline: ").append(toIndentedString(timeline)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("    updatedTransactions: ").append(toIndentedString(updatedTransactions)).append("\n");
    sb.append("    withHoldTax: ").append(toIndentedString(withHoldTax)).append("\n");
    sb.append("    withdrawalFee: ").append(toIndentedString(withdrawalFee)).append("\n");
    sb.append("    withdrawalFeeForTransfers: ").append(toIndentedString(withdrawalFeeForTransfers)).append("\n");
    sb.append("    withdrawalFeeTypeOptions: ").append(toIndentedString(withdrawalFeeTypeOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

