package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CurrencyConfigurationData;
import org.apache.fineract.client.models.CurrencyUpdateRequest;
import org.apache.fineract.client.models.CurrencyUpdateResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CurrencyApi {
    /**
    * Retrieve Currency Configuration
    * Returns the list of currencies permitted for use AND the list of currencies not selected (but available for selection).  Example Requests:  currencies currencies?fields&#x3D;selectedCurrencyOptions 
    * @return Call&lt;CurrencyConfigurationData&gt;
    */
    @GET("v1/currencies")
    Call<CurrencyConfigurationData> retrieveCurrencies();

    /**
    * Update Currency Configuration
    * Updates the list of currencies permitted for use.
        * @param currencyUpdateRequest  (optional)
    * @return Call&lt;CurrencyUpdateResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/currencies")
    Call<CurrencyUpdateResponse> updateCurrencies(@retrofit2.http.Body CurrencyUpdateRequest currencyUpdateRequest);


        /**
        * Update Currency Configuration
        * Updates the list of currencies permitted for use.
            * @param currencyUpdateRequest  (optional)
        * @return Call&lt;CurrencyUpdateResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/currencies")
    Call<CurrencyUpdateResponse> updateCurrencies();

        /**
        * Retrieve Currency Configuration
        * Returns the list of currencies permitted for use AND the list of currencies not selected (but available for selection).  Example Requests:  currencies currencies?fields&#x3D;selectedCurrencyOptions 
        * @return Call&lt;CurrencyConfigurationData&gt;
        */
    @GET("v1/currencies")
    Call<CurrencyConfigurationData> retrieveCurrencies(@HeaderMap Map<String, String> headers);

        /**
        * Update Currency Configuration
        * Updates the list of currencies permitted for use.
            * @param currencyUpdateRequest  (optional)
        * @return Call&lt;CurrencyUpdateResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/currencies")
    Call<CurrencyUpdateResponse> updateCurrencies(@retrofit2.http.Body CurrencyUpdateRequest currencyUpdateRequest, @HeaderMap Map<String, String> headers);


        /**
        * Update Currency Configuration
        * Updates the list of currencies permitted for use.
            * @param currencyUpdateRequest  (optional)
        * @return Call&lt;CurrencyUpdateResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/currencies")
    Call<CurrencyUpdateResponse> updateCurrencies(@HeaderMap Map<String, String> headers);
}
