package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CommandProcessingResult;
import org.apache.fineract.client.models.PageExternalTransferLoanProductAttributesData;
import org.apache.fineract.client.models.PostExternalAssetOwnerLoanProductAttributeRequest;
import org.apache.fineract.client.models.PutExternalAssetOwnerLoanProductAttributeRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ExternalAssetOwnerLoanProductAttributesApi {
    /**
    * Retrieve All Loan Product Attributes
    * Retrieves all Loan Product Attributes with a given loanProductId
        * @param loanProductId loanProductId (required)
        * @param attributeKey attributeKey (optional)
    * @return Call&lt;PageExternalTransferLoanProductAttributesData&gt;
    */
    @GET("v1/external-asset-owners/loan-product/{loanProductId}/attributes")
    Call<PageExternalTransferLoanProductAttributesData> getExternalAssetOwnerLoanProductAttributes(@retrofit2.http.Path("loanProductId") Long loanProductId, @retrofit2.http.Query("attributeKey") String attributeKey);

    /**
    * 
    * 
        * @param loanProductId loanProductId (required)
        * @param postExternalAssetOwnerLoanProductAttributeRequest  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/external-asset-owners/loan-product/{loanProductId}/attributes")
    Call<CommandProcessingResult> postExternalAssetOwnerLoanProductAttribute(@retrofit2.http.Path("loanProductId") Long loanProductId, @retrofit2.http.Body PostExternalAssetOwnerLoanProductAttributeRequest postExternalAssetOwnerLoanProductAttributeRequest);

    /**
    * Update a Loan Product Attribute
    * Updates a loan product attribute with a given loan product id and attribute id
        * @param loanProductId loanProductId (required)
        * @param id attributeId (required)
        * @param putExternalAssetOwnerLoanProductAttributeRequest  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/external-asset-owners/loan-product/{loanProductId}/attributes/{id}")
    Call<CommandProcessingResult> updateLoanProductAttribute(@retrofit2.http.Path("loanProductId") Long loanProductId, @retrofit2.http.Path("id") Long id, @retrofit2.http.Body PutExternalAssetOwnerLoanProductAttributeRequest putExternalAssetOwnerLoanProductAttributeRequest);



        /**
        * Retrieve All Loan Product Attributes
        * Retrieves all Loan Product Attributes with a given loanProductId
            * @param loanProductId loanProductId (required)
            * @param attributeKey attributeKey (optional)
        * @return Call&lt;PageExternalTransferLoanProductAttributesData&gt;
        */
    @GET("v1/external-asset-owners/loan-product/{loanProductId}/attributes")
    Call<PageExternalTransferLoanProductAttributesData> getExternalAssetOwnerLoanProductAttributes(@retrofit2.http.Path("loanProductId") Long loanProductId, @retrofit2.http.Query("attributeKey") String attributeKey, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanProductId loanProductId (required)
            * @param postExternalAssetOwnerLoanProductAttributeRequest  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/external-asset-owners/loan-product/{loanProductId}/attributes")
    Call<CommandProcessingResult> postExternalAssetOwnerLoanProductAttribute(@retrofit2.http.Path("loanProductId") Long loanProductId, @retrofit2.http.Body PostExternalAssetOwnerLoanProductAttributeRequest postExternalAssetOwnerLoanProductAttributeRequest, @HeaderMap Map<String, String> headers);

        /**
        * Update a Loan Product Attribute
        * Updates a loan product attribute with a given loan product id and attribute id
            * @param loanProductId loanProductId (required)
            * @param id attributeId (required)
            * @param putExternalAssetOwnerLoanProductAttributeRequest  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/external-asset-owners/loan-product/{loanProductId}/attributes/{id}")
    Call<CommandProcessingResult> updateLoanProductAttribute(@retrofit2.http.Path("loanProductId") Long loanProductId, @retrofit2.http.Path("id") Long id, @retrofit2.http.Body PutExternalAssetOwnerLoanProductAttributeRequest putExternalAssetOwnerLoanProductAttributeRequest, @HeaderMap Map<String, String> headers);


}
