package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CommandProcessingResult;
import org.apache.fineract.client.models.PageSmsData;
import org.apache.fineract.client.models.SmsCreationRequest;
import org.apache.fineract.client.models.SmsData;
import org.apache.fineract.client.models.SmsUpdateRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface SmsApi {
    /**
    * 
    * 
        * @param smsCreationRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/sms")
    Call<CommandProcessingResult> create2(@retrofit2.http.Body SmsCreationRequest smsCreationRequest);

    /**
    * 
    * 
        * @param resourceId  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
    @DELETE("v1/sms/{resourceId}")
    Call<CommandProcessingResult> delete5(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * 
    * 
    * @return Call&lt;List&lt;SmsData&gt;&gt;
    */
    @GET("v1/sms")
    Call<List<SmsData>> retrieveAll10();

    /**
    * 
    * 
        * @param campaignId  (required)
        * @param status  (optional)
        * @param fromDate  (optional)
        * @param toDate  (optional)
        * @param locale  (optional)
        * @param dateFormat  (optional)
        * @param offset  (optional)
        * @param limit  (optional)
        * @param orderBy  (optional)
        * @param sortOrder  (optional)
    * @return Call&lt;PageSmsData&gt;
    */
    @GET("v1/sms/{campaignId}/messageByStatus")
    Call<PageSmsData> retrieveAllSmsByStatus(@retrofit2.http.Path("campaignId") Long campaignId, @retrofit2.http.Query("status") Long status, @retrofit2.http.Query("fromDate") Object fromDate, @retrofit2.http.Query("toDate") Object toDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder);

    /**
    * 
    * 
        * @param resourceId  (required)
    * @return Call&lt;SmsData&gt;
    */
    @GET("v1/sms/{resourceId}")
    Call<SmsData> retrieveOne6(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * 
    * 
        * @param resourceId  (required)
        * @param smsUpdateRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/sms/{resourceId}")
    Call<CommandProcessingResult> update3(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Body SmsUpdateRequest smsUpdateRequest);


        /**
        * 
        * 
            * @param smsCreationRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/sms")
    Call<CommandProcessingResult> create2();
        /**
        * 
        * 
            * @param resourceId  (required)
            * @param smsUpdateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/sms/{resourceId}")
    Call<CommandProcessingResult> update3(@retrofit2.http.Path("resourceId") Long resourceId);

        /**
        * 
        * 
            * @param smsCreationRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/sms")
    Call<CommandProcessingResult> create2(@retrofit2.http.Body SmsCreationRequest smsCreationRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
    @DELETE("v1/sms/{resourceId}")
    Call<CommandProcessingResult> delete5(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;List&lt;SmsData&gt;&gt;
        */
    @GET("v1/sms")
    Call<List<SmsData>> retrieveAll10(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param campaignId  (required)
            * @param status  (optional)
            * @param fromDate  (optional)
            * @param toDate  (optional)
            * @param locale  (optional)
            * @param dateFormat  (optional)
            * @param offset  (optional)
            * @param limit  (optional)
            * @param orderBy  (optional)
            * @param sortOrder  (optional)
        * @return Call&lt;PageSmsData&gt;
        */
    @GET("v1/sms/{campaignId}/messageByStatus")
    Call<PageSmsData> retrieveAllSmsByStatus(@retrofit2.http.Path("campaignId") Long campaignId, @retrofit2.http.Query("status") Long status, @retrofit2.http.Query("fromDate") Object fromDate, @retrofit2.http.Query("toDate") Object toDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
        * @return Call&lt;SmsData&gt;
        */
    @GET("v1/sms/{resourceId}")
    Call<SmsData> retrieveOne6(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
            * @param smsUpdateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/sms/{resourceId}")
    Call<CommandProcessingResult> update3(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Body SmsUpdateRequest smsUpdateRequest, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param smsCreationRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/sms")
    Call<CommandProcessingResult> create2(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param resourceId  (required)
            * @param smsUpdateRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/sms/{resourceId}")
    Call<CommandProcessingResult> update3(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);
}
