/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.util.Data;
import com.google.api.core.BetaApi;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BackwardCompatibilityUtils;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.Utils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
public class BlobInfo
implements Serializable {
    private static final long serialVersionUID = -2490471217826624578L;
    private final BlobId blobId;
    private final String generatedId;
    private final String selfLink;
    private final String cacheControl;
    private final List<Acl> acl;
    private final Acl.Entity owner;
    private final Long size;
    private final String etag;
    private final String md5;
    private final String crc32c;
    private final OffsetDateTime customTime;
    private final String mediaLink;
    final Map<String, String> metadata;
    private final Long metageneration;
    private final OffsetDateTime deleteTime;
    private final OffsetDateTime updateTime;
    private final OffsetDateTime createTime;
    private final String contentType;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final StorageClass storageClass;
    private final OffsetDateTime timeStorageClassUpdated;
    private final Integer componentCount;
    private final boolean isDirectory;
    private final CustomerEncryption customerEncryption;
    private final String kmsKeyName;
    private final Boolean eventBasedHold;
    private final Boolean temporaryHold;
    private final OffsetDateTime retentionExpirationTime;
    private final transient ImmutableSet<UnifiedOpts.NamedField> modifiedFields;

    BlobInfo(BuilderImpl builder) {
        this.blobId = builder.blobId;
        this.generatedId = builder.generatedId;
        this.cacheControl = builder.cacheControl;
        this.contentEncoding = builder.contentEncoding;
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.contentLanguage = builder.contentLanguage;
        this.componentCount = builder.componentCount;
        this.customerEncryption = builder.customerEncryption;
        this.acl = builder.acl;
        this.owner = builder.owner;
        this.size = builder.size;
        this.etag = builder.etag;
        this.selfLink = builder.selfLink;
        this.md5 = builder.md5;
        this.crc32c = builder.crc32c;
        this.customTime = builder.customTime;
        this.mediaLink = builder.mediaLink;
        this.metadata = builder.metadata;
        this.metageneration = builder.metageneration;
        this.deleteTime = builder.deleteTime;
        this.updateTime = builder.updateTime;
        this.createTime = builder.createTime;
        this.isDirectory = MoreObjects.firstNonNull(builder.isDirectory, Boolean.FALSE);
        this.storageClass = builder.storageClass;
        this.timeStorageClassUpdated = builder.timeStorageClassUpdated;
        this.kmsKeyName = builder.kmsKeyName;
        this.eventBasedHold = builder.eventBasedHold;
        this.temporaryHold = builder.temporaryHold;
        this.retentionExpirationTime = builder.retentionExpirationTime;
        this.modifiedFields = builder.modifiedFields.build();
    }

    public BlobId getBlobId() {
        return this.blobId;
    }

    public String getBucket() {
        return this.getBlobId().getBucket();
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getName() {
        return this.getBlobId().getName();
    }

    public String getCacheControl() {
        return Data.isNull(this.cacheControl) ? null : this.cacheControl;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public Acl.Entity getOwner() {
        return this.owner;
    }

    public Long getSize() {
        return this.size;
    }

    public String getContentType() {
        return Data.isNull(this.contentType) ? null : this.contentType;
    }

    public String getContentEncoding() {
        return Data.isNull(this.contentEncoding) ? null : this.contentEncoding;
    }

    public String getContentDisposition() {
        return Data.isNull(this.contentDisposition) ? null : this.contentDisposition;
    }

    public String getContentLanguage() {
        return Data.isNull(this.contentLanguage) ? null : this.contentLanguage;
    }

    public Integer getComponentCount() {
        return this.componentCount;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getMd5() {
        return Data.isNull(this.md5) ? null : this.md5;
    }

    public String getMd5ToHexString() {
        if (this.md5 == null) {
            return null;
        }
        byte[] decodedMd5 = BaseEncoding.base64().decode(this.md5);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : decodedMd5) {
            stringBuilder.append(String.format("%02x", b & 0xFF));
        }
        return stringBuilder.toString();
    }

    public String getCrc32c() {
        return Data.isNull(this.crc32c) ? null : this.crc32c;
    }

    public String getCrc32cToHexString() {
        if (this.crc32c == null) {
            return null;
        }
        byte[] decodeCrc32c = BaseEncoding.base64().decode(this.crc32c);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : decodeCrc32c) {
            stringBuilder.append(String.format("%02x", b & 0xFF));
        }
        return stringBuilder.toString();
    }

    public String getMediaLink() {
        return this.mediaLink;
    }

    public @Nullable Map<@NonNull String, @Nullable String> getMetadata() {
        return this.metadata == null || Data.isNull(this.metadata) ? null : Collections.unmodifiableMap(this.metadata);
    }

    public Long getGeneration() {
        return this.getBlobId().getGeneration();
    }

    public Long getMetageneration() {
        return this.metageneration;
    }

    @Deprecated
    public Long getDeleteTime() {
        return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.deleteTime);
    }

    public OffsetDateTime getDeleteTimeOffsetDateTime() {
        return this.deleteTime;
    }

    @Deprecated
    public Long getUpdateTime() {
        return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.updateTime);
    }

    public OffsetDateTime getUpdateTimeOffsetDateTime() {
        return this.updateTime;
    }

    @Deprecated
    public Long getCreateTime() {
        return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.createTime);
    }

    public OffsetDateTime getCreateTimeOffsetDateTime() {
        return this.createTime;
    }

    @Deprecated
    public Long getCustomTime() {
        return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.customTime);
    }

    public OffsetDateTime getCustomTimeOffsetDateTime() {
        return this.customTime;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public CustomerEncryption getCustomerEncryption() {
        return this.customerEncryption;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    @Deprecated
    public Long getTimeStorageClassUpdated() {
        return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.timeStorageClassUpdated);
    }

    public OffsetDateTime getTimeStorageClassUpdatedOffsetDateTime() {
        return this.timeStorageClassUpdated;
    }

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    @BetaApi
    public Boolean getEventBasedHold() {
        return Data.isNull(this.eventBasedHold) ? null : this.eventBasedHold;
    }

    @BetaApi
    public Boolean getTemporaryHold() {
        return Data.isNull(this.temporaryHold) ? null : this.temporaryHold;
    }

    @BetaApi
    @Deprecated
    public Long getRetentionExpirationTime() {
        return Data.isNull(this.retentionExpirationTime) ? null : (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.retentionExpirationTime);
    }

    @BetaApi
    public OffsetDateTime getRetentionExpirationTimeOffsetDateTime() {
        return this.retentionExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bucket", this.getBucket()).add("name", this.getName()).add("generation", this.getGeneration()).add("size", this.getSize()).add("content-type", this.getContentType()).add("metadata", this.getMetadata()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.blobId, this.generatedId, this.selfLink, this.cacheControl, this.acl, this.owner, this.size, this.etag, this.md5, this.crc32c, this.customTime, this.mediaLink, this.metadata, this.metageneration, this.deleteTime, this.updateTime, this.createTime, this.contentType, this.contentEncoding, this.contentDisposition, this.contentLanguage, this.storageClass, this.timeStorageClassUpdated, this.componentCount, this.isDirectory, this.customerEncryption, this.kmsKeyName, this.eventBasedHold, this.temporaryHold, this.retentionExpirationTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlobInfo)) {
            return false;
        }
        BlobInfo blobInfo = (BlobInfo)o;
        return this.isDirectory == blobInfo.isDirectory && Objects.equals(this.blobId, blobInfo.blobId) && Objects.equals(this.generatedId, blobInfo.generatedId) && Objects.equals(this.selfLink, blobInfo.selfLink) && Objects.equals(this.cacheControl, blobInfo.cacheControl) && Objects.equals(this.acl, blobInfo.acl) && Objects.equals(this.owner, blobInfo.owner) && Objects.equals(this.size, blobInfo.size) && Objects.equals(this.etag, blobInfo.etag) && Objects.equals(this.md5, blobInfo.md5) && Objects.equals(this.crc32c, blobInfo.crc32c) && Objects.equals(this.customTime, blobInfo.customTime) && Objects.equals(this.mediaLink, blobInfo.mediaLink) && Objects.equals(this.metadata, blobInfo.metadata) && Objects.equals(this.metageneration, blobInfo.metageneration) && Objects.equals(this.deleteTime, blobInfo.deleteTime) && Objects.equals(this.updateTime, blobInfo.updateTime) && Objects.equals(this.createTime, blobInfo.createTime) && Objects.equals(this.contentType, blobInfo.contentType) && Objects.equals(this.contentEncoding, blobInfo.contentEncoding) && Objects.equals(this.contentDisposition, blobInfo.contentDisposition) && Objects.equals(this.contentLanguage, blobInfo.contentLanguage) && Objects.equals(this.storageClass, blobInfo.storageClass) && Objects.equals(this.timeStorageClassUpdated, blobInfo.timeStorageClassUpdated) && Objects.equals(this.componentCount, blobInfo.componentCount) && Objects.equals(this.customerEncryption, blobInfo.customerEncryption) && Objects.equals(this.kmsKeyName, blobInfo.kmsKeyName) && Objects.equals(this.eventBasedHold, blobInfo.eventBasedHold) && Objects.equals(this.temporaryHold, blobInfo.temporaryHold) && Objects.equals(this.retentionExpirationTime, blobInfo.retentionExpirationTime);
    }

    ImmutableSet<UnifiedOpts.NamedField> getModifiedFields() {
        return this.modifiedFields;
    }

    Blob asBlob(Storage storage) {
        return new Blob(storage, new BuilderImpl(this));
    }

    public static Builder newBuilder(BucketInfo bucketInfo, String name) {
        return BlobInfo.newBuilder(bucketInfo.getName(), name);
    }

    public static Builder newBuilder(String bucket, String name) {
        return BlobInfo.newBuilder(BlobId.of(bucket, name));
    }

    public static Builder newBuilder(BucketInfo bucketInfo, String name, Long generation) {
        return BlobInfo.newBuilder(bucketInfo.getName(), name, generation);
    }

    public static Builder newBuilder(String bucket, String name, Long generation) {
        return BlobInfo.newBuilder(BlobId.of(bucket, name, generation));
    }

    public static Builder newBuilder(BlobId blobId) {
        return new BuilderImpl(blobId);
    }

    public static class CustomerEncryption
    implements Serializable {
        private static final long serialVersionUID = -7427738060808591323L;
        private final String encryptionAlgorithm;
        private final String keySha256;

        CustomerEncryption(String encryptionAlgorithm, String keySha256) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.keySha256 = keySha256;
        }

        public String getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        public String getKeySha256() {
            return this.keySha256;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("encryptionAlgorithm", this.getEncryptionAlgorithm()).add("keySha256", this.getKeySha256()).toString();
        }

        public final int hashCode() {
            return Objects.hash(this.encryptionAlgorithm, this.keySha256);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomerEncryption)) {
                return false;
            }
            CustomerEncryption that = (CustomerEncryption)o;
            return Objects.equals(this.encryptionAlgorithm, that.encryptionAlgorithm) && Objects.equals(this.keySha256, that.keySha256);
        }
    }

    static final class BuilderImpl
    extends Builder {
        private static final String hexDecimalValues = "0123456789abcdef";
        private BlobId blobId;
        private String generatedId;
        private String contentType;
        private String contentEncoding;
        private String contentDisposition;
        private String contentLanguage;
        private Integer componentCount;
        private String cacheControl;
        private List<Acl> acl;
        private Acl.Entity owner;
        private Long size;
        private String etag;
        private String selfLink;
        private String md5;
        private String crc32c;
        private OffsetDateTime customTime;
        private String mediaLink;
        private Map<String, String> metadata;
        private Long metageneration;
        private OffsetDateTime deleteTime;
        private OffsetDateTime updateTime;
        private OffsetDateTime createTime;
        private Boolean isDirectory;
        private CustomerEncryption customerEncryption;
        private StorageClass storageClass;
        private OffsetDateTime timeStorageClassUpdated;
        private String kmsKeyName;
        private Boolean eventBasedHold;
        private Boolean temporaryHold;
        private OffsetDateTime retentionExpirationTime;
        private final ImmutableSet.Builder<UnifiedOpts.NamedField> modifiedFields = ImmutableSet.builder();

        BuilderImpl(BlobId blobId) {
            this.blobId = blobId;
        }

        BuilderImpl(BlobInfo blobInfo) {
            this.blobId = blobInfo.blobId;
            this.generatedId = blobInfo.generatedId;
            this.cacheControl = blobInfo.cacheControl;
            this.contentEncoding = blobInfo.contentEncoding;
            this.contentType = blobInfo.contentType;
            this.contentDisposition = blobInfo.contentDisposition;
            this.contentLanguage = blobInfo.contentLanguage;
            this.componentCount = blobInfo.componentCount;
            this.customerEncryption = blobInfo.customerEncryption;
            this.acl = blobInfo.acl;
            this.owner = blobInfo.owner;
            this.size = blobInfo.size;
            this.etag = blobInfo.etag;
            this.selfLink = blobInfo.selfLink;
            this.md5 = blobInfo.md5;
            this.crc32c = blobInfo.crc32c;
            this.customTime = blobInfo.customTime;
            this.mediaLink = blobInfo.mediaLink;
            this.metadata = blobInfo.metadata;
            this.metageneration = blobInfo.metageneration;
            this.deleteTime = blobInfo.deleteTime;
            this.updateTime = blobInfo.updateTime;
            this.createTime = blobInfo.createTime;
            this.isDirectory = blobInfo.isDirectory;
            this.storageClass = blobInfo.storageClass;
            this.timeStorageClassUpdated = blobInfo.timeStorageClassUpdated;
            this.kmsKeyName = blobInfo.kmsKeyName;
            this.eventBasedHold = blobInfo.eventBasedHold;
            this.temporaryHold = blobInfo.temporaryHold;
            this.retentionExpirationTime = blobInfo.retentionExpirationTime;
        }

        @Override
        public Builder setBlobId(BlobId blobId) {
            Preconditions.checkNotNull(blobId);
            if (!Objects.equals(this.blobId, blobId)) {
                if (!Objects.equals(this.blobId.getBucket(), blobId.getBucket())) {
                    this.modifiedFields.add((Object)Storage.BlobField.BUCKET);
                }
                if (!Objects.equals(this.blobId.getName(), blobId.getName())) {
                    this.modifiedFields.add((Object)Storage.BlobField.NAME);
                }
                if (!Objects.equals(this.blobId.getGeneration(), blobId.getGeneration())) {
                    this.modifiedFields.add((Object)Storage.BlobField.GENERATION);
                }
            }
            this.blobId = blobId;
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        public Builder setContentType(String contentType) {
            String tmp = MoreObjects.firstNonNull(contentType, Data.nullOf(String.class));
            if (!Objects.equals(this.contentType, tmp)) {
                this.modifiedFields.add((Object)Storage.BlobField.CONTENT_TYPE);
            }
            this.contentType = tmp;
            return this;
        }

        @Override
        public Builder setContentDisposition(String contentDisposition) {
            String tmp = MoreObjects.firstNonNull(contentDisposition, Data.nullOf(String.class));
            if (!Objects.equals(this.contentDisposition, tmp)) {
                this.modifiedFields.add((Object)Storage.BlobField.CONTENT_DISPOSITION);
            }
            this.contentDisposition = tmp;
            return this;
        }

        @Override
        public Builder setContentLanguage(String contentLanguage) {
            String tmp = MoreObjects.firstNonNull(contentLanguage, Data.nullOf(String.class));
            if (!Objects.equals(this.contentLanguage, tmp)) {
                this.modifiedFields.add((Object)Storage.BlobField.CONTENT_LANGUAGE);
            }
            this.contentLanguage = tmp;
            return this;
        }

        @Override
        public Builder setContentEncoding(String contentEncoding) {
            String tmp = MoreObjects.firstNonNull(contentEncoding, Data.nullOf(String.class));
            if (!Objects.equals(this.contentEncoding, tmp)) {
                this.modifiedFields.add((Object)Storage.BlobField.CONTENT_ENCODING);
            }
            this.contentEncoding = tmp;
            return this;
        }

        @Override
        Builder setComponentCount(Integer componentCount) {
            this.componentCount = componentCount;
            return this;
        }

        @Override
        public Builder setCacheControl(String cacheControl) {
            String tmp = MoreObjects.firstNonNull(cacheControl, Data.nullOf(String.class));
            if (!Objects.equals(this.cacheControl, tmp)) {
                this.modifiedFields.add((Object)Storage.BlobField.CACHE_CONTROL);
            }
            this.cacheControl = tmp;
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            if (!Objects.equals(this.acl, acl)) {
                this.modifiedFields.add((Object)Storage.BlobField.ACL);
            }
            this.acl = acl != null ? (acl instanceof ImmutableList ? acl : ImmutableList.copyOf(acl)) : null;
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            if (!Objects.equals(this.owner, owner)) {
                this.modifiedFields.add((Object)Storage.BlobField.OWNER);
            }
            this.owner = owner;
            return this;
        }

        @Override
        Builder setSize(Long size) {
            this.size = size;
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            if (!Objects.equals(this.etag, etag)) {
                this.modifiedFields.add((Object)Storage.BlobField.ETAG);
            }
            this.etag = etag;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setMd5(String md5) {
            String tmp = MoreObjects.firstNonNull(md5, Data.nullOf(String.class));
            if (!Objects.equals(this.md5, tmp)) {
                this.modifiedFields.add((Object)Storage.BlobField.MD5HASH);
            }
            this.md5 = tmp;
            return this;
        }

        @Override
        public Builder setMd5FromHexString(String md5HexString) {
            if (md5HexString == null) {
                return this;
            }
            if (md5HexString.length() % 2 != 0) {
                throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
            }
            String md5HexStringLower = md5HexString.toLowerCase();
            ByteBuffer md5ByteBuffer = ByteBuffer.allocate(md5HexStringLower.length() / 2);
            for (int charIndex = 0; charIndex < md5HexStringLower.length(); charIndex += 2) {
                int higherOrderBits = hexDecimalValues.indexOf(md5HexStringLower.charAt(charIndex));
                int lowerOrderBits = hexDecimalValues.indexOf(md5HexStringLower.charAt(charIndex + 1));
                if (higherOrderBits == -1 || lowerOrderBits == -1) {
                    throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
                }
                md5ByteBuffer.put((byte)(higherOrderBits << 4 | lowerOrderBits));
            }
            return this.setMd5(BaseEncoding.base64().encode(md5ByteBuffer.array()));
        }

        @Override
        public Builder setCrc32c(String crc32c) {
            String tmp = MoreObjects.firstNonNull(crc32c, Data.nullOf(String.class));
            if (!Objects.equals(this.crc32c, tmp)) {
                this.modifiedFields.add((Object)Storage.BlobField.CRC32C);
            }
            this.crc32c = tmp;
            return this;
        }

        @Override
        @Deprecated
        public Builder setCustomTime(Long customTime) {
            return this.setCustomTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(customTime));
        }

        @Override
        public Builder setCustomTimeOffsetDateTime(OffsetDateTime customTime) {
            if (!Objects.equals(this.customTime, customTime)) {
                this.modifiedFields.add((Object)Storage.BlobField.CUSTOM_TIME);
            }
            this.customTime = customTime;
            return this;
        }

        @Override
        public Builder setCrc32cFromHexString(String crc32cHexString) {
            if (crc32cHexString == null) {
                return this;
            }
            if (crc32cHexString.length() % 2 != 0) {
                throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
            }
            String crc32cHexStringLower = crc32cHexString.toLowerCase();
            ByteBuffer crc32cByteBuffer = ByteBuffer.allocate(crc32cHexStringLower.length() / 2);
            for (int charIndex = 0; charIndex < crc32cHexStringLower.length(); charIndex += 2) {
                int higherOrderBits = hexDecimalValues.indexOf(crc32cHexStringLower.charAt(charIndex));
                int lowerOrderBits = hexDecimalValues.indexOf(crc32cHexStringLower.charAt(charIndex + 1));
                if (higherOrderBits == -1 || lowerOrderBits == -1) {
                    throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
                }
                crc32cByteBuffer.put((byte)(higherOrderBits << 4 | lowerOrderBits));
            }
            return this.setCrc32c(BaseEncoding.base64().encode(crc32cByteBuffer.array()));
        }

        @Override
        Builder setMediaLink(String mediaLink) {
            this.mediaLink = mediaLink;
            return this;
        }

        @Override
        public Builder setMetadata(@Nullable Map<@NonNull String, @Nullable String> metadata) {
            Map<String, String> left = this.metadata;
            Map<String, String> right = metadata;
            if (!Objects.equals(left, right)) {
                Utils.diffMaps(Storage.BlobField.METADATA, left, right, this.modifiedFields::add);
                this.metadata = right != null ? new HashMap<String, String>(right) : (Map)Data.nullOf(ImmutableEmptyMap.class);
            }
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            if (!Objects.equals(this.storageClass, storageClass)) {
                this.modifiedFields.add((Object)Storage.BlobField.STORAGE_CLASS);
            }
            this.storageClass = storageClass;
            return this;
        }

        @Override
        @Deprecated
        public Builder setTimeStorageClassUpdated(Long timeStorageClassUpdated) {
            return this.setTimeStorageClassUpdatedOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(timeStorageClassUpdated));
        }

        @Override
        public Builder setTimeStorageClassUpdatedOffsetDateTime(OffsetDateTime timeStorageClassUpdated) {
            if (!Objects.equals(this.timeStorageClassUpdated, timeStorageClassUpdated)) {
                this.modifiedFields.add((Object)Storage.BlobField.TIME_STORAGE_CLASS_UPDATED);
            }
            this.timeStorageClassUpdated = timeStorageClassUpdated;
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.metageneration = metageneration;
            return this;
        }

        @Override
        @Deprecated
        Builder setDeleteTime(Long deleteTime) {
            return this.setDeleteTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(deleteTime));
        }

        @Override
        Builder setDeleteTimeOffsetDateTime(OffsetDateTime deleteTime) {
            if (!Objects.equals(this.deleteTime, deleteTime)) {
                this.modifiedFields.add((Object)Storage.BlobField.TIME_DELETED);
            }
            this.deleteTime = deleteTime;
            return this;
        }

        @Override
        Builder setUpdateTime(Long updateTime) {
            return this.setUpdateTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(updateTime));
        }

        @Override
        Builder setUpdateTimeOffsetDateTime(OffsetDateTime updateTime) {
            if (!Objects.equals(this.updateTime, updateTime)) {
                this.modifiedFields.add((Object)Storage.BlobField.UPDATED);
            }
            this.updateTime = updateTime;
            return this;
        }

        @Override
        @Deprecated
        Builder setCreateTime(Long createTime) {
            return this.setCreateTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(createTime));
        }

        @Override
        Builder setCreateTimeOffsetDateTime(OffsetDateTime createTime) {
            if (!Objects.equals(this.createTime, createTime)) {
                this.modifiedFields.add((Object)Storage.BlobField.TIME_CREATED);
            }
            this.createTime = createTime;
            return this;
        }

        @Override
        Builder setIsDirectory(boolean isDirectory) {
            this.isDirectory = isDirectory;
            return this;
        }

        @Override
        Builder setCustomerEncryption(CustomerEncryption customerEncryption) {
            if (!Objects.equals(this.customerEncryption, customerEncryption)) {
                this.modifiedFields.add((Object)Storage.BlobField.CUSTOMER_ENCRYPTION);
            }
            this.customerEncryption = customerEncryption;
            return this;
        }

        @Override
        Builder setKmsKeyName(String kmsKeyName) {
            if (!Objects.equals(this.kmsKeyName, kmsKeyName)) {
                this.modifiedFields.add((Object)Storage.BlobField.KMS_KEY_NAME);
            }
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        @Override
        public Builder setEventBasedHold(Boolean eventBasedHold) {
            if (!Objects.equals(this.eventBasedHold, eventBasedHold)) {
                this.modifiedFields.add((Object)Storage.BlobField.EVENT_BASED_HOLD);
            }
            this.eventBasedHold = eventBasedHold;
            return this;
        }

        @Override
        public Builder setTemporaryHold(Boolean temporaryHold) {
            if (!Objects.equals(this.temporaryHold, temporaryHold)) {
                this.modifiedFields.add((Object)Storage.BlobField.TEMPORARY_HOLD);
            }
            this.temporaryHold = temporaryHold;
            return this;
        }

        @Override
        @Deprecated
        Builder setRetentionExpirationTime(Long retentionExpirationTime) {
            return this.setRetentionExpirationTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(retentionExpirationTime));
        }

        @Override
        Builder setRetentionExpirationTimeOffsetDateTime(OffsetDateTime retentionExpirationTime) {
            if (!Objects.equals(this.retentionExpirationTime, retentionExpirationTime)) {
                this.modifiedFields.add((Object)Storage.BlobField.RETENTION_EXPIRATION_TIME);
            }
            this.retentionExpirationTime = retentionExpirationTime;
            return this;
        }

        @Override
        public BlobInfo build() {
            Preconditions.checkNotNull(this.blobId);
            return new BlobInfo(this);
        }

        @Override
        BlobId getBlobId() {
            return this.blobId;
        }

        @Override
        Builder clearBlobId() {
            this.blobId = null;
            return this;
        }

        @Override
        Builder clearGeneratedId() {
            this.generatedId = null;
            return this;
        }

        @Override
        Builder clearContentType() {
            this.contentType = null;
            return this;
        }

        @Override
        Builder clearContentEncoding() {
            this.contentEncoding = null;
            return this;
        }

        @Override
        Builder clearContentDisposition() {
            this.contentDisposition = null;
            return this;
        }

        @Override
        Builder clearContentLanguage() {
            this.contentLanguage = null;
            return this;
        }

        @Override
        Builder clearComponentCount() {
            this.componentCount = null;
            return this;
        }

        @Override
        Builder clearCacheControl() {
            this.cacheControl = null;
            return this;
        }

        @Override
        Builder clearAcl() {
            this.acl = null;
            return this;
        }

        @Override
        Builder clearOwner() {
            this.owner = null;
            return this;
        }

        @Override
        Builder clearSize() {
            this.size = null;
            return this;
        }

        @Override
        Builder clearEtag() {
            this.etag = null;
            return this;
        }

        @Override
        Builder clearSelfLink() {
            this.selfLink = null;
            return this;
        }

        @Override
        Builder clearMd5() {
            this.md5 = null;
            return this;
        }

        @Override
        Builder clearCrc32c() {
            this.crc32c = null;
            return this;
        }

        @Override
        Builder clearCustomTime() {
            this.customTime = null;
            return this;
        }

        @Override
        Builder clearMediaLink() {
            this.mediaLink = null;
            return this;
        }

        @Override
        Builder clearMetadata() {
            this.metadata = null;
            return this;
        }

        @Override
        Builder clearMetageneration() {
            this.metageneration = null;
            return this;
        }

        @Override
        Builder clearDeleteTime() {
            this.deleteTime = null;
            return this;
        }

        @Override
        Builder clearUpdateTime() {
            this.updateTime = null;
            return this;
        }

        @Override
        Builder clearCreateTime() {
            this.createTime = null;
            return this;
        }

        @Override
        Builder clearIsDirectory() {
            this.isDirectory = null;
            return this;
        }

        @Override
        Builder clearCustomerEncryption() {
            this.customerEncryption = null;
            return this;
        }

        @Override
        Builder clearStorageClass() {
            this.storageClass = null;
            return this;
        }

        @Override
        Builder clearTimeStorageClassUpdated() {
            this.timeStorageClassUpdated = null;
            return this;
        }

        @Override
        Builder clearKmsKeyName() {
            this.kmsKeyName = null;
            return this;
        }

        @Override
        Builder clearEventBasedHold() {
            this.eventBasedHold = null;
            return this;
        }

        @Override
        Builder clearTemporaryHold() {
            this.temporaryHold = null;
            return this;
        }

        @Override
        Builder clearRetentionExpirationTime() {
            this.retentionExpirationTime = null;
            return this;
        }
    }

    public static abstract class Builder {
        public abstract Builder setBlobId(BlobId var1);

        abstract Builder setGeneratedId(String var1);

        public abstract Builder setContentType(String var1);

        public abstract Builder setContentDisposition(String var1);

        public abstract Builder setContentLanguage(String var1);

        public abstract Builder setContentEncoding(String var1);

        abstract Builder setComponentCount(Integer var1);

        public abstract Builder setCacheControl(String var1);

        public abstract Builder setAcl(List<Acl> var1);

        abstract Builder setOwner(Acl.Entity var1);

        abstract Builder setSize(Long var1);

        abstract Builder setEtag(String var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setMd5(String var1);

        public abstract Builder setMd5FromHexString(String var1);

        public abstract Builder setCrc32c(String var1);

        @Deprecated
        public Builder setCustomTime(Long customTime) {
            throw new UnsupportedOperationException("Override setCustomTime with your own implementation, or use com.google.cloud.storage.Blob.");
        }

        public Builder setCustomTimeOffsetDateTime(OffsetDateTime customTime) {
            return this.setCustomTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(customTime));
        }

        public abstract Builder setCrc32cFromHexString(String var1);

        abstract Builder setMediaLink(String var1);

        public abstract Builder setStorageClass(StorageClass var1);

        @Deprecated
        public Builder setTimeStorageClassUpdated(Long timeStorageClassUpdated) {
            throw new UnsupportedOperationException("Override setTimeStorageClassUpdated with your own implementation, or use com.google.cloud.storage.Blob.");
        }

        public Builder setTimeStorageClassUpdatedOffsetDateTime(OffsetDateTime timeStorageClassUpdated) {
            return this.setTimeStorageClassUpdated((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(timeStorageClassUpdated));
        }

        public abstract Builder setMetadata(@Nullable Map<@NonNull String, @Nullable String> var1);

        abstract Builder setMetageneration(Long var1);

        @Deprecated
        abstract Builder setDeleteTime(Long var1);

        Builder setDeleteTimeOffsetDateTime(OffsetDateTime deleteTime) {
            return this.setDeleteTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(deleteTime));
        }

        @Deprecated
        abstract Builder setUpdateTime(Long var1);

        Builder setUpdateTimeOffsetDateTime(OffsetDateTime updateTime) {
            return this.setUpdateTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(updateTime));
        }

        @Deprecated
        abstract Builder setCreateTime(Long var1);

        Builder setCreateTimeOffsetDateTime(OffsetDateTime createTime) {
            return this.setCreateTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(createTime));
        }

        abstract Builder setIsDirectory(boolean var1);

        abstract Builder setCustomerEncryption(CustomerEncryption var1);

        abstract Builder setKmsKeyName(String var1);

        @BetaApi
        public abstract Builder setEventBasedHold(Boolean var1);

        @BetaApi
        public abstract Builder setTemporaryHold(Boolean var1);

        @BetaApi
        @Deprecated
        abstract Builder setRetentionExpirationTime(Long var1);

        @BetaApi
        Builder setRetentionExpirationTimeOffsetDateTime(OffsetDateTime retentionExpirationTime) {
            return this.setRetentionExpirationTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(retentionExpirationTime));
        }

        public abstract BlobInfo build();

        abstract BlobId getBlobId();

        abstract Builder clearBlobId();

        abstract Builder clearGeneratedId();

        abstract Builder clearContentType();

        abstract Builder clearContentEncoding();

        abstract Builder clearContentDisposition();

        abstract Builder clearContentLanguage();

        abstract Builder clearComponentCount();

        abstract Builder clearCacheControl();

        abstract Builder clearAcl();

        abstract Builder clearOwner();

        abstract Builder clearSize();

        abstract Builder clearEtag();

        abstract Builder clearSelfLink();

        abstract Builder clearMd5();

        abstract Builder clearCrc32c();

        abstract Builder clearCustomTime();

        abstract Builder clearMediaLink();

        abstract Builder clearMetadata();

        abstract Builder clearMetageneration();

        abstract Builder clearDeleteTime();

        abstract Builder clearUpdateTime();

        abstract Builder clearCreateTime();

        abstract Builder clearIsDirectory();

        abstract Builder clearCustomerEncryption();

        abstract Builder clearStorageClass();

        abstract Builder clearTimeStorageClassUpdated();

        abstract Builder clearKmsKeyName();

        abstract Builder clearEventBasedHold();

        abstract Builder clearTemporaryHold();

        abstract Builder clearRetentionExpirationTime();
    }

    public static final class ImmutableEmptyMap<K, V>
    extends AbstractMap<K, V> {
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return ImmutableSet.of();
        }
    }
}

