/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class NumericToTimestampCastRule
extends AbstractExpressionCodeGeneratorCastRule<Number, TimestampData> {
    static final NumericToTimestampCastRule INSTANCE = new NumericToTimestampCastRule();

    private NumericToTimestampCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.NUMERIC).target(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).target(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            throw new ValidationException("The cast from NUMERIC type to TIMESTAMP type is not allowed. It's recommended to use TO_TIMESTAMP(FROM_UNIXTIME(numeric_col)) instead, note the numeric is in seconds.");
        }
        if (targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            throw new ValidationException("The cast from NUMERIC type to TIMESTAMP_LTZ type is not allowed. It's recommended to use TO_TIMESTAMP_LTZ(numeric_col, precision) instead.");
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }
}

