/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.calcite.FlinkCalciteSqlValidator;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.SqlRewriterUtils;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.SchemaBuilderUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import scala.Function0;

public class MergeTableAsUtil {
    private final SqlValidator validator;
    private final Function<SqlNode, String> escapeExpression;
    private final DataTypeFactory dataTypeFactory;

    public MergeTableAsUtil(SqlValidator validator, Function<SqlNode, String> escapeExpression, DataTypeFactory dataTypeFactory) {
        this.validator = validator;
        this.escapeExpression = escapeExpression;
        this.dataTypeFactory = dataTypeFactory;
    }

    public MergeTableAsUtil(SqlNodeConverter.ConvertContext context) {
        this(context.getSqlValidator(), context::toQuotedSqlString, context.getCatalogManager().getDataTypeFactory());
    }

    public PlannerQueryOperation maybeRewriteQuery(CatalogManager catalogManager, FlinkPlannerImpl flinkPlanner, PlannerQueryOperation origQueryOperation, SqlNode origQueryNode, ResolvedCatalogTable sinkTable) {
        FlinkCalciteSqlValidator sqlValidator = flinkPlanner.getOrCreateSqlValidator();
        SqlRewriterUtils rewriterUtils = new SqlRewriterUtils(sqlValidator);
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)sqlValidator.getTypeFactory();
        RowType sinkRowType = (RowType)sinkTable.getResolvedSchema().toSinkRowDataType().getLogicalType();
        Map sourceFields = IntStream.range(0, origQueryOperation.getResolvedSchema().getColumnNames().size()).boxed().collect(Collectors.toMap(origQueryOperation.getResolvedSchema().getColumnNames()::get, Function.identity()));
        LinkedHashMap<Integer, SqlNode> assignedFields = new LinkedHashMap<Integer, SqlNode>();
        ArrayList<Object> targetPositions = new ArrayList<Object>();
        int pos = -1;
        for (RowType.RowField targetField : sinkRowType.getFields()) {
            ++pos;
            if (!sourceFields.containsKey(targetField.getName())) {
                if (!targetField.getType().isNullable()) {
                    throw new ValidationException("Column '" + targetField.getName() + "' has no default value and does not allow NULLs.");
                }
                assignedFields.put(pos, rewriterUtils.maybeCast(SqlLiteral.createNull(SqlParserPos.ZERO), typeFactory.createUnknownType(), typeFactory.createFieldTypeFromLogicalType(targetField.getType()), typeFactory));
                continue;
            }
            targetPositions.add(sourceFields.get(targetField.getName()));
        }
        SqlCall newSelect = rewriterUtils.rewriteCall(rewriterUtils, sqlValidator, (SqlCall)origQueryNode, typeFactory.buildRelNodeRowType(sinkRowType), assignedFields, targetPositions, (Function0<String>)((Function0)() -> "Unsupported node type " + String.valueOf((Object)origQueryNode.getKind())));
        return (PlannerQueryOperation)SqlNodeToOperationConversion.convert(flinkPlanner, catalogManager, newSelect).orElseThrow(() -> new TableException("Unsupported node type " + newSelect.getClass().getSimpleName()));
    }

    public Schema mergeSchemas(SqlNodeList sqlColumnList, @Nullable SqlWatermark sqlWatermark, List<SqlTableConstraint> sqlTableConstraints, ResolvedSchema sourceSchema) {
        SchemaBuilder schemaBuilder = new SchemaBuilder((FlinkTypeFactory)this.validator.getTypeFactory(), this.dataTypeFactory, this.validator, this.escapeExpression);
        schemaBuilder.mergeColumns(sqlColumnList, Schema.newBuilder().fromResolvedSchema(sourceSchema).build().getColumns());
        if (sqlWatermark != null) {
            schemaBuilder.setWatermark(sqlWatermark);
        }
        Optional<SqlTableConstraint> primaryKey = sqlTableConstraints.stream().filter(SqlTableConstraint::isPrimaryKey).findAny();
        primaryKey.ifPresent(schemaBuilder::setPrimaryKey);
        return schemaBuilder.build();
    }

    public Schema reorderSchema(SqlNodeList sqlColumnList, ResolvedSchema sourceSchema) {
        SchemaBuilder schemaBuilder = new SchemaBuilder((FlinkTypeFactory)this.validator.getTypeFactory(), this.dataTypeFactory, this.validator, this.escapeExpression);
        schemaBuilder.reorderColumns(sqlColumnList, Schema.newBuilder().fromResolvedSchema(sourceSchema).build().getColumns());
        return schemaBuilder.build();
    }

    private static class SchemaBuilder
    extends SchemaBuilderUtil {
        private final Map<String, RelDataType> regularAndMetadataFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        private final Map<String, RelDataType> computeFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        FlinkTypeFactory typeFactory;

        SchemaBuilder(FlinkTypeFactory typeFactory, DataTypeFactory dataTypeFactory, SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions) {
            super(sqlValidator, escapeExpressions, dataTypeFactory);
            this.typeFactory = typeFactory;
        }

        private void mergeColumns(List<SqlNode> sinkCols, List<Schema.UnresolvedColumn> sourceCols) {
            LinkedHashMap<String, Schema.UnresolvedPhysicalColumn> sinkSchemaCols = new LinkedHashMap<String, Schema.UnresolvedPhysicalColumn>();
            LinkedHashMap<String, Schema.UnresolvedColumn> sourceSchemaCols = new LinkedHashMap<String, Schema.UnresolvedColumn>();
            this.populateColumnsFromSource(sourceCols, sourceSchemaCols);
            int sinkColumnPos = -1;
            for (SqlNode sinkColumn : sinkCols) {
                Schema.UnresolvedPhysicalColumn unresolvedSinkColumn;
                String name = ((SqlTableColumn)sinkColumn).getName().getSimple();
                ++sinkColumnPos;
                if (sinkSchemaCols.containsKey(name)) {
                    throw new ValidationException(String.format("A column named '%s' already exists in the schema. ", name));
                }
                if (sinkColumn instanceof SqlTableColumn.SqlRegularColumn) {
                    unresolvedSinkColumn = this.toUnresolvedPhysicalColumn((SqlTableColumn.SqlRegularColumn)sinkColumn);
                    this.regularAndMetadataFieldNamesToTypes.put(name, this.toRelDataType(((SqlTableColumn.SqlRegularColumn)sinkColumn).getType()));
                } else if (sinkColumn instanceof SqlTableColumn.SqlMetadataColumn) {
                    unresolvedSinkColumn = this.toUnresolvedMetadataColumn((SqlTableColumn.SqlMetadataColumn)sinkColumn);
                    this.regularAndMetadataFieldNamesToTypes.put(name, this.toRelDataType(((SqlTableColumn.SqlMetadataColumn)sinkColumn).getType()));
                } else if (sinkColumn instanceof SqlTableColumn.SqlComputedColumn) {
                    SqlNode validatedExpr = this.sqlValidator.validateParameterizedExpression(((SqlTableColumn.SqlComputedColumn)sinkColumn).getExpr(), this.regularAndMetadataFieldNamesToTypes);
                    unresolvedSinkColumn = this.toUnresolvedComputedColumn((SqlTableColumn.SqlComputedColumn)sinkColumn, validatedExpr);
                    this.computeFieldNamesToTypes.put(name, this.sqlValidator.getValidatedNodeType(validatedExpr));
                } else {
                    throw new ValidationException("Unsupported column type: " + String.valueOf(sinkColumn));
                }
                if (sourceSchemaCols.containsKey(name)) {
                    this.validateImplicitCastCompatibility(name, sinkColumnPos, (Schema.UnresolvedColumn)sourceSchemaCols.get(name), (Schema.UnresolvedColumn)unresolvedSinkColumn);
                    sourceSchemaCols.put(name, (Schema.UnresolvedColumn)unresolvedSinkColumn);
                    continue;
                }
                sinkSchemaCols.put(name, unresolvedSinkColumn);
            }
            this.columns.clear();
            this.columns.putAll(sinkSchemaCols);
            this.columns.putAll(sourceSchemaCols);
        }

        private void reorderColumns(List<SqlNode> identifiers, List<Schema.UnresolvedColumn> sourceCols) {
            LinkedHashMap<String, Schema.UnresolvedColumn> sinkSchemaCols = new LinkedHashMap<String, Schema.UnresolvedColumn>();
            LinkedHashMap<String, Schema.UnresolvedColumn> sourceSchemaCols = new LinkedHashMap<String, Schema.UnresolvedColumn>();
            this.populateColumnsFromSource(sourceCols, sourceSchemaCols);
            if (identifiers.size() != sourceCols.size()) {
                throw new ValidationException("The number of columns in the column list must match the number of columns in the source schema.");
            }
            for (SqlNode identifier : identifiers) {
                String name = ((SqlIdentifier)identifier).getSimple();
                if (!sourceSchemaCols.containsKey(name)) {
                    throw new ValidationException(String.format("Column '%s' not found in the source schema. ", name));
                }
                sinkSchemaCols.put(name, (Schema.UnresolvedColumn)sourceSchemaCols.get(name));
            }
            this.columns.clear();
            this.columns.putAll(sinkSchemaCols);
        }

        private void populateColumnsFromSource(List<Schema.UnresolvedColumn> columns, Map<String, Schema.UnresolvedColumn> schemaCols) {
            for (Schema.UnresolvedColumn column : columns) {
                if (!(column instanceof Schema.UnresolvedPhysicalColumn)) {
                    throw new ValidationException("Computed columns and metadata columns are not expected in the source schema.");
                }
                if (schemaCols.containsKey(column.getName())) {
                    throw new ValidationException(String.format("A column named '%s' already exists in the schema. ", column.getName()));
                }
                String name = column.getName();
                LogicalType sourceColumnType = this.getLogicalType((Schema.UnresolvedPhysicalColumn)column);
                schemaCols.put(column.getName(), column);
                this.regularAndMetadataFieldNamesToTypes.put(name, this.typeFactory.createFieldTypeFromLogicalType(sourceColumnType));
            }
        }

        private void validateImplicitCastCompatibility(String columnName, int columnPos, Schema.UnresolvedColumn sourceColumn, Schema.UnresolvedColumn sinkColumn) {
            LogicalType sinkColumnType;
            if (sinkColumn instanceof Schema.UnresolvedPhysicalColumn) {
                sinkColumnType = this.getLogicalType((Schema.UnresolvedPhysicalColumn)sinkColumn);
            } else if (sinkColumn instanceof Schema.UnresolvedMetadataColumn) {
                if (((Schema.UnresolvedMetadataColumn)sinkColumn).isVirtual()) {
                    throw new ValidationException(String.format("A column named '%s' already exists in the source schema. Virtual metadata columns cannot overwrite columns from source.", columnName));
                }
                sinkColumnType = this.getLogicalType((Schema.UnresolvedMetadataColumn)sinkColumn);
            } else {
                throw new ValidationException(String.format("A column named '%s' already exists in the source schema. Computed columns cannot overwrite columns from source.", columnName));
            }
            LogicalType sourceColumnType = this.getLogicalType((Schema.UnresolvedPhysicalColumn)sourceColumn);
            if (!LogicalTypeCasts.supportsImplicitCast((LogicalType)sourceColumnType, (LogicalType)sinkColumnType)) {
                throw new ValidationException(String.format("Incompatible types for sink column '%s' at position %d. The source column has type '%s', while the target column has type '%s'.", columnName, columnPos, sourceColumnType, sinkColumnType));
            }
        }

        private void setWatermark(SqlWatermark sqlWatermark) {
            LinkedHashMap accessibleFieldNamesToTypes = new LinkedHashMap(){
                {
                    this.putAll(regularAndMetadataFieldNamesToTypes);
                    this.putAll(computeFieldNamesToTypes);
                }
            };
            this.addWatermarks(Collections.singletonList(sqlWatermark), accessibleFieldNamesToTypes, false);
        }
    }
}

