/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.List;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropDistribution;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;

public class SqlAlterTableDropDistributionConverter
extends AbstractAlterTableConverter<SqlAlterTableDropDistribution> {
    @Override
    protected Operation convertToOperation(SqlAlterTableDropDistribution sqlAlterTable, ResolvedCatalogTable resolvedCatalogTable, SqlNodeConverter.ConvertContext context) {
        ObjectIdentifier tableIdentifier = this.getIdentifier(sqlAlterTable, context);
        if (resolvedCatalogTable.getDistribution().isEmpty()) {
            throw new ValidationException(String.format("Table %s does not have a distribution to drop.", tableIdentifier));
        }
        List<TableChange.DropDistribution> tableChanges = List.of(TableChange.dropDistribution());
        return this.buildAlterTableChangeOperation(sqlAlterTable, tableChanges, resolvedCatalogTable.getUnresolvedSchema(), resolvedCatalogTable, context.getCatalogManager());
    }

    @Override
    protected TableDistribution getTableDistribution(SqlAlterTable alterTable, ResolvedCatalogTable oldTable) {
        return null;
    }
}

