/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CompiledPlanSerdeUtil;

@Internal
final class ResolvedSchemaJsonSerializer
extends StdSerializer<ResolvedSchema> {
    private static final long serialVersionUID = 1L;
    static final String COLUMNS = "columns";
    static final String WATERMARK_SPECS = "watermarkSpecs";
    static final String PRIMARY_KEY = "primaryKey";
    static final String INDEXES = "indexes";

    ResolvedSchemaJsonSerializer() {
        super(ResolvedSchema.class);
    }

    public void serialize(ResolvedSchema resolvedSchema, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        serializerProvider.defaultSerializeField(COLUMNS, (Object)resolvedSchema.getColumns(), jsonGenerator);
        CompiledPlanSerdeUtil.serializeListIfNotEmpty(jsonGenerator, WATERMARK_SPECS, resolvedSchema.getWatermarkSpecs(), serializerProvider);
        CompiledPlanSerdeUtil.serializeOptionalField(jsonGenerator, PRIMARY_KEY, resolvedSchema.getPrimaryKey(), serializerProvider);
        CompiledPlanSerdeUtil.serializeListIfNotEmpty(jsonGenerator, INDEXES, resolvedSchema.getIndexes(), serializerProvider);
        jsonGenerator.writeEndObject();
    }
}

