/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup.keyordered;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;

public class RecordsBuffer<ELEMENT, KEY> {
    private final Map<KEY, Deque<ELEMENT>> finishedBuffer;
    private final Map<KEY, ELEMENT> activeBuffer = new ConcurrentHashMap<KEY, ELEMENT>();
    private final Map<KEY, Deque<ELEMENT>> blockingBuffer;
    private int blockingSize = 0;
    private int finishSize = 0;

    public RecordsBuffer() {
        this.finishedBuffer = new ConcurrentHashMap<KEY, Deque<ELEMENT>>();
        this.blockingBuffer = new ConcurrentHashMap<KEY, Deque<ELEMENT>>();
    }

    public void enqueueRecord(KEY key, ELEMENT record) {
        this.blockingBuffer.computeIfAbsent(key, k -> new LinkedList()).add(record);
        ++this.blockingSize;
    }

    public Optional<ELEMENT> pop(KEY key) {
        if (!this.blockingBuffer.containsKey(key)) {
            return Optional.empty();
        }
        ELEMENT element = this.blockingBuffer.get(key).poll();
        if (element == null) {
            return Optional.empty();
        }
        --this.blockingSize;
        if (this.blockingBuffer.get(key).isEmpty()) {
            this.blockingBuffer.remove(key);
        }
        this.activeBuffer.put(key, element);
        return Optional.of(element);
    }

    public void finish(KEY key, ELEMENT element) {
        this.finishedBuffer.computeIfAbsent(key, k -> new LinkedList()).add(element);
        ++this.finishSize;
        Preconditions.checkState((boolean)this.activeBuffer.containsKey(key));
        this.activeBuffer.remove(key);
    }

    public void output(KEY key, ELEMENT element) {
        Preconditions.checkState((boolean)this.finishedBuffer.containsKey(key));
        this.finishedBuffer.get(key).remove(element);
        --this.finishSize;
        if (this.finishedBuffer.get(key).isEmpty()) {
            this.finishedBuffer.remove(key);
        }
    }

    public Map<KEY, Deque<ELEMENT>> pendingElements() {
        HashMap mergedMap = new HashMap();
        this.finishedBuffer.forEach((key, value) -> mergedMap.merge(key, value, (existingValue, newValue) -> {
            existingValue.addAll(newValue);
            return existingValue;
        }));
        this.activeBuffer.forEach((key, value) -> mergedMap.computeIfAbsent(key, k -> new ArrayDeque()).push(value));
        this.blockingBuffer.forEach((key, value) -> mergedMap.merge(key, value, (existingValue, newValue) -> {
            existingValue.addAll(newValue);
            return existingValue;
        }));
        return mergedMap;
    }

    public String sizeToString() {
        int finishSize = 0;
        for (Deque<ELEMENT> deque : this.finishedBuffer.values()) {
            finishSize += deque.size();
        }
        int activeSize = this.activeBuffer.size();
        int blockingSize = this.blockingBuffer.size();
        for (Deque<ELEMENT> deque : this.blockingBuffer.values()) {
            blockingSize += deque.size();
        }
        return "finished buffer size = " + finishSize + " active buffer size = " + activeSize + " blocking buffer size = " + blockingSize;
    }

    public void close() {
        this.finishedBuffer.clear();
        this.activeBuffer.clear();
        this.blockingBuffer.clear();
    }

    public int getBlockingSize() {
        return this.blockingSize;
    }

    public int getActiveSize() {
        return this.activeBuffer.size();
    }

    public int getFinishSize() {
        return this.finishSize;
    }

    @VisibleForTesting
    public Map<KEY, Deque<ELEMENT>> getFinishedBuffer() {
        return this.finishedBuffer;
    }

    @VisibleForTesting
    public Map<KEY, ELEMENT> getActiveBuffer() {
        return this.activeBuffer;
    }

    @VisibleForTesting
    public Map<KEY, Deque<ELEMENT>> getBlockingBuffer() {
        return this.blockingBuffer;
    }
}

