/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.pooling;

import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.client.internal.Connection;

public class AvailableConnectionManager {
    private final Deque<Connection> connections = new ConcurrentLinkedDeque<Connection>();

    public Connection useFirst() {
        Connection connection;
        while (null != (connection = this.connections.pollFirst())) {
            if (!connection.activate()) continue;
            return connection;
        }
        return null;
    }

    public boolean remove(Connection connection) {
        return this.connections.remove(connection);
    }

    public Connection useFirst(Predicate<Connection> predicate) {
        EqualsWithPredicate equalsWithPredicate = new EqualsWithPredicate(predicate);
        while (this.connections.removeFirstOccurrence(equalsWithPredicate)) {
            Connection connection = equalsWithPredicate.getConnectionThatMatched();
            if (!connection.activate()) continue;
            if (predicate.test(connection)) {
                return connection;
            }
            this.addLast(connection, false);
        }
        return null;
    }

    public void addFirst(Connection connection, boolean accessed) {
        this.passivate(connection, accessed);
        this.connections.addFirst(connection);
    }

    public void addLast(Connection connection, boolean accessed) {
        this.passivate(connection, accessed);
        this.connections.addLast(connection);
    }

    private void passivate(Connection connection, boolean accessed) {
        if (connection.isActive()) {
            connection.passivate(accessed);
        }
    }

    @VisibleForTesting
    Deque<Connection> getDeque() {
        return this.connections;
    }

    private static class EqualsWithPredicate {
        private final Predicate<Connection> predicate;
        private Connection connectionThatMatched;

        EqualsWithPredicate(Predicate<Connection> predicate) {
            this.predicate = predicate;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection pooledConnection = (Connection)o;
            if (this.predicate.test(pooledConnection)) {
                this.connectionThatMatched = pooledConnection;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.predicate, this.connectionThatMatched);
        }

        public Connection getConnectionThatMatched() {
            return this.connectionThatMatched;
        }
    }
}

