/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.realizers;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.configuration.IndexType;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.runtime.IndexInfo;
import org.apache.logging.log4j.Logger;

public class IndexRealizer
implements ConfigurationRealizer<org.apache.geode.management.configuration.Index, IndexInfo> {
    @Immutable
    private static final Logger logger = LogService.getLogger();

    @Override
    public RealizationResult create(org.apache.geode.management.configuration.Index config, InternalCache cache) {
        QueryService queryService = cache.getQueryService();
        String indexName = config.getName();
        String indexedExpression = config.getExpression();
        String fromClause = config.getRegionPath();
        RealizationResult realizationResult = new RealizationResult();
        try {
            if (config.getIndexType() == IndexType.KEY) {
                queryService.createKeyIndex(indexName, indexedExpression, fromClause);
            } else {
                queryService.createIndex(indexName, indexedExpression, fromClause);
            }
            realizationResult.setSuccess(true);
            realizationResult.setMessage("Index " + indexName + " successfully created");
            return realizationResult;
        }
        catch (IndexExistsException | IndexNameConflictException e) {
            realizationResult.setSuccess(true);
            realizationResult.setMessage(e.getMessage());
        }
        catch (RegionNotFoundException e) {
            realizationResult.setSuccess(false);
            realizationResult.setMessage(e.getMessage());
        }
        catch (RuntimeException r) {
            logger.error(r.getMessage(), (Throwable)r);
            realizationResult.setSuccess(false);
            realizationResult.setMessage(r.getMessage());
        }
        return realizationResult;
    }

    @Override
    public IndexInfo get(org.apache.geode.management.configuration.Index config, InternalCache cache) {
        String regionName = config.getRegionName();
        String indexName = config.getName();
        if (regionName == null || indexName == null) {
            return null;
        }
        Region region = cache.getRegion("/" + regionName);
        if (region == null) {
            return null;
        }
        QueryService queryService = cache.getQueryService();
        Index index = queryService.getIndex(region, indexName);
        if (index == null) {
            return null;
        }
        return new IndexInfo();
    }

    @Override
    public RealizationResult update(org.apache.geode.management.configuration.Index config, InternalCache cache) {
        return null;
    }

    @Override
    public RealizationResult delete(org.apache.geode.management.configuration.Index config, InternalCache cache) {
        QueryService queryService = cache.getQueryService();
        RealizationResult realizationResult = new RealizationResult();
        Region region = cache.getRegion("/" + config.getRegionName());
        if (region == null) {
            realizationResult.setSuccess(false);
            realizationResult.setMessage("Region for index not found: " + config.getRegionName());
            return realizationResult;
        }
        Index index = queryService.getIndex(region, config.getName());
        if (index == null) {
            realizationResult.setSuccess(false);
            realizationResult.setMessage("Index not found for Region: " + config.getRegionName() + ", " + config.getName());
            return realizationResult;
        }
        try {
            queryService.removeIndex(index);
            realizationResult.setSuccess(true);
            realizationResult.setMessage("Index " + config.getName() + " successfully removed from " + config.getRegionName());
            return realizationResult;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            realizationResult.setSuccess(false);
            realizationResult.setMessage(e.getMessage());
            return realizationResult;
        }
    }
}

