/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class ModelHookDispatcher
implements ModelDispatcher {
    private final ModelDispatcher dispatcher;

    public ModelHookDispatcher(ModelDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        return this.dispatcher.listModels(namespace);
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        return this.dispatcher.getModel(ident);
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException {
        AuthorizationUtils.checkCurrentUser(ident.namespace().level(0), PrincipalUtils.getCurrentUserName());
        Model model = this.dispatcher.registerModel(ident, comment, properties);
        OwnerDispatcher ownerManager = GravitinoEnv.getInstance().ownerDispatcher();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.MODEL), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return model;
    }

    public boolean deleteModel(NameIdentifier ident) {
        return this.dispatcher.deleteModel(ident);
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        return this.dispatcher.listModelVersions(ident);
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        return this.dispatcher.getModelVersion(ident, version);
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        return this.dispatcher.getModelVersion(ident, alias);
    }

    public void linkModelVersion(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        this.dispatcher.linkModelVersion(ident, uri, aliases, comment, properties);
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        return this.dispatcher.deleteModelVersion(ident, version);
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        return this.dispatcher.deleteModelVersion(ident, alias);
    }

    public boolean modelExists(NameIdentifier ident) {
        return this.dispatcher.modelExists(ident);
    }

    public Model registerModel(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException, ModelVersionAliasesAlreadyExistException {
        AuthorizationUtils.checkCurrentUser(ident.namespace().level(0), PrincipalUtils.getCurrentUserName());
        Model model = this.dispatcher.registerModel(ident, uri, aliases, comment, properties);
        OwnerDispatcher ownerManager = GravitinoEnv.getInstance().ownerDispatcher();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.name(), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.MODEL), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return model;
    }

    public boolean modelVersionExists(NameIdentifier ident, int version) {
        return this.dispatcher.modelVersionExists(ident, version);
    }

    public boolean modelVersionExists(NameIdentifier ident, String alias) {
        return this.dispatcher.modelVersionExists(ident, alias);
    }

    public Model alterModel(NameIdentifier ident, ModelChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        return this.dispatcher.alterModel(ident, changes);
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, int version, ModelVersionChange ... changes) throws NoSuchModelException, NoSuchModelVersionException, IllegalArgumentException {
        return this.dispatcher.alterModelVersion(ident, version, changes);
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, String alias, ModelVersionChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        return this.dispatcher.alterModelVersion(ident, alias, changes);
    }
}

