/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import java.util.List;
import org.apache.gravitino.storage.relational.mapper.provider.base.TagMetadataObjectRelBaseSQLProvider;
import org.apache.ibatis.annotations.Param;

public class TagMetadataObjectRelPostgreSQLProvider
extends TagMetadataObjectRelBaseSQLProvider {
    @Override
    public String softDeleteTagMetadataObjectRelsByMetalakeAndTagName(String metalakeName, String tagName) {
        return "UPDATE tag_relation_meta te SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE te.tag_id IN (SELECT tm.tag_id FROM tag_meta tm WHERE tm.metalake_id IN (SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND tm.tag_name = #{tagName} AND tm.deleted_at = 0) AND te.deleted_at = 0";
    }

    @Override
    public String softDeleteTagMetadataObjectRelsByMetalakeId(Long metalakeId) {
        return "UPDATE tag_relation_meta te SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE EXISTS (SELECT * FROM tag_meta tm WHERE tm.metalake_id = #{metalakeId} AND tm.tag_id = te.tag_id AND tm.deleted_at = 0) AND te.deleted_at = 0";
    }

    @Override
    public String softDeleteTagMetadataObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return " UPDATE tag_relation_meta SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE metadata_object_id = #{metadataObjectId} AND deleted_at = 0 AND metadata_object_type = #{metadataObjectType}";
    }

    @Override
    public String softDeleteTagMetadataObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return " UPDATE tag_relation_meta tmt SET deleted_at =  floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE tmt.deleted_at = 0 AND EXISTS ( SELECT ct.catalog_id FROM catalog_meta ct WHERE ct.catalog_id = #{catalogId}  AND ct.catalog_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'CATALOG' UNION  SELECT st.catalog_id FROM schema_meta st WHERE st.catalog_id = #{catalogId} AND st.schema_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'SCHEMA' UNION  SELECT tt.catalog_id FROM topic_meta tt WHERE tt.catalog_id = #{catalogId} AND tt.topic_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TOPIC' UNION  SELECT tat.catalog_id FROM table_meta tat WHERE tat.catalog_id = #{catalogId} AND tat.table_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TABLE' UNION  SELECT ft.catalog_id FROM fileset_meta ft WHERE ft.catalog_id = #{catalogId}  AND ft.fileset_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'FILESET' UNION  SELECT cot.catalog_id FROM table_column_version_info cot WHERE cot.catalog_id = #{catalogId} AND cot.column_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'COLUMN' UNION  SELECT mt.catalog_id FROM model_meta mt WHERE mt.catalog_id = #{catalogId} AND mt.model_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'MODEL')";
    }

    @Override
    public String softDeleteTagMetadataObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return " UPDATE tag_relation_meta tmt SET deleted_at =  floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE tmt.deleted_at = 0 AND EXISTS ( SELECT st.schema_id FROM schema_meta st WHERE st.schema_id = #{schemaId} AND st.schema_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'SCHEMA' UNION  SELECT tt.schema_id FROM topic_meta tt WHERE tt.schema_id = #{schemaId} AND tt.topic_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TOPIC' UNION  SELECT tat.schema_id FROM table_meta tat WHERE tat.schema_id = #{schemaId} AND tat.table_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TABLE' UNION  SELECT ft.schema_id FROM fileset_meta ft WHERE ft.schema_id = #{schemaId} AND ft.fileset_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'FILESET' UNION  SELECT cot.schema_id FROM table_column_version_info cot WHERE cot.schema_id = #{schemaId} AND cot.column_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'COLUMN' UNION  SELECT mt.schema_id FROM model_meta mt WHERE mt.schema_id = #{schemaId} AND  mt.model_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'MODEL')";
    }

    @Override
    public String softDeleteTagMetadataObjectRelsByTableId(@Param(value="tableId") Long tableId) {
        return " UPDATE tag_relation_meta tmt SET deleted_at =  floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE tmt.deleted_at = 0 AND EXISTS ( SELECT tat.table_id FROM table_meta tat WHERE tat.table_id = #{tableId} AND  tat.table_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TABLE' UNION  SELECT cot.table_id FROM table_column_version_info cot WHERE cot.table_id = #{tableId} AND  cot.column_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'COLUMN')";
    }

    @Override
    public String batchDeleteTagMetadataObjectRelsByTagIdsAndMetadataObject(Long metadataObjectId, String metadataObjectType, List<Long> tagIds) {
        return "<script>UPDATE tag_relation_meta SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE tag_id IN <foreach item='tagId' collection='tagIds' open='(' separator=',' close=')'>#{tagId}</foreach> And metadata_object_id = #{metadataObjectId} AND metadata_object_type = #{metadataObjectType} AND deleted_at = 0</script>";
    }

    @Override
    public String listTagMetadataObjectRelsByMetalakeAndTagName(String metalakeName, String tagName) {
        return "SELECT te.tag_id as tagId, te.metadata_object_id as metadataObjectId, te.metadata_object_type as metadataObjectType, te.audit_info as auditInfo, te.current_version as currentVersion, te.last_version as lastVersion, te.deleted_at as deletedAt FROM tag_relation_meta te JOIN tag_meta tm ON te.tag_id = tm.tag_id JOIN metalake_meta mm ON tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.tag_name = #{tagName} AND te.deleted_at = 0 AND tm.deleted_at = 0 AND mm.deleted_at = 0";
    }

    @Override
    public String deleteTagEntityRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM tag_relation_meta WHERE id IN (SELECT id FROM tag_relation_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

