/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public interface OAuthConfig {
    public static final String OAUTH_CONFIG_PREFIX = "gravitino.authenticator.oauth.";
    public static final ConfigEntry<String> SERVICE_AUDIENCE = new ConfigBuilder("gravitino.authenticator.oauth.serviceAudience").doc("The audience name when Gravitino uses OAuth as the authenticator").version("0.3.0").stringConf().createWithDefault((Object)"GravitinoServer");
    public static final ConfigEntry<Long> ALLOW_SKEW_SECONDS = new ConfigBuilder("gravitino.authenticator.oauth.allowSkewSecs").doc("The JWT allows skew seconds when Gravitino uses OAuth as the authenticator").version("0.3.0").longConf().createWithDefault((Object)0L);
    public static final ConfigEntry<String> DEFAULT_SIGN_KEY = new ConfigBuilder("gravitino.authenticator.oauth.defaultSignKey").doc("The signing key of JWT when Gravitino uses OAuth as the authenticator").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> SIGNATURE_ALGORITHM_TYPE = new ConfigBuilder("gravitino.authenticator.oauth.signAlgorithmType").doc("The signature algorithm when Gravitino uses OAuth as the authenticator").version("0.3.0").stringConf().createWithDefault((Object)SignatureAlgorithm.RS256.name());
    public static final ConfigEntry<String> DEFAULT_SERVER_URI = new ConfigBuilder("gravitino.authenticator.oauth.serverUri").doc("The uri of the default OAuth server").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> DEFAULT_TOKEN_PATH = new ConfigBuilder("gravitino.authenticator.oauth.tokenPath").doc("The path for token of the default OAuth server").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
}

