/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.SchemaDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class SchemaResponse
extends BaseResponse {
    @JsonProperty(value="schema")
    private final SchemaDTO schema;

    public SchemaResponse(SchemaDTO schema) {
        super(0);
        this.schema = schema;
    }

    public SchemaResponse() {
        this.schema = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.schema != null ? 1 : 0) != 0, (Object)"schema must be non-null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.schema.name()), (Object)"schema 'name' must not be null and empty");
        Preconditions.checkArgument((this.schema.auditInfo() != null ? 1 : 0) != 0, (Object)"schema 'audit' must not be null");
    }

    public SchemaDTO getSchema() {
        return this.schema;
    }

    @Override
    public String toString() {
        return "SchemaResponse(schema=" + this.getSchema() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaResponse)) {
            return false;
        }
        SchemaResponse other = (SchemaResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaDTO this$schema = this.getSchema();
        SchemaDTO other$schema = other.getSchema();
        return !(this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SchemaResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SchemaDTO $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        return result;
    }
}

